// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListConnectorEntitiesRequest private constructor(builder: Builder) {
    /**
     * The version of the API that's used by the connector.
     */
    public val apiVersion: kotlin.String? = builder.apiVersion
    /**
     * The name of the connector profile. The name is unique for each `ConnectorProfile` in the Amazon Web Services account, and is used to query the downstream connector.
     */
    public val connectorProfileName: kotlin.String? = builder.connectorProfileName
    /**
     * The type of connector, such as Salesforce, Amplitude, and so on.
     */
    public val connectorType: aws.sdk.kotlin.services.appflow.model.ConnectorType? = builder.connectorType
    /**
     * This optional parameter is specific to connector implementation. Some connectors support multiple levels or categories of entities. You can find out the list of roots for such providers by sending a request without the `entitiesPath` parameter. If the connector supports entities at different roots, this initial request returns the list of roots. Otherwise, this request returns all entities supported by the provider.
     */
    public val entitiesPath: kotlin.String? = builder.entitiesPath
    /**
     * The maximum number of items that the operation returns in the response.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * A token that was provided by your prior `ListConnectorEntities` operation if the response was too big for the page size. You specify this token to get the next page of results in paginated response.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.ListConnectorEntitiesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListConnectorEntitiesRequest(")
        append("apiVersion=$apiVersion,")
        append("connectorProfileName=$connectorProfileName,")
        append("connectorType=$connectorType,")
        append("entitiesPath=$entitiesPath,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiVersion?.hashCode() ?: 0
        result = 31 * result + (connectorProfileName?.hashCode() ?: 0)
        result = 31 * result + (connectorType?.hashCode() ?: 0)
        result = 31 * result + (entitiesPath?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListConnectorEntitiesRequest

        if (apiVersion != other.apiVersion) return false
        if (connectorProfileName != other.connectorProfileName) return false
        if (connectorType != other.connectorType) return false
        if (entitiesPath != other.entitiesPath) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.ListConnectorEntitiesRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The version of the API that's used by the connector.
         */
        public var apiVersion: kotlin.String? = null
        /**
         * The name of the connector profile. The name is unique for each `ConnectorProfile` in the Amazon Web Services account, and is used to query the downstream connector.
         */
        public var connectorProfileName: kotlin.String? = null
        /**
         * The type of connector, such as Salesforce, Amplitude, and so on.
         */
        public var connectorType: aws.sdk.kotlin.services.appflow.model.ConnectorType? = null
        /**
         * This optional parameter is specific to connector implementation. Some connectors support multiple levels or categories of entities. You can find out the list of roots for such providers by sending a request without the `entitiesPath` parameter. If the connector supports entities at different roots, this initial request returns the list of roots. Otherwise, this request returns all entities supported by the provider.
         */
        public var entitiesPath: kotlin.String? = null
        /**
         * The maximum number of items that the operation returns in the response.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * A token that was provided by your prior `ListConnectorEntities` operation if the response was too big for the page size. You specify this token to get the next page of results in paginated response.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.ListConnectorEntitiesRequest) : this() {
            this.apiVersion = x.apiVersion
            this.connectorProfileName = x.connectorProfileName
            this.connectorType = x.connectorType
            this.entitiesPath = x.entitiesPath
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.ListConnectorEntitiesRequest = ListConnectorEntitiesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
