// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The connector-specific profile credentials required when using Salesforce.
 */
public class SalesforceConnectorProfileCredentials private constructor(builder: Builder) {
    /**
     * The credentials used to access protected Salesforce resources.
     */
    public val accessToken: kotlin.String? = builder.accessToken
    /**
     * The secret manager ARN, which contains the client ID and client secret of the connected app.
     */
    public val clientCredentialsArn: kotlin.String? = builder.clientCredentialsArn
    /**
     * A JSON web token (JWT) that authorizes Amazon AppFlow to access your Salesforce records.
     */
    public val jwtToken: kotlin.String? = builder.jwtToken
    /**
     * Specifies the OAuth 2.0 grant type that Amazon AppFlow uses when it requests an access token from Salesforce. Amazon AppFlow requires an access token each time it attempts to access your Salesforce records.
     *
     * You can specify one of the following values:
     *
     * ## AUTHORIZATION_CODE
     * Amazon AppFlow passes an authorization code when it requests the access token from Salesforce. Amazon AppFlow receives the authorization code from Salesforce after you log in to your Salesforce account and authorize Amazon AppFlow to access your records.
     *
     * ## JWT_BEARER
     * Amazon AppFlow passes a JSON web token (JWT) when it requests the access token from Salesforce. You provide the JWT to Amazon AppFlow when you define the connection to your Salesforce account. When you use this grant type, you don't need to log in to your Salesforce account to authorize Amazon AppFlow to access your records.
     *
     * The CLIENT_CREDENTIALS value is not supported for Salesforce.
     */
    public val oAuth2GrantType: aws.sdk.kotlin.services.appflow.model.OAuth2GrantType? = builder.oAuth2GrantType
    /**
     * The OAuth requirement needed to request security tokens from the connector endpoint.
     */
    public val oAuthRequest: aws.sdk.kotlin.services.appflow.model.ConnectorOAuthRequest? = builder.oAuthRequest
    /**
     * The credentials used to acquire new access tokens.
     */
    public val refreshToken: kotlin.String? = builder.refreshToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.SalesforceConnectorProfileCredentials = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SalesforceConnectorProfileCredentials(")
        append("accessToken=*** Sensitive Data Redacted ***,")
        append("clientCredentialsArn=*** Sensitive Data Redacted ***,")
        append("jwtToken=*** Sensitive Data Redacted ***,")
        append("oAuth2GrantType=$oAuth2GrantType,")
        append("oAuthRequest=$oAuthRequest,")
        append("refreshToken=$refreshToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessToken?.hashCode() ?: 0
        result = 31 * result + (clientCredentialsArn?.hashCode() ?: 0)
        result = 31 * result + (jwtToken?.hashCode() ?: 0)
        result = 31 * result + (oAuth2GrantType?.hashCode() ?: 0)
        result = 31 * result + (oAuthRequest?.hashCode() ?: 0)
        result = 31 * result + (refreshToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SalesforceConnectorProfileCredentials

        if (accessToken != other.accessToken) return false
        if (clientCredentialsArn != other.clientCredentialsArn) return false
        if (jwtToken != other.jwtToken) return false
        if (oAuth2GrantType != other.oAuth2GrantType) return false
        if (oAuthRequest != other.oAuthRequest) return false
        if (refreshToken != other.refreshToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.SalesforceConnectorProfileCredentials = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The credentials used to access protected Salesforce resources.
         */
        public var accessToken: kotlin.String? = null
        /**
         * The secret manager ARN, which contains the client ID and client secret of the connected app.
         */
        public var clientCredentialsArn: kotlin.String? = null
        /**
         * A JSON web token (JWT) that authorizes Amazon AppFlow to access your Salesforce records.
         */
        public var jwtToken: kotlin.String? = null
        /**
         * Specifies the OAuth 2.0 grant type that Amazon AppFlow uses when it requests an access token from Salesforce. Amazon AppFlow requires an access token each time it attempts to access your Salesforce records.
         *
         * You can specify one of the following values:
         *
         * ## AUTHORIZATION_CODE
         * Amazon AppFlow passes an authorization code when it requests the access token from Salesforce. Amazon AppFlow receives the authorization code from Salesforce after you log in to your Salesforce account and authorize Amazon AppFlow to access your records.
         *
         * ## JWT_BEARER
         * Amazon AppFlow passes a JSON web token (JWT) when it requests the access token from Salesforce. You provide the JWT to Amazon AppFlow when you define the connection to your Salesforce account. When you use this grant type, you don't need to log in to your Salesforce account to authorize Amazon AppFlow to access your records.
         *
         * The CLIENT_CREDENTIALS value is not supported for Salesforce.
         */
        public var oAuth2GrantType: aws.sdk.kotlin.services.appflow.model.OAuth2GrantType? = null
        /**
         * The OAuth requirement needed to request security tokens from the connector endpoint.
         */
        public var oAuthRequest: aws.sdk.kotlin.services.appflow.model.ConnectorOAuthRequest? = null
        /**
         * The credentials used to acquire new access tokens.
         */
        public var refreshToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.SalesforceConnectorProfileCredentials) : this() {
            this.accessToken = x.accessToken
            this.clientCredentialsArn = x.clientCredentialsArn
            this.jwtToken = x.jwtToken
            this.oAuth2GrantType = x.oAuth2GrantType
            this.oAuthRequest = x.oAuthRequest
            this.refreshToken = x.refreshToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.SalesforceConnectorProfileCredentials = SalesforceConnectorProfileCredentials(this)

        /**
         * construct an [aws.sdk.kotlin.services.appflow.model.ConnectorOAuthRequest] inside the given [block]
         */
        public fun oAuthRequest(block: aws.sdk.kotlin.services.appflow.model.ConnectorOAuthRequest.Builder.() -> kotlin.Unit) {
            this.oAuthRequest = aws.sdk.kotlin.services.appflow.model.ConnectorOAuthRequest.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
