// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The properties of the flow, such as its source, destination, trigger type, and so on.
 */
public class FlowDefinition private constructor(builder: Builder) {
    /**
     * Specifies when the flow was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The ARN of the user who created the flow.
     */
    public val createdBy: kotlin.String? = builder.createdBy
    /**
     * A user-entered description of the flow.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The label of the destination connector in the flow.
     */
    public val destinationConnectorLabel: kotlin.String? = builder.destinationConnectorLabel
    /**
     * Specifies the destination connector type, such as Salesforce, Amazon S3, Amplitude, and so on.
     */
    public val destinationConnectorType: aws.sdk.kotlin.services.appflow.model.ConnectorType? = builder.destinationConnectorType
    /**
     * The flow's Amazon Resource Name (ARN).
     */
    public val flowArn: kotlin.String? = builder.flowArn
    /**
     * The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only.
     */
    public val flowName: kotlin.String? = builder.flowName
    /**
     * Indicates the current status of the flow.
     */
    public val flowStatus: aws.sdk.kotlin.services.appflow.model.FlowStatus? = builder.flowStatus
    /**
     * Describes the details of the most recent flow run.
     */
    public val lastRunExecutionDetails: aws.sdk.kotlin.services.appflow.model.ExecutionDetails? = builder.lastRunExecutionDetails
    /**
     * Specifies when the flow was last updated.
     */
    public val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedAt
    /**
     * Specifies the account user name that most recently updated the flow.
     */
    public val lastUpdatedBy: kotlin.String? = builder.lastUpdatedBy
    /**
     * The label of the source connector in the flow.
     */
    public val sourceConnectorLabel: kotlin.String? = builder.sourceConnectorLabel
    /**
     * Specifies the source connector type, such as Salesforce, Amazon S3, Amplitude, and so on.
     */
    public val sourceConnectorType: aws.sdk.kotlin.services.appflow.model.ConnectorType? = builder.sourceConnectorType
    /**
     * The tags used to organize, track, or control access for your flow.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * Specifies the type of flow trigger. This can be `OnDemand`, `Scheduled`, or `Event`.
     */
    public val triggerType: aws.sdk.kotlin.services.appflow.model.TriggerType? = builder.triggerType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.FlowDefinition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FlowDefinition(")
        append("createdAt=$createdAt,")
        append("createdBy=$createdBy,")
        append("description=$description,")
        append("destinationConnectorLabel=$destinationConnectorLabel,")
        append("destinationConnectorType=$destinationConnectorType,")
        append("flowArn=$flowArn,")
        append("flowName=$flowName,")
        append("flowStatus=$flowStatus,")
        append("lastRunExecutionDetails=$lastRunExecutionDetails,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("lastUpdatedBy=$lastUpdatedBy,")
        append("sourceConnectorLabel=$sourceConnectorLabel,")
        append("sourceConnectorType=$sourceConnectorType,")
        append("tags=$tags,")
        append("triggerType=$triggerType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt?.hashCode() ?: 0
        result = 31 * result + (createdBy?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (destinationConnectorLabel?.hashCode() ?: 0)
        result = 31 * result + (destinationConnectorType?.hashCode() ?: 0)
        result = 31 * result + (flowArn?.hashCode() ?: 0)
        result = 31 * result + (flowName?.hashCode() ?: 0)
        result = 31 * result + (flowStatus?.hashCode() ?: 0)
        result = 31 * result + (lastRunExecutionDetails?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedBy?.hashCode() ?: 0)
        result = 31 * result + (sourceConnectorLabel?.hashCode() ?: 0)
        result = 31 * result + (sourceConnectorType?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (triggerType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FlowDefinition

        if (createdAt != other.createdAt) return false
        if (createdBy != other.createdBy) return false
        if (description != other.description) return false
        if (destinationConnectorLabel != other.destinationConnectorLabel) return false
        if (destinationConnectorType != other.destinationConnectorType) return false
        if (flowArn != other.flowArn) return false
        if (flowName != other.flowName) return false
        if (flowStatus != other.flowStatus) return false
        if (lastRunExecutionDetails != other.lastRunExecutionDetails) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (lastUpdatedBy != other.lastUpdatedBy) return false
        if (sourceConnectorLabel != other.sourceConnectorLabel) return false
        if (sourceConnectorType != other.sourceConnectorType) return false
        if (tags != other.tags) return false
        if (triggerType != other.triggerType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.FlowDefinition = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies when the flow was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN of the user who created the flow.
         */
        public var createdBy: kotlin.String? = null
        /**
         * A user-entered description of the flow.
         */
        public var description: kotlin.String? = null
        /**
         * The label of the destination connector in the flow.
         */
        public var destinationConnectorLabel: kotlin.String? = null
        /**
         * Specifies the destination connector type, such as Salesforce, Amazon S3, Amplitude, and so on.
         */
        public var destinationConnectorType: aws.sdk.kotlin.services.appflow.model.ConnectorType? = null
        /**
         * The flow's Amazon Resource Name (ARN).
         */
        public var flowArn: kotlin.String? = null
        /**
         * The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only.
         */
        public var flowName: kotlin.String? = null
        /**
         * Indicates the current status of the flow.
         */
        public var flowStatus: aws.sdk.kotlin.services.appflow.model.FlowStatus? = null
        /**
         * Describes the details of the most recent flow run.
         */
        public var lastRunExecutionDetails: aws.sdk.kotlin.services.appflow.model.ExecutionDetails? = null
        /**
         * Specifies when the flow was last updated.
         */
        public var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies the account user name that most recently updated the flow.
         */
        public var lastUpdatedBy: kotlin.String? = null
        /**
         * The label of the source connector in the flow.
         */
        public var sourceConnectorLabel: kotlin.String? = null
        /**
         * Specifies the source connector type, such as Salesforce, Amazon S3, Amplitude, and so on.
         */
        public var sourceConnectorType: aws.sdk.kotlin.services.appflow.model.ConnectorType? = null
        /**
         * The tags used to organize, track, or control access for your flow.
         */
        public var tags: Map<String, String>? = null
        /**
         * Specifies the type of flow trigger. This can be `OnDemand`, `Scheduled`, or `Event`.
         */
        public var triggerType: aws.sdk.kotlin.services.appflow.model.TriggerType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.FlowDefinition) : this() {
            this.createdAt = x.createdAt
            this.createdBy = x.createdBy
            this.description = x.description
            this.destinationConnectorLabel = x.destinationConnectorLabel
            this.destinationConnectorType = x.destinationConnectorType
            this.flowArn = x.flowArn
            this.flowName = x.flowName
            this.flowStatus = x.flowStatus
            this.lastRunExecutionDetails = x.lastRunExecutionDetails
            this.lastUpdatedAt = x.lastUpdatedAt
            this.lastUpdatedBy = x.lastUpdatedBy
            this.sourceConnectorLabel = x.sourceConnectorLabel
            this.sourceConnectorType = x.sourceConnectorType
            this.tags = x.tags
            this.triggerType = x.triggerType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.FlowDefinition = FlowDefinition(this)

        /**
         * construct an [aws.sdk.kotlin.services.appflow.model.ExecutionDetails] inside the given [block]
         */
        public fun lastRunExecutionDetails(block: aws.sdk.kotlin.services.appflow.model.ExecutionDetails.Builder.() -> kotlin.Unit) {
            this.lastRunExecutionDetails = aws.sdk.kotlin.services.appflow.model.ExecutionDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
