// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appintegrations

import aws.sdk.kotlin.runtime.auth.AuthConfig
import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.endpoint.EndpointResolver
import aws.sdk.kotlin.runtime.regions.RegionConfig
import aws.sdk.kotlin.services.appintegrations.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine

/**
 * The Amazon AppIntegrations service enables you to configure and reuse connections to external applications.
 * For information about how you can use external applications with Amazon Connect, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/crm.html">Set up pre-built integrations in the Amazon Connect Administrator Guide.
 */
interface AppIntegrationsClient : SdkClient {

    override val serviceName: String
        get() = "AppIntegrations"
    /**
     * AppIntegrationsClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.DslBuilder.() -> Unit = {}): AppIntegrationsClient {
            val config = Config.BuilderImpl().apply(block).build()
            return DefaultAppIntegrationsClient(config)
        }
    }

    class Config private constructor(builder: BuilderImpl): AuthConfig, HttpClientConfig, IdempotencyTokenConfig, RegionConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider? = builder.credentialsProvider
        val endpointResolver: EndpointResolver? = builder.endpointResolver
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        override val region: String? = builder.region
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        override val signingRegion: String? = builder.signingRegion

        interface FluentBuilder {
            fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder
            fun endpointResolver(endpointResolver: EndpointResolver): FluentBuilder
            fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder
            fun idempotencyTokenProvider(idempotencyTokenProvider: IdempotencyTokenProvider): FluentBuilder
            fun region(region: String): FluentBuilder
            fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder
            fun signingRegion(signingRegion: String): FluentBuilder
            fun build(): Config
        }

        interface DslBuilder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider?

            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: EndpointResolver?

            /**
             * Override the default HTTP client configuration (e.g. configure proxy behavior, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine?

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            var idempotencyTokenProvider: IdempotencyTokenProvider?

            /**
             * AWS region to make requests to
             */
            var region: String?

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode

            /**
             * AWS region to be used for signing the request. This is not necessarily the same as `region`
             * in the case of global services like IAM
             */
            var signingRegion: String?

            fun build(): Config
        }

        internal class BuilderImpl() : FluentBuilder, DslBuilder {
            override var credentialsProvider: CredentialsProvider? = null
            override var endpointResolver: EndpointResolver? = null
            override var httpClientEngine: HttpClientEngine? = null
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            override var region: String? = null
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default
            override var signingRegion: String? = null

            override fun build(): Config = Config(this)
            override fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder = apply { this.credentialsProvider = credentialsProvider }
            override fun endpointResolver(endpointResolver: EndpointResolver): FluentBuilder = apply { this.endpointResolver = endpointResolver }
            override fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder = apply { this.httpClientEngine = httpClientEngine }
            override fun idempotencyTokenProvider(idempotencyTokenProvider: IdempotencyTokenProvider): FluentBuilder = apply { this.idempotencyTokenProvider = idempotencyTokenProvider }
            override fun region(region: String): FluentBuilder = apply { this.region = region }
            override fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder = apply { this.sdkLogMode = sdkLogMode }
            override fun signingRegion(signingRegion: String): FluentBuilder = apply { this.signingRegion = signingRegion }
        }
    }

    /**
     * Creates an EventIntegration, given a specified name, description, and a reference to an
     * Amazon EventBridge bus in your account and a partner event source that pushes events to that bus. No
     * objects are created in the your account, only metadata that is persisted on the EventIntegration
     * control plane.
     */
    suspend fun createEventIntegration(input: CreateEventIntegrationRequest): CreateEventIntegrationResponse

    /**
     * Creates an EventIntegration, given a specified name, description, and a reference to an
     * Amazon EventBridge bus in your account and a partner event source that pushes events to that bus. No
     * objects are created in the your account, only metadata that is persisted on the EventIntegration
     * control plane.
     */
    suspend fun createEventIntegration(block: CreateEventIntegrationRequest.DslBuilder.() -> Unit) = createEventIntegration(CreateEventIntegrationRequest.builder().apply(block).build())

    /**
     * Deletes the specified existing event integration. If the event integration is associated
     * with clients, the request is rejected.
     */
    suspend fun deleteEventIntegration(input: DeleteEventIntegrationRequest): DeleteEventIntegrationResponse

    /**
     * Deletes the specified existing event integration. If the event integration is associated
     * with clients, the request is rejected.
     */
    suspend fun deleteEventIntegration(block: DeleteEventIntegrationRequest.DslBuilder.() -> Unit) = deleteEventIntegration(DeleteEventIntegrationRequest.builder().apply(block).build())

    /**
     * Return information about the event integration.
     */
    suspend fun getEventIntegration(input: GetEventIntegrationRequest): GetEventIntegrationResponse

    /**
     * Return information about the event integration.
     */
    suspend fun getEventIntegration(block: GetEventIntegrationRequest.DslBuilder.() -> Unit) = getEventIntegration(GetEventIntegrationRequest.builder().apply(block).build())

    /**
     * Returns a paginated list of event integration associations in the account.
     */
    suspend fun listEventIntegrationAssociations(input: ListEventIntegrationAssociationsRequest): ListEventIntegrationAssociationsResponse

    /**
     * Returns a paginated list of event integration associations in the account.
     */
    suspend fun listEventIntegrationAssociations(block: ListEventIntegrationAssociationsRequest.DslBuilder.() -> Unit) = listEventIntegrationAssociations(ListEventIntegrationAssociationsRequest.builder().apply(block).build())

    /**
     * Returns a paginated list of event integrations in the account.
     */
    suspend fun listEventIntegrations(input: ListEventIntegrationsRequest): ListEventIntegrationsResponse

    /**
     * Returns a paginated list of event integrations in the account.
     */
    suspend fun listEventIntegrations(block: ListEventIntegrationsRequest.DslBuilder.() -> Unit) = listEventIntegrations(ListEventIntegrationsRequest.builder().apply(block).build())

    /**
     * Lists the tags for the specified resource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists the tags for the specified resource.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.DslBuilder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.builder().apply(block).build())

    /**
     * Adds the specified tags to the specified resource.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Adds the specified tags to the specified resource.
     */
    suspend fun tagResource(block: TagResourceRequest.DslBuilder.() -> Unit) = tagResource(TagResourceRequest.builder().apply(block).build())

    /**
     * Removes the specified tags from the specified resource.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes the specified tags from the specified resource.
     */
    suspend fun untagResource(block: UntagResourceRequest.DslBuilder.() -> Unit) = untagResource(UntagResourceRequest.builder().apply(block).build())

    /**
     * Updates the description of an event integration.
     */
    suspend fun updateEventIntegration(input: UpdateEventIntegrationRequest): UpdateEventIntegrationResponse

    /**
     * Updates the description of an event integration.
     */
    suspend fun updateEventIntegration(block: UpdateEventIntegrationRequest.DslBuilder.() -> Unit) = updateEventIntegration(UpdateEventIntegrationRequest.builder().apply(block).build())
}
