// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appintegrations

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.execution.AuthAttributes
import aws.sdk.kotlin.runtime.http.engine.crt.CrtHttpEngine
import aws.sdk.kotlin.runtime.regions.resolveRegionForOperation
import aws.sdk.kotlin.services.appintegrations.model.*
import aws.sdk.kotlin.services.appintegrations.transform.*
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngineConfig
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "AppIntegrations"
const val ServiceApiVersion: String = "2020-07-29"
const val SdkVersion: String = "0.6.0-alpha"

internal class DefaultAppIntegrationsClient(override val config: AppIntegrationsClient.Config) : AppIntegrationsClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: CrtHttpEngine(HttpClientEngineConfig())
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }

    /**
     * Creates an EventIntegration, given a specified name, description, and a reference to an
     * Amazon EventBridge bus in your account and a partner event source that pushes events to that bus. No
     * objects are created in the your account, only metadata that is persisted on the EventIntegration
     * control plane.
     */
    override suspend fun createEventIntegration(input: CreateEventIntegrationRequest): CreateEventIntegrationResponse {
        val op = SdkHttpOperation.build<CreateEventIntegrationRequest, CreateEventIntegrationResponse> {
            serializer = CreateEventIntegrationOperationSerializer()
            deserializer = CreateEventIntegrationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateEventIntegration"
            }
        }
        registerCreateEventIntegrationMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified existing event integration. If the event integration is associated
     * with clients, the request is rejected.
     */
    override suspend fun deleteEventIntegration(input: DeleteEventIntegrationRequest): DeleteEventIntegrationResponse {
        val op = SdkHttpOperation.build<DeleteEventIntegrationRequest, DeleteEventIntegrationResponse> {
            serializer = DeleteEventIntegrationOperationSerializer()
            deserializer = DeleteEventIntegrationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteEventIntegration"
            }
        }
        registerDeleteEventIntegrationMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Return information about the event integration.
     */
    override suspend fun getEventIntegration(input: GetEventIntegrationRequest): GetEventIntegrationResponse {
        val op = SdkHttpOperation.build<GetEventIntegrationRequest, GetEventIntegrationResponse> {
            serializer = GetEventIntegrationOperationSerializer()
            deserializer = GetEventIntegrationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetEventIntegration"
            }
        }
        registerGetEventIntegrationMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a paginated list of event integration associations in the account.
     */
    override suspend fun listEventIntegrationAssociations(input: ListEventIntegrationAssociationsRequest): ListEventIntegrationAssociationsResponse {
        val op = SdkHttpOperation.build<ListEventIntegrationAssociationsRequest, ListEventIntegrationAssociationsResponse> {
            serializer = ListEventIntegrationAssociationsOperationSerializer()
            deserializer = ListEventIntegrationAssociationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListEventIntegrationAssociations"
            }
        }
        registerListEventIntegrationAssociationsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a paginated list of event integrations in the account.
     */
    override suspend fun listEventIntegrations(input: ListEventIntegrationsRequest): ListEventIntegrationsResponse {
        val op = SdkHttpOperation.build<ListEventIntegrationsRequest, ListEventIntegrationsResponse> {
            serializer = ListEventIntegrationsOperationSerializer()
            deserializer = ListEventIntegrationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListEventIntegrations"
            }
        }
        registerListEventIntegrationsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the tags for the specified resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        registerListTagsForResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Adds the specified tags to the specified resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        registerTagResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Removes the specified tags from the specified resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        registerUntagResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the description of an event integration.
     */
    override suspend fun updateEventIntegration(input: UpdateEventIntegrationRequest): UpdateEventIntegrationResponse {
        val op = SdkHttpOperation.build<UpdateEventIntegrationRequest, UpdateEventIntegrationResponse> {
            serializer = UpdateEventIntegrationOperationSerializer()
            deserializer = UpdateEventIntegrationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateEventIntegration"
            }
        }
        registerUpdateEventIntegrationMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        val region = resolveRegionForOperation(ctx, config)
        ctx.putIfAbsent(AwsClientOption.Region, region)
        ctx.putIfAbsent(AuthAttributes.SigningRegion, config.signingRegion ?: region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
