// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appintegrations.model



/**
 * The event integration.
 */
class EventIntegration private constructor(builder: BuilderImpl) {
    /**
     * The event integration description.
     */
    val description: String? = builder.description
    /**
     * The Amazon EventBridge bus for the event integration.
     */
    val eventBridgeBus: String? = builder.eventBridgeBus
    /**
     * The event integration filter.
     */
    val eventFilter: EventFilter? = builder.eventFilter
    /**
     * The Amazon Resource Name (ARN) of the event integration.
     */
    val eventIntegrationArn: String? = builder.eventIntegrationArn
    /**
     * The name of the event integration.
     */
    val name: String? = builder.name
    /**
     * The tags.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): EventIntegration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("EventIntegration(")
        append("description=$description,")
        append("eventBridgeBus=$eventBridgeBus,")
        append("eventFilter=$eventFilter,")
        append("eventIntegrationArn=$eventIntegrationArn,")
        append("name=$name,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (eventBridgeBus?.hashCode() ?: 0)
        result = 31 * result + (eventFilter?.hashCode() ?: 0)
        result = 31 * result + (eventIntegrationArn?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as EventIntegration

        if (description != other.description) return false
        if (eventBridgeBus != other.eventBridgeBus) return false
        if (eventFilter != other.eventFilter) return false
        if (eventIntegrationArn != other.eventIntegrationArn) return false
        if (name != other.name) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): EventIntegration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): EventIntegration
        /**
         * The event integration description.
         */
        fun description(description: String): FluentBuilder
        /**
         * The Amazon EventBridge bus for the event integration.
         */
        fun eventBridgeBus(eventBridgeBus: String): FluentBuilder
        /**
         * The event integration filter.
         */
        fun eventFilter(eventFilter: EventFilter): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the event integration.
         */
        fun eventIntegrationArn(eventIntegrationArn: String): FluentBuilder
        /**
         * The name of the event integration.
         */
        fun name(name: String): FluentBuilder
        /**
         * The tags.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The event integration description.
         */
        var description: String?
        /**
         * The Amazon EventBridge bus for the event integration.
         */
        var eventBridgeBus: String?
        /**
         * The event integration filter.
         */
        var eventFilter: EventFilter?
        /**
         * The Amazon Resource Name (ARN) of the event integration.
         */
        var eventIntegrationArn: String?
        /**
         * The name of the event integration.
         */
        var name: String?
        /**
         * The tags.
         */
        var tags: Map<String, String>?

        fun build(): EventIntegration
        /**
         * construct an [aws.sdk.kotlin.services.appintegrations.model.EventFilter] inside the given [block]
         */
        fun eventFilter(block: EventFilter.DslBuilder.() -> kotlin.Unit) {
            this.eventFilter = EventFilter.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var description: String? = null
        override var eventBridgeBus: String? = null
        override var eventFilter: EventFilter? = null
        override var eventIntegrationArn: String? = null
        override var name: String? = null
        override var tags: Map<String, String>? = null

        constructor(x: EventIntegration) : this() {
            this.description = x.description
            this.eventBridgeBus = x.eventBridgeBus
            this.eventFilter = x.eventFilter
            this.eventIntegrationArn = x.eventIntegrationArn
            this.name = x.name
            this.tags = x.tags
        }

        override fun build(): EventIntegration = EventIntegration(this)
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun eventBridgeBus(eventBridgeBus: String): FluentBuilder = apply { this.eventBridgeBus = eventBridgeBus }
        override fun eventFilter(eventFilter: EventFilter): FluentBuilder = apply { this.eventFilter = eventFilter }
        override fun eventIntegrationArn(eventIntegrationArn: String): FluentBuilder = apply { this.eventIntegrationArn = eventIntegrationArn }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
    }
}
