// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationautoscaling.model



class DescribeScalableTargetsRequest private constructor(builder: Builder) {
    /**
     * The maximum number of scalable targets. This value can be between 1 and
     * 50. The default value is 50.
     * If this parameter is used, the operation returns up to MaxResults results
     * at a time, along with a NextToken value. To get the next set of results,
     * include the NextToken value in a subsequent call. If this parameter is not
     * used, the operation returns up to 50 results and a
     * NextToken value, if applicable.
     */
    val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token for the next set of results.
     */
    val nextToken: kotlin.String? = builder.nextToken
    /**
     * The identifier of the resource associated with the scalable target.
     * This string consists of the resource type and unique identifier.
     * ECS service - The resource type is service and the unique identifier is the cluster name
     * and service name. Example: service/default/sample-webapp.
     * Spot Fleet - The resource type is spot-fleet-request and the unique identifier is the
     * Spot Fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
     * EMR cluster - The resource type is instancegroup and the unique identifier is the cluster ID and instance group ID.
     * Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.
     * AppStream 2.0 fleet - The resource type is fleet and the unique identifier is the fleet name.
     * Example: fleet/sample-fleet.
     * DynamoDB table - The resource type is table and the unique identifier is the table name.
     * Example: table/my-table.
     * DynamoDB global secondary index - The resource type is index and the unique identifier is the index name.
     * Example: table/my-table/index/my-table-index.
     * Aurora DB cluster - The resource type is cluster and the unique identifier is the cluster name.
     * Example: cluster:my-db-cluster.
     * SageMaker endpoint variant - The resource type is variant and the unique identifier is the resource ID.
     * Example: endpoint/my-end-point/variant/KMeansClustering.
     * Custom resources are not supported with a resource type. This parameter must specify the OutputValue from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information
     * is available in our <a href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub
     * repository.
     * Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE.
     * Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE.
     * Lambda provisioned concurrency - The resource type is function and the unique identifier is the function name with a function version or alias name suffix that is not $LATEST.
     * Example: function:my-function:prod or function:my-function:1.
     * Amazon Keyspaces table - The resource type is table and the unique identifier is the table name.
     * Example: keyspace/mykeyspace/table/mytable.
     * Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN.
     * Example: arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5.
     * Amazon ElastiCache replication group - The resource type is replication-group and the unique identifier is the replication group name.
     * Example: replication-group/mycluster.
     * Neptune cluster - The resource type is cluster and the unique identifier is the cluster name. Example: cluster:mycluster.
     */
    val resourceIds: List<String>? = builder.resourceIds
    /**
     * The scalable dimension associated with the scalable target.
     * This string consists of the service namespace, resource type, and scaling property. If you specify a scalable dimension, you must also specify a resource ID.
     * ecs:service:DesiredCount - The desired task count of an ECS service.
     * elasticmapreduce:instancegroup:InstanceCount - The instance count of an EMR Instance Group.
     * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot Fleet.
     * appstream:fleet:DesiredCapacity - The desired capacity of an AppStream 2.0 fleet.
     * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for a DynamoDB table.
     * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for a DynamoDB table.
     * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for a DynamoDB global secondary index.
     * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for a DynamoDB global secondary index.
     * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
     * sagemaker:variant:DesiredInstanceCount - The number of EC2 instances for an SageMaker model endpoint variant.
     * custom-resource:ResourceType:Property - The scalable dimension for a custom resource provided by your own application or service.
     * comprehend:document-classifier-endpoint:DesiredInferenceUnits - The number of inference units for an Amazon Comprehend document classification endpoint.
     * comprehend:entity-recognizer-endpoint:DesiredInferenceUnits - The number of inference units for an Amazon Comprehend entity recognizer endpoint.
     * lambda:function:ProvisionedConcurrency - The provisioned concurrency for a Lambda function.
     * cassandra:table:ReadCapacityUnits - The provisioned read capacity for an Amazon Keyspaces table.
     * cassandra:table:WriteCapacityUnits - The provisioned write capacity for an Amazon Keyspaces table.
     * kafka:broker-storage:VolumeSize - The provisioned volume size (in GiB) for brokers in an Amazon MSK cluster.
     * elasticache:replication-group:NodeGroups - The number of node groups for an Amazon ElastiCache replication group.
     * elasticache:replication-group:Replicas - The number of replicas per node group for an Amazon ElastiCache replication group.
     * neptune:cluster:ReadReplicaCount - The count of read replicas in an Amazon Neptune DB cluster.
     */
    val scalableDimension: aws.sdk.kotlin.services.applicationautoscaling.model.ScalableDimension? = builder.scalableDimension
    /**
     * The namespace of the Amazon Web Services service that provides the resource. For a resource provided
     * by your own application or service, use custom-resource instead.
     */
    val serviceNamespace: aws.sdk.kotlin.services.applicationautoscaling.model.ServiceNamespace? = builder.serviceNamespace

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.applicationautoscaling.model.DescribeScalableTargetsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeScalableTargetsRequest(")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("resourceIds=$resourceIds,")
        append("scalableDimension=$scalableDimension,")
        append("serviceNamespace=$serviceNamespace)")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxResults ?: 0
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (resourceIds?.hashCode() ?: 0)
        result = 31 * result + (scalableDimension?.hashCode() ?: 0)
        result = 31 * result + (serviceNamespace?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeScalableTargetsRequest

        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (resourceIds != other.resourceIds) return false
        if (scalableDimension != other.scalableDimension) return false
        if (serviceNamespace != other.serviceNamespace) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.applicationautoscaling.model.DescribeScalableTargetsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The maximum number of scalable targets. This value can be between 1 and
         * 50. The default value is 50.
         * If this parameter is used, the operation returns up to MaxResults results
         * at a time, along with a NextToken value. To get the next set of results,
         * include the NextToken value in a subsequent call. If this parameter is not
         * used, the operation returns up to 50 results and a
         * NextToken value, if applicable.
         */
        var maxResults: kotlin.Int? = null
        /**
         * The token for the next set of results.
         */
        var nextToken: kotlin.String? = null
        /**
         * The identifier of the resource associated with the scalable target.
         * This string consists of the resource type and unique identifier.
         * ECS service - The resource type is service and the unique identifier is the cluster name
         * and service name. Example: service/default/sample-webapp.
         * Spot Fleet - The resource type is spot-fleet-request and the unique identifier is the
         * Spot Fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
         * EMR cluster - The resource type is instancegroup and the unique identifier is the cluster ID and instance group ID.
         * Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.
         * AppStream 2.0 fleet - The resource type is fleet and the unique identifier is the fleet name.
         * Example: fleet/sample-fleet.
         * DynamoDB table - The resource type is table and the unique identifier is the table name.
         * Example: table/my-table.
         * DynamoDB global secondary index - The resource type is index and the unique identifier is the index name.
         * Example: table/my-table/index/my-table-index.
         * Aurora DB cluster - The resource type is cluster and the unique identifier is the cluster name.
         * Example: cluster:my-db-cluster.
         * SageMaker endpoint variant - The resource type is variant and the unique identifier is the resource ID.
         * Example: endpoint/my-end-point/variant/KMeansClustering.
         * Custom resources are not supported with a resource type. This parameter must specify the OutputValue from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information
         * is available in our <a href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub
         * repository.
         * Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE.
         * Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE.
         * Lambda provisioned concurrency - The resource type is function and the unique identifier is the function name with a function version or alias name suffix that is not $LATEST.
         * Example: function:my-function:prod or function:my-function:1.
         * Amazon Keyspaces table - The resource type is table and the unique identifier is the table name.
         * Example: keyspace/mykeyspace/table/mytable.
         * Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN.
         * Example: arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5.
         * Amazon ElastiCache replication group - The resource type is replication-group and the unique identifier is the replication group name.
         * Example: replication-group/mycluster.
         * Neptune cluster - The resource type is cluster and the unique identifier is the cluster name. Example: cluster:mycluster.
         */
        var resourceIds: List<String>? = null
        /**
         * The scalable dimension associated with the scalable target.
         * This string consists of the service namespace, resource type, and scaling property. If you specify a scalable dimension, you must also specify a resource ID.
         * ecs:service:DesiredCount - The desired task count of an ECS service.
         * elasticmapreduce:instancegroup:InstanceCount - The instance count of an EMR Instance Group.
         * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot Fleet.
         * appstream:fleet:DesiredCapacity - The desired capacity of an AppStream 2.0 fleet.
         * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for a DynamoDB table.
         * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for a DynamoDB table.
         * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for a DynamoDB global secondary index.
         * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for a DynamoDB global secondary index.
         * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
         * sagemaker:variant:DesiredInstanceCount - The number of EC2 instances for an SageMaker model endpoint variant.
         * custom-resource:ResourceType:Property - The scalable dimension for a custom resource provided by your own application or service.
         * comprehend:document-classifier-endpoint:DesiredInferenceUnits - The number of inference units for an Amazon Comprehend document classification endpoint.
         * comprehend:entity-recognizer-endpoint:DesiredInferenceUnits - The number of inference units for an Amazon Comprehend entity recognizer endpoint.
         * lambda:function:ProvisionedConcurrency - The provisioned concurrency for a Lambda function.
         * cassandra:table:ReadCapacityUnits - The provisioned read capacity for an Amazon Keyspaces table.
         * cassandra:table:WriteCapacityUnits - The provisioned write capacity for an Amazon Keyspaces table.
         * kafka:broker-storage:VolumeSize - The provisioned volume size (in GiB) for brokers in an Amazon MSK cluster.
         * elasticache:replication-group:NodeGroups - The number of node groups for an Amazon ElastiCache replication group.
         * elasticache:replication-group:Replicas - The number of replicas per node group for an Amazon ElastiCache replication group.
         * neptune:cluster:ReadReplicaCount - The count of read replicas in an Amazon Neptune DB cluster.
         */
        var scalableDimension: aws.sdk.kotlin.services.applicationautoscaling.model.ScalableDimension? = null
        /**
         * The namespace of the Amazon Web Services service that provides the resource. For a resource provided
         * by your own application or service, use custom-resource instead.
         */
        var serviceNamespace: aws.sdk.kotlin.services.applicationautoscaling.model.ServiceNamespace? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.applicationautoscaling.model.DescribeScalableTargetsRequest) : this() {
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.resourceIds = x.resourceIds
            this.scalableDimension = x.scalableDimension
            this.serviceNamespace = x.serviceNamespace
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.applicationautoscaling.model.DescribeScalableTargetsRequest = DescribeScalableTargetsRequest(this)
    }
}
