// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationautoscaling.model



/**
 * Represents the minimum and maximum capacity for a scheduled action.
 */
class ScalableTargetAction private constructor(builder: Builder) {
    /**
     * The maximum capacity.
     * Although you can specify a large maximum capacity, note that service quotas may impose
     * lower limits. Each service has its own default quotas for the maximum capacity of the
     * resource. If you want to specify a higher limit, you can request an increase. For more
     * information, consult the documentation for that service. For information about the default
     * quotas for each service, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-service-information.html">Service Endpoints and
     * Quotas in the Amazon Web Services General Reference.
     */
    val maxCapacity: kotlin.Int? = builder.maxCapacity
    /**
     * The minimum capacity.
     * For certain resources, the minimum value allowed is 0. This includes Lambda provisioned
     * concurrency, Spot Fleet, ECS services, Aurora DB clusters, EMR clusters, and custom resources.
     * For all other resources, the minimum value allowed is 1.
     */
    val minCapacity: kotlin.Int? = builder.minCapacity

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.applicationautoscaling.model.ScalableTargetAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ScalableTargetAction(")
        append("maxCapacity=$maxCapacity,")
        append("minCapacity=$minCapacity)")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxCapacity ?: 0
        result = 31 * result + (minCapacity ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ScalableTargetAction

        if (maxCapacity != other.maxCapacity) return false
        if (minCapacity != other.minCapacity) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.applicationautoscaling.model.ScalableTargetAction = Builder(this).apply(block).build()

    class Builder {
        /**
         * The maximum capacity.
         * Although you can specify a large maximum capacity, note that service quotas may impose
         * lower limits. Each service has its own default quotas for the maximum capacity of the
         * resource. If you want to specify a higher limit, you can request an increase. For more
         * information, consult the documentation for that service. For information about the default
         * quotas for each service, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-service-information.html">Service Endpoints and
         * Quotas in the Amazon Web Services General Reference.
         */
        var maxCapacity: kotlin.Int? = null
        /**
         * The minimum capacity.
         * For certain resources, the minimum value allowed is 0. This includes Lambda provisioned
         * concurrency, Spot Fleet, ECS services, Aurora DB clusters, EMR clusters, and custom resources.
         * For all other resources, the minimum value allowed is 1.
         */
        var minCapacity: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.applicationautoscaling.model.ScalableTargetAction) : this() {
            this.maxCapacity = x.maxCapacity
            this.minCapacity = x.minCapacity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.applicationautoscaling.model.ScalableTargetAction = ScalableTargetAction(this)
    }
}
