// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationautoscaling.model



/**
 * Represents a target tracking scaling policy configuration to use with Application Auto Scaling.
 */
class TargetTrackingScalingPolicyConfiguration private constructor(builder: Builder) {
    /**
     * A customized metric. You can specify either a predefined metric or a customized
     * metric.
     */
    val customizedMetricSpecification: aws.sdk.kotlin.services.applicationautoscaling.model.CustomizedMetricSpecification? = builder.customizedMetricSpecification
    /**
     * Indicates whether scale in by the target tracking scaling policy is disabled. If the
     * value is true, scale in is disabled and the target tracking scaling policy
     * won't remove capacity from the scalable target. Otherwise, scale in is enabled and the
     * target tracking scaling policy can remove capacity from the scalable target. The default
     * value is false.
     */
    val disableScaleIn: kotlin.Boolean? = builder.disableScaleIn
    /**
     * A predefined metric. You can specify either a predefined metric or a customized
     * metric.
     */
    val predefinedMetricSpecification: aws.sdk.kotlin.services.applicationautoscaling.model.PredefinedMetricSpecification? = builder.predefinedMetricSpecification
    /**
     * The amount of time, in seconds, after a scale-in activity completes before another
     * scale-in activity can start.
     * With the scale-in cooldown period, the intention is to scale in
     * conservatively to protect your application’s availability, so scale-in activities are blocked
     * until the cooldown period has expired. However, if another alarm triggers a scale-out activity
     * during the scale-in cooldown period, Application Auto Scaling scales out the target immediately. In this case,
     * the scale-in cooldown period stops and doesn't complete.
     * Application Auto Scaling provides a default value of 600 for Amazon ElastiCache replication groups
     * and a default value of 300 for the following scalable targets:
     * AppStream 2.0 fleets
     * Aurora DB clusters
     * ECS services
     * EMR clusters
     * Neptune clusters
     * SageMaker endpoint variants
     * Spot Fleets
     * Custom resources
     * For all other scalable targets, the default value is 0:
     * Amazon Comprehend document classification and entity recognizer endpoints
     * DynamoDB tables and global secondary indexes
     * Amazon Keyspaces tables
     * Lambda provisioned concurrency
     * Amazon MSK broker storage
     */
    val scaleInCooldown: kotlin.Int? = builder.scaleInCooldown
    /**
     * The amount of time, in seconds, to wait for a previous scale-out activity to take
     * effect.
     * With the scale-out cooldown period, the intention is to continuously
     * (but not excessively) scale out. After Application Auto Scaling successfully scales out using a target
     * tracking scaling policy, it starts to calculate the cooldown time. The scaling policy won't
     * increase the desired capacity again unless either a larger scale out is triggered or the
     * cooldown period ends. While the cooldown period is in effect, the capacity added by the
     * initiating scale-out activity is calculated as part of the desired capacity for the next
     * scale-out activity.
     * Application Auto Scaling provides a default value of 600 for Amazon ElastiCache replication groups
     * and a default value of 300 for the following scalable targets:
     * AppStream 2.0 fleets
     * Aurora DB clusters
     * ECS services
     * EMR clusters
     * Neptune clusters
     * SageMaker endpoint variants
     * Spot Fleets
     * Custom resources
     * For all other scalable targets, the default value is 0:
     * Amazon Comprehend document classification and entity recognizer endpoints
     * DynamoDB tables and global secondary indexes
     * Amazon Keyspaces tables
     * Lambda provisioned concurrency
     * Amazon MSK broker storage
     */
    val scaleOutCooldown: kotlin.Int? = builder.scaleOutCooldown
    /**
     * The target value for the metric. Although this property accepts numbers of type Double,
     * it won't accept values that are either too small or too large. Values must be in the range
     * of -2^360 to 2^360. The value must be a valid number based on the choice of metric. For
     * example, if the metric is CPU utilization, then the target value is a percent value that
     * represents how much of the CPU can be used before scaling out.
     */
    val targetValue: kotlin.Double? = builder.targetValue

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.applicationautoscaling.model.TargetTrackingScalingPolicyConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TargetTrackingScalingPolicyConfiguration(")
        append("customizedMetricSpecification=$customizedMetricSpecification,")
        append("disableScaleIn=$disableScaleIn,")
        append("predefinedMetricSpecification=$predefinedMetricSpecification,")
        append("scaleInCooldown=$scaleInCooldown,")
        append("scaleOutCooldown=$scaleOutCooldown,")
        append("targetValue=$targetValue)")
    }

    override fun hashCode(): kotlin.Int {
        var result = customizedMetricSpecification?.hashCode() ?: 0
        result = 31 * result + (disableScaleIn?.hashCode() ?: 0)
        result = 31 * result + (predefinedMetricSpecification?.hashCode() ?: 0)
        result = 31 * result + (scaleInCooldown ?: 0)
        result = 31 * result + (scaleOutCooldown ?: 0)
        result = 31 * result + (targetValue?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TargetTrackingScalingPolicyConfiguration

        if (customizedMetricSpecification != other.customizedMetricSpecification) return false
        if (disableScaleIn != other.disableScaleIn) return false
        if (predefinedMetricSpecification != other.predefinedMetricSpecification) return false
        if (scaleInCooldown != other.scaleInCooldown) return false
        if (scaleOutCooldown != other.scaleOutCooldown) return false
        if (targetValue != other.targetValue) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.applicationautoscaling.model.TargetTrackingScalingPolicyConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * A customized metric. You can specify either a predefined metric or a customized
         * metric.
         */
        var customizedMetricSpecification: aws.sdk.kotlin.services.applicationautoscaling.model.CustomizedMetricSpecification? = null
        /**
         * Indicates whether scale in by the target tracking scaling policy is disabled. If the
         * value is true, scale in is disabled and the target tracking scaling policy
         * won't remove capacity from the scalable target. Otherwise, scale in is enabled and the
         * target tracking scaling policy can remove capacity from the scalable target. The default
         * value is false.
         */
        var disableScaleIn: kotlin.Boolean? = null
        /**
         * A predefined metric. You can specify either a predefined metric or a customized
         * metric.
         */
        var predefinedMetricSpecification: aws.sdk.kotlin.services.applicationautoscaling.model.PredefinedMetricSpecification? = null
        /**
         * The amount of time, in seconds, after a scale-in activity completes before another
         * scale-in activity can start.
         * With the scale-in cooldown period, the intention is to scale in
         * conservatively to protect your application’s availability, so scale-in activities are blocked
         * until the cooldown period has expired. However, if another alarm triggers a scale-out activity
         * during the scale-in cooldown period, Application Auto Scaling scales out the target immediately. In this case,
         * the scale-in cooldown period stops and doesn't complete.
         * Application Auto Scaling provides a default value of 600 for Amazon ElastiCache replication groups
         * and a default value of 300 for the following scalable targets:
         * AppStream 2.0 fleets
         * Aurora DB clusters
         * ECS services
         * EMR clusters
         * Neptune clusters
         * SageMaker endpoint variants
         * Spot Fleets
         * Custom resources
         * For all other scalable targets, the default value is 0:
         * Amazon Comprehend document classification and entity recognizer endpoints
         * DynamoDB tables and global secondary indexes
         * Amazon Keyspaces tables
         * Lambda provisioned concurrency
         * Amazon MSK broker storage
         */
        var scaleInCooldown: kotlin.Int? = null
        /**
         * The amount of time, in seconds, to wait for a previous scale-out activity to take
         * effect.
         * With the scale-out cooldown period, the intention is to continuously
         * (but not excessively) scale out. After Application Auto Scaling successfully scales out using a target
         * tracking scaling policy, it starts to calculate the cooldown time. The scaling policy won't
         * increase the desired capacity again unless either a larger scale out is triggered or the
         * cooldown period ends. While the cooldown period is in effect, the capacity added by the
         * initiating scale-out activity is calculated as part of the desired capacity for the next
         * scale-out activity.
         * Application Auto Scaling provides a default value of 600 for Amazon ElastiCache replication groups
         * and a default value of 300 for the following scalable targets:
         * AppStream 2.0 fleets
         * Aurora DB clusters
         * ECS services
         * EMR clusters
         * Neptune clusters
         * SageMaker endpoint variants
         * Spot Fleets
         * Custom resources
         * For all other scalable targets, the default value is 0:
         * Amazon Comprehend document classification and entity recognizer endpoints
         * DynamoDB tables and global secondary indexes
         * Amazon Keyspaces tables
         * Lambda provisioned concurrency
         * Amazon MSK broker storage
         */
        var scaleOutCooldown: kotlin.Int? = null
        /**
         * The target value for the metric. Although this property accepts numbers of type Double,
         * it won't accept values that are either too small or too large. Values must be in the range
         * of -2^360 to 2^360. The value must be a valid number based on the choice of metric. For
         * example, if the metric is CPU utilization, then the target value is a percent value that
         * represents how much of the CPU can be used before scaling out.
         */
        var targetValue: kotlin.Double? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.applicationautoscaling.model.TargetTrackingScalingPolicyConfiguration) : this() {
            this.customizedMetricSpecification = x.customizedMetricSpecification
            this.disableScaleIn = x.disableScaleIn
            this.predefinedMetricSpecification = x.predefinedMetricSpecification
            this.scaleInCooldown = x.scaleInCooldown
            this.scaleOutCooldown = x.scaleOutCooldown
            this.targetValue = x.targetValue
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.applicationautoscaling.model.TargetTrackingScalingPolicyConfiguration = TargetTrackingScalingPolicyConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.applicationautoscaling.model.CustomizedMetricSpecification] inside the given [block]
         */
        fun customizedMetricSpecification(block: aws.sdk.kotlin.services.applicationautoscaling.model.CustomizedMetricSpecification.Builder.() -> kotlin.Unit) {
            this.customizedMetricSpecification = aws.sdk.kotlin.services.applicationautoscaling.model.CustomizedMetricSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.applicationautoscaling.model.PredefinedMetricSpecification] inside the given [block]
         */
        fun predefinedMetricSpecification(block: aws.sdk.kotlin.services.applicationautoscaling.model.PredefinedMetricSpecification.Builder.() -> kotlin.Unit) {
            this.predefinedMetricSpecification = aws.sdk.kotlin.services.applicationautoscaling.model.PredefinedMetricSpecification.invoke(block)
        }
    }
}
