// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationautoscaling.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.applicationautoscaling.model.ApplicationAutoScalingException
import aws.sdk.kotlin.services.applicationautoscaling.model.DescribeScalingActivitiesResponse
import aws.sdk.kotlin.services.applicationautoscaling.model.ScalingActivity
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeScalingActivitiesOperationDeserializer: HttpDeserialize<DescribeScalingActivitiesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeScalingActivitiesResponse {
        if (!response.status.isSuccess()) {
            throwDescribeScalingActivitiesError(context, response)
        }
        val builder = DescribeScalingActivitiesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeScalingActivitiesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeDescribeScalingActivitiesOperationBody(builder: DescribeScalingActivitiesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val SCALINGACTIVITIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ScalingActivities"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTTOKEN_DESCRIPTOR)
        field(SCALINGACTIVITIES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                SCALINGACTIVITIES_DESCRIPTOR.index -> builder.scalingActivities =
                    deserializer.deserializeList(SCALINGACTIVITIES_DESCRIPTOR) {
                        val col0 = mutableListOf<ScalingActivity>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeScalingActivityDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwDescribeScalingActivitiesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ApplicationAutoScalingException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "ConcurrentUpdateException" -> ConcurrentUpdateExceptionDeserializer()
        "InternalServiceException" -> InternalServiceExceptionDeserializer()
        "InvalidNextTokenException" -> InvalidNextTokenExceptionDeserializer()
        "ValidationException" -> ValidationExceptionDeserializer()
        else -> throw ApplicationAutoScalingException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
