// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationautoscaling.paginators

import aws.sdk.kotlin.services.applicationautoscaling.ApplicationAutoScalingClient
import aws.sdk.kotlin.services.applicationautoscaling.model.DescribeScalableTargetsRequest
import aws.sdk.kotlin.services.applicationautoscaling.model.DescribeScalableTargetsResponse
import aws.sdk.kotlin.services.applicationautoscaling.model.DescribeScalingActivitiesRequest
import aws.sdk.kotlin.services.applicationautoscaling.model.DescribeScalingActivitiesResponse
import aws.sdk.kotlin.services.applicationautoscaling.model.DescribeScalingPoliciesRequest
import aws.sdk.kotlin.services.applicationautoscaling.model.DescribeScalingPoliciesResponse
import aws.sdk.kotlin.services.applicationautoscaling.model.DescribeScheduledActionsRequest
import aws.sdk.kotlin.services.applicationautoscaling.model.DescribeScheduledActionsResponse
import aws.sdk.kotlin.services.applicationautoscaling.model.ScalableTarget
import aws.sdk.kotlin.services.applicationautoscaling.model.ScalingActivity
import aws.sdk.kotlin.services.applicationautoscaling.model.ScalingPolicy
import aws.sdk.kotlin.services.applicationautoscaling.model.ScheduledAction
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeScalableTargetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeScalableTargetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeScalableTargetsResponse]
 */
fun ApplicationAutoScalingClient.describeScalableTargetsPaginated(initialRequest: DescribeScalableTargetsRequest): Flow<DescribeScalableTargetsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeScalableTargetsPaginated.describeScalableTargets(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeScalableTargetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeScalableTargetsResponse]
 */
fun ApplicationAutoScalingClient.describeScalableTargetsPaginated(block: DescribeScalableTargetsRequest.Builder.() -> Unit): Flow<DescribeScalableTargetsResponse> =
    describeScalableTargetsPaginated(DescribeScalableTargetsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeScalableTargetsPaginated]
 * to access the nested member [ScalableTarget]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ScalableTarget]
 */
@JvmName("describeScalableTargetsResponseScalableTarget")
fun Flow<DescribeScalableTargetsResponse>.scalableTargets(): Flow<ScalableTarget> =
    transform() { response ->
        response.scalableTargets?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeScalingActivitiesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeScalingActivitiesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeScalingActivitiesResponse]
 */
fun ApplicationAutoScalingClient.describeScalingActivitiesPaginated(initialRequest: DescribeScalingActivitiesRequest): Flow<DescribeScalingActivitiesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeScalingActivitiesPaginated.describeScalingActivities(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeScalingActivitiesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeScalingActivitiesResponse]
 */
fun ApplicationAutoScalingClient.describeScalingActivitiesPaginated(block: DescribeScalingActivitiesRequest.Builder.() -> Unit): Flow<DescribeScalingActivitiesResponse> =
    describeScalingActivitiesPaginated(DescribeScalingActivitiesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeScalingActivitiesPaginated]
 * to access the nested member [ScalingActivity]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ScalingActivity]
 */
@JvmName("describeScalingActivitiesResponseScalingActivity")
fun Flow<DescribeScalingActivitiesResponse>.scalingActivities(): Flow<ScalingActivity> =
    transform() { response ->
        response.scalingActivities?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeScalingPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeScalingPoliciesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeScalingPoliciesResponse]
 */
fun ApplicationAutoScalingClient.describeScalingPoliciesPaginated(initialRequest: DescribeScalingPoliciesRequest): Flow<DescribeScalingPoliciesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeScalingPoliciesPaginated.describeScalingPolicies(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeScalingPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeScalingPoliciesResponse]
 */
fun ApplicationAutoScalingClient.describeScalingPoliciesPaginated(block: DescribeScalingPoliciesRequest.Builder.() -> Unit): Flow<DescribeScalingPoliciesResponse> =
    describeScalingPoliciesPaginated(DescribeScalingPoliciesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeScalingPoliciesPaginated]
 * to access the nested member [ScalingPolicy]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ScalingPolicy]
 */
@JvmName("describeScalingPoliciesResponseScalingPolicy")
fun Flow<DescribeScalingPoliciesResponse>.scalingPolicies(): Flow<ScalingPolicy> =
    transform() { response ->
        response.scalingPolicies?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeScheduledActionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeScheduledActionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeScheduledActionsResponse]
 */
fun ApplicationAutoScalingClient.describeScheduledActionsPaginated(initialRequest: DescribeScheduledActionsRequest): Flow<DescribeScheduledActionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeScheduledActionsPaginated.describeScheduledActions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeScheduledActionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeScheduledActionsResponse]
 */
fun ApplicationAutoScalingClient.describeScheduledActionsPaginated(block: DescribeScheduledActionsRequest.Builder.() -> Unit): Flow<DescribeScheduledActionsResponse> =
    describeScheduledActionsPaginated(DescribeScheduledActionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeScheduledActionsPaginated]
 * to access the nested member [ScheduledAction]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ScheduledAction]
 */
@JvmName("describeScheduledActionsResponseScheduledAction")
fun Flow<DescribeScheduledActionsResponse>.scheduledActions(): Flow<ScheduledAction> =
    transform() { response ->
        response.scheduledActions?.forEach {
            emit(it)
        }
    }
