// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationautoscaling

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.applicationautoscaling.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.applicationautoscaling.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.crt.CrtAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * With Application Auto Scaling, you can configure automatic scaling for the following resources:
 * + Amazon AppStream 2.0 fleets
 * + Amazon Aurora Replicas
 * + Amazon Comprehend document classification and entity recognizer endpoints
 * + Amazon DynamoDB tables and global secondary indexes throughput capacity
 * + Amazon ECS services
 * + Amazon ElastiCache for Redis clusters (replication groups)
 * + Amazon EMR clusters
 * + Amazon Keyspaces (for Apache Cassandra) tables
 * + Lambda function provisioned concurrency
 * + Amazon Managed Streaming for Apache Kafka broker storage
 * + Amazon Neptune clusters
 * + Amazon SageMaker endpoint variants
 * + Spot Fleets (Amazon EC2)
 * + Custom resources provided by your own applications or services
 *
 * **API Summary**
 *
 * The Application Auto Scaling service API includes three key sets of actions:
 * + Register and manage scalable targets - Register Amazon Web Services or custom resources as scalable targets (a resource that Application Auto Scaling can scale), set minimum and maximum capacity limits, and retrieve information on existing scalable targets.
 * + Configure and manage automatic scaling - Define scaling policies to dynamically scale your resources in response to CloudWatch alarms, schedule one-time or recurring scaling actions, and retrieve your recent scaling activity history.
 * + Suspend and resume scaling - Temporarily suspend and later resume automatic scaling by calling the [RegisterScalableTarget](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html) API action for any Application Auto Scaling scalable target. You can suspend and resume (individually or in combination) scale-out activities that are triggered by a scaling policy, scale-in activities that are triggered by a scaling policy, and scheduled scaling.
 *
 * To learn more about Application Auto Scaling, including information about granting IAM users required permissions for Application Auto Scaling actions, see the [Application Auto Scaling User Guide](https://docs.aws.amazon.com/autoscaling/application/userguide/what-is-application-auto-scaling.html).
 */
interface ApplicationAutoScalingClient : SdkClient {

    override val serviceName: String
        get() = "Application Auto Scaling"
    /**
     * ApplicationAutoScalingClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): ApplicationAutoScalingClient {
            val config = Config.Builder().apply(block).build()
            return DefaultApplicationAutoScalingClient(config)
        }

        operator fun invoke(config: Config): ApplicationAutoScalingClient = DefaultApplicationAutoScalingClient(config)

        /**
         * Construct a [ApplicationAutoScalingClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): ApplicationAutoScalingClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultApplicationAutoScalingClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: CrtAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Deletes the specified scaling policy for an Application Auto Scaling scalable target.
     *
     * Deleting a step scaling policy deletes the underlying alarm action, but does not delete the CloudWatch alarm associated with the scaling policy, even if it no longer has an associated action.
     *
     * For more information, see [Delete a step scaling policy](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html#delete-step-scaling-policy) and [Delete a target tracking scaling policy](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html#delete-target-tracking-policy) in the *Application Auto Scaling User Guide*.
     */
    suspend fun deleteScalingPolicy(input: DeleteScalingPolicyRequest): DeleteScalingPolicyResponse

    /**
     * Deletes the specified scaling policy for an Application Auto Scaling scalable target.
     *
     * Deleting a step scaling policy deletes the underlying alarm action, but does not delete the CloudWatch alarm associated with the scaling policy, even if it no longer has an associated action.
     *
     * For more information, see [Delete a step scaling policy](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html#delete-step-scaling-policy) and [Delete a target tracking scaling policy](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html#delete-target-tracking-policy) in the *Application Auto Scaling User Guide*.
     */
    suspend fun deleteScalingPolicy(block: DeleteScalingPolicyRequest.Builder.() -> Unit) = deleteScalingPolicy(DeleteScalingPolicyRequest.Builder().apply(block).build())

    /**
     * Deletes the specified scheduled action for an Application Auto Scaling scalable target.
     *
     * For more information, see [Delete a scheduled action](https://docs.aws.amazon.com/autoscaling/application/userguide/scheduled-scaling-additional-cli-commands.html#delete-scheduled-action) in the *Application Auto Scaling User Guide*.
     */
    suspend fun deleteScheduledAction(input: DeleteScheduledActionRequest): DeleteScheduledActionResponse

    /**
     * Deletes the specified scheduled action for an Application Auto Scaling scalable target.
     *
     * For more information, see [Delete a scheduled action](https://docs.aws.amazon.com/autoscaling/application/userguide/scheduled-scaling-additional-cli-commands.html#delete-scheduled-action) in the *Application Auto Scaling User Guide*.
     */
    suspend fun deleteScheduledAction(block: DeleteScheduledActionRequest.Builder.() -> Unit) = deleteScheduledAction(DeleteScheduledActionRequest.Builder().apply(block).build())

    /**
     * Deregisters an Application Auto Scaling scalable target when you have finished using it. To see which resources have been registered, use [DescribeScalableTargets](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DescribeScalableTargets.html).
     *
     * Deregistering a scalable target deletes the scaling policies and the scheduled actions that are associated with it.
     */
    suspend fun deregisterScalableTarget(input: DeregisterScalableTargetRequest): DeregisterScalableTargetResponse

    /**
     * Deregisters an Application Auto Scaling scalable target when you have finished using it. To see which resources have been registered, use [DescribeScalableTargets](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DescribeScalableTargets.html).
     *
     * Deregistering a scalable target deletes the scaling policies and the scheduled actions that are associated with it.
     */
    suspend fun deregisterScalableTarget(block: DeregisterScalableTargetRequest.Builder.() -> Unit) = deregisterScalableTarget(DeregisterScalableTargetRequest.Builder().apply(block).build())

    /**
     * Gets information about the scalable targets in the specified namespace.
     *
     * You can filter the results using `ResourceIds` and `ScalableDimension`.
     */
    suspend fun describeScalableTargets(input: DescribeScalableTargetsRequest): DescribeScalableTargetsResponse

    /**
     * Gets information about the scalable targets in the specified namespace.
     *
     * You can filter the results using `ResourceIds` and `ScalableDimension`.
     */
    suspend fun describeScalableTargets(block: DescribeScalableTargetsRequest.Builder.() -> Unit) = describeScalableTargets(DescribeScalableTargetsRequest.Builder().apply(block).build())

    /**
     * Provides descriptive information about the scaling activities in the specified namespace from the previous six weeks.
     *
     * You can filter the results using `ResourceId` and `ScalableDimension`.
     */
    suspend fun describeScalingActivities(input: DescribeScalingActivitiesRequest): DescribeScalingActivitiesResponse

    /**
     * Provides descriptive information about the scaling activities in the specified namespace from the previous six weeks.
     *
     * You can filter the results using `ResourceId` and `ScalableDimension`.
     */
    suspend fun describeScalingActivities(block: DescribeScalingActivitiesRequest.Builder.() -> Unit) = describeScalingActivities(DescribeScalingActivitiesRequest.Builder().apply(block).build())

    /**
     * Describes the Application Auto Scaling scaling policies for the specified service namespace.
     *
     * You can filter the results using `ResourceId`, `ScalableDimension`, and `PolicyNames`.
     *
     * For more information, see [Target tracking scaling policies](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html) and [Step scaling policies](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html) in the *Application Auto Scaling User Guide*.
     */
    suspend fun describeScalingPolicies(input: DescribeScalingPoliciesRequest): DescribeScalingPoliciesResponse

    /**
     * Describes the Application Auto Scaling scaling policies for the specified service namespace.
     *
     * You can filter the results using `ResourceId`, `ScalableDimension`, and `PolicyNames`.
     *
     * For more information, see [Target tracking scaling policies](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html) and [Step scaling policies](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html) in the *Application Auto Scaling User Guide*.
     */
    suspend fun describeScalingPolicies(block: DescribeScalingPoliciesRequest.Builder.() -> Unit) = describeScalingPolicies(DescribeScalingPoliciesRequest.Builder().apply(block).build())

    /**
     * Describes the Application Auto Scaling scheduled actions for the specified service namespace.
     *
     * You can filter the results using the `ResourceId`, `ScalableDimension`, and `ScheduledActionNames` parameters.
     *
     * For more information, see [Scheduled scaling](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-scheduled-scaling.html) and [Managing scheduled scaling](https://docs.aws.amazon.com/autoscaling/application/userguide/scheduled-scaling-additional-cli-commands.html) in the *Application Auto Scaling User Guide*.
     */
    suspend fun describeScheduledActions(input: DescribeScheduledActionsRequest): DescribeScheduledActionsResponse

    /**
     * Describes the Application Auto Scaling scheduled actions for the specified service namespace.
     *
     * You can filter the results using the `ResourceId`, `ScalableDimension`, and `ScheduledActionNames` parameters.
     *
     * For more information, see [Scheduled scaling](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-scheduled-scaling.html) and [Managing scheduled scaling](https://docs.aws.amazon.com/autoscaling/application/userguide/scheduled-scaling-additional-cli-commands.html) in the *Application Auto Scaling User Guide*.
     */
    suspend fun describeScheduledActions(block: DescribeScheduledActionsRequest.Builder.() -> Unit) = describeScheduledActions(DescribeScheduledActionsRequest.Builder().apply(block).build())

    /**
     * Creates or updates a scaling policy for an Application Auto Scaling scalable target.
     *
     * Each scalable target is identified by a service namespace, resource ID, and scalable dimension. A scaling policy applies to the scalable target identified by those three attributes. You cannot create a scaling policy until you have registered the resource as a scalable target.
     *
     * Multiple scaling policies can be in force at the same time for the same scalable target. You can have one or more target tracking scaling policies, one or more step scaling policies, or both. However, there is a chance that multiple policies could conflict, instructing the scalable target to scale out or in at the same time. Application Auto Scaling gives precedence to the policy that provides the largest capacity for both scale out and scale in. For example, if one policy increases capacity by 3, another policy increases capacity by 200 percent, and the current capacity is 10, Application Auto Scaling uses the policy with the highest calculated capacity (200% of 10 = 20) and scales out to 30.
     *
     * We recommend caution, however, when using target tracking scaling policies with step scaling policies because conflicts between these policies can cause undesirable behavior. For example, if the step scaling policy initiates a scale-in activity before the target tracking policy is ready to scale in, the scale-in activity will not be blocked. After the scale-in activity completes, the target tracking policy could instruct the scalable target to scale out again.
     *
     * For more information, see [Target tracking scaling policies](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html) and [Step scaling policies](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html) in the *Application Auto Scaling User Guide*.
     *
     * If a scalable target is deregistered, the scalable target is no longer available to execute scaling policies. Any scaling policies that were specified for the scalable target are deleted.
     */
    suspend fun putScalingPolicy(input: PutScalingPolicyRequest): PutScalingPolicyResponse

    /**
     * Creates or updates a scaling policy for an Application Auto Scaling scalable target.
     *
     * Each scalable target is identified by a service namespace, resource ID, and scalable dimension. A scaling policy applies to the scalable target identified by those three attributes. You cannot create a scaling policy until you have registered the resource as a scalable target.
     *
     * Multiple scaling policies can be in force at the same time for the same scalable target. You can have one or more target tracking scaling policies, one or more step scaling policies, or both. However, there is a chance that multiple policies could conflict, instructing the scalable target to scale out or in at the same time. Application Auto Scaling gives precedence to the policy that provides the largest capacity for both scale out and scale in. For example, if one policy increases capacity by 3, another policy increases capacity by 200 percent, and the current capacity is 10, Application Auto Scaling uses the policy with the highest calculated capacity (200% of 10 = 20) and scales out to 30.
     *
     * We recommend caution, however, when using target tracking scaling policies with step scaling policies because conflicts between these policies can cause undesirable behavior. For example, if the step scaling policy initiates a scale-in activity before the target tracking policy is ready to scale in, the scale-in activity will not be blocked. After the scale-in activity completes, the target tracking policy could instruct the scalable target to scale out again.
     *
     * For more information, see [Target tracking scaling policies](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html) and [Step scaling policies](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html) in the *Application Auto Scaling User Guide*.
     *
     * If a scalable target is deregistered, the scalable target is no longer available to execute scaling policies. Any scaling policies that were specified for the scalable target are deleted.
     */
    suspend fun putScalingPolicy(block: PutScalingPolicyRequest.Builder.() -> Unit) = putScalingPolicy(PutScalingPolicyRequest.Builder().apply(block).build())

    /**
     * Creates or updates a scheduled action for an Application Auto Scaling scalable target.
     *
     * Each scalable target is identified by a service namespace, resource ID, and scalable dimension. A scheduled action applies to the scalable target identified by those three attributes. You cannot create a scheduled action until you have registered the resource as a scalable target.
     *
     * When start and end times are specified with a recurring schedule using a cron expression or rates, they form the boundaries for when the recurring action starts and stops.
     *
     * To update a scheduled action, specify the parameters that you want to change. If you don't specify start and end times, the old values are deleted.
     *
     * For more information, see [Scheduled scaling](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-scheduled-scaling.html) in the *Application Auto Scaling User Guide*.
     *
     * If a scalable target is deregistered, the scalable target is no longer available to run scheduled actions. Any scheduled actions that were specified for the scalable target are deleted.
     */
    suspend fun putScheduledAction(input: PutScheduledActionRequest): PutScheduledActionResponse

    /**
     * Creates or updates a scheduled action for an Application Auto Scaling scalable target.
     *
     * Each scalable target is identified by a service namespace, resource ID, and scalable dimension. A scheduled action applies to the scalable target identified by those three attributes. You cannot create a scheduled action until you have registered the resource as a scalable target.
     *
     * When start and end times are specified with a recurring schedule using a cron expression or rates, they form the boundaries for when the recurring action starts and stops.
     *
     * To update a scheduled action, specify the parameters that you want to change. If you don't specify start and end times, the old values are deleted.
     *
     * For more information, see [Scheduled scaling](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-scheduled-scaling.html) in the *Application Auto Scaling User Guide*.
     *
     * If a scalable target is deregistered, the scalable target is no longer available to run scheduled actions. Any scheduled actions that were specified for the scalable target are deleted.
     */
    suspend fun putScheduledAction(block: PutScheduledActionRequest.Builder.() -> Unit) = putScheduledAction(PutScheduledActionRequest.Builder().apply(block).build())

    /**
     * Registers or updates a scalable target.
     *
     * A scalable target is a resource that Application Auto Scaling can scale out and scale in. Scalable targets are uniquely identified by the combination of resource ID, scalable dimension, and namespace.
     *
     * When you register a new scalable target, you must specify values for minimum and maximum capacity. Current capacity will be adjusted within the specified range when scaling starts. Application Auto Scaling scaling policies will not scale capacity to values that are outside of this range.
     *
     * After you register a scalable target, you do not need to register it again to use other Application Auto Scaling operations. To see which resources have been registered, use [DescribeScalableTargets](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DescribeScalableTargets.html). You can also view the scaling policies for a service namespace by using [DescribeScalableTargets](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DescribeScalableTargets.html). If you no longer need a scalable target, you can deregister it by using [DeregisterScalableTarget](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DeregisterScalableTarget.html).
     *
     * To update a scalable target, specify the parameters that you want to change. Include the parameters that identify the scalable target: resource ID, scalable dimension, and namespace. Any parameters that you don't specify are not changed by this update request.
     *
     * If you call the `RegisterScalableTarget` API to update an existing scalable target, Application Auto Scaling retrieves the current capacity of the resource. If it is below the minimum capacity or above the maximum capacity, Application Auto Scaling adjusts the capacity of the scalable target to place it within these bounds, even if you don't include the `MinCapacity` or `MaxCapacity` request parameters.
     */
    suspend fun registerScalableTarget(input: RegisterScalableTargetRequest): RegisterScalableTargetResponse

    /**
     * Registers or updates a scalable target.
     *
     * A scalable target is a resource that Application Auto Scaling can scale out and scale in. Scalable targets are uniquely identified by the combination of resource ID, scalable dimension, and namespace.
     *
     * When you register a new scalable target, you must specify values for minimum and maximum capacity. Current capacity will be adjusted within the specified range when scaling starts. Application Auto Scaling scaling policies will not scale capacity to values that are outside of this range.
     *
     * After you register a scalable target, you do not need to register it again to use other Application Auto Scaling operations. To see which resources have been registered, use [DescribeScalableTargets](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DescribeScalableTargets.html). You can also view the scaling policies for a service namespace by using [DescribeScalableTargets](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DescribeScalableTargets.html). If you no longer need a scalable target, you can deregister it by using [DeregisterScalableTarget](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DeregisterScalableTarget.html).
     *
     * To update a scalable target, specify the parameters that you want to change. Include the parameters that identify the scalable target: resource ID, scalable dimension, and namespace. Any parameters that you don't specify are not changed by this update request.
     *
     * If you call the `RegisterScalableTarget` API to update an existing scalable target, Application Auto Scaling retrieves the current capacity of the resource. If it is below the minimum capacity or above the maximum capacity, Application Auto Scaling adjusts the capacity of the scalable target to place it within these bounds, even if you don't include the `MinCapacity` or `MaxCapacity` request parameters.
     */
    suspend fun registerScalableTarget(block: RegisterScalableTargetRequest.Builder.() -> Unit) = registerScalableTarget(RegisterScalableTargetRequest.Builder().apply(block).build())
}
