// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationautoscaling.model



/**
 * Represents a step adjustment for a [StepScalingPolicyConfiguration](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_StepScalingPolicyConfiguration.html). Describes an adjustment based on the difference between the value of the aggregated CloudWatch metric and the breach threshold that you've defined for the alarm.
 *
 * For the following examples, suppose that you have an alarm with a breach threshold of 50:
 * + To trigger the adjustment when the metric is greater than or equal to 50 and less than 60, specify a lower bound of 0 and an upper bound of 10.
 * + To trigger the adjustment when the metric is greater than 40 and less than or equal to 50, specify a lower bound of -10 and an upper bound of 0.
 *
 * There are a few rules for the step adjustments for your step policy:
 * + The ranges of your step adjustments can't overlap or have a gap.
 * + At most one step adjustment can have a null lower bound. If one step adjustment has a negative lower bound, then there must be a step adjustment with a null lower bound.
 * + At most one step adjustment can have a null upper bound. If one step adjustment has a positive upper bound, then there must be a step adjustment with a null upper bound.
 * + The upper and lower bound can't be null in the same step adjustment.
 */
public class StepAdjustment private constructor(builder: Builder) {
    /**
     * The lower bound for the difference between the alarm threshold and the CloudWatch metric. If the metric value is above the breach threshold, the lower bound is inclusive (the metric must be greater than or equal to the threshold plus the lower bound). Otherwise, it is exclusive (the metric must be greater than the threshold plus the lower bound). A null value indicates negative infinity.
     */
    public val metricIntervalLowerBound: kotlin.Double? = builder.metricIntervalLowerBound
    /**
     * The upper bound for the difference between the alarm threshold and the CloudWatch metric. If the metric value is above the breach threshold, the upper bound is exclusive (the metric must be less than the threshold plus the upper bound). Otherwise, it is inclusive (the metric must be less than or equal to the threshold plus the upper bound). A null value indicates positive infinity.
     *
     * The upper bound must be greater than the lower bound.
     */
    public val metricIntervalUpperBound: kotlin.Double? = builder.metricIntervalUpperBound
    /**
     * The amount by which to scale, based on the specified adjustment type. A positive value adds to the current capacity while a negative number removes from the current capacity. For exact capacity, you must specify a positive value.
     */
    public val scalingAdjustment: kotlin.Int? = builder.scalingAdjustment

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.applicationautoscaling.model.StepAdjustment = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StepAdjustment(")
        append("metricIntervalLowerBound=$metricIntervalLowerBound,")
        append("metricIntervalUpperBound=$metricIntervalUpperBound,")
        append("scalingAdjustment=$scalingAdjustment)")
    }

    override fun hashCode(): kotlin.Int {
        var result = metricIntervalLowerBound?.hashCode() ?: 0
        result = 31 * result + (metricIntervalUpperBound?.hashCode() ?: 0)
        result = 31 * result + (scalingAdjustment ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StepAdjustment

        if (metricIntervalLowerBound != other.metricIntervalLowerBound) return false
        if (metricIntervalUpperBound != other.metricIntervalUpperBound) return false
        if (scalingAdjustment != other.scalingAdjustment) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.applicationautoscaling.model.StepAdjustment = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The lower bound for the difference between the alarm threshold and the CloudWatch metric. If the metric value is above the breach threshold, the lower bound is inclusive (the metric must be greater than or equal to the threshold plus the lower bound). Otherwise, it is exclusive (the metric must be greater than the threshold plus the lower bound). A null value indicates negative infinity.
         */
        public var metricIntervalLowerBound: kotlin.Double? = null
        /**
         * The upper bound for the difference between the alarm threshold and the CloudWatch metric. If the metric value is above the breach threshold, the upper bound is exclusive (the metric must be less than the threshold plus the upper bound). Otherwise, it is inclusive (the metric must be less than or equal to the threshold plus the upper bound). A null value indicates positive infinity.
         *
         * The upper bound must be greater than the lower bound.
         */
        public var metricIntervalUpperBound: kotlin.Double? = null
        /**
         * The amount by which to scale, based on the specified adjustment type. A positive value adds to the current capacity while a negative number removes from the current capacity. For exact capacity, you must specify a positive value.
         */
        public var scalingAdjustment: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.applicationautoscaling.model.StepAdjustment) : this() {
            this.metricIntervalLowerBound = x.metricIntervalLowerBound
            this.metricIntervalUpperBound = x.metricIntervalUpperBound
            this.scalingAdjustment = x.scalingAdjustment
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.applicationautoscaling.model.StepAdjustment = StepAdjustment(this)
    }
}
