// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationautoscaling.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.applicationautoscaling.model.Alarm
import aws.sdk.kotlin.services.applicationautoscaling.model.ApplicationAutoScalingException
import aws.sdk.kotlin.services.applicationautoscaling.model.PutScalingPolicyResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class PutScalingPolicyOperationDeserializer: HttpDeserialize<PutScalingPolicyResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): PutScalingPolicyResponse {
        if (!response.status.isSuccess()) {
            throwPutScalingPolicyError(context, response)
        }
        val builder = PutScalingPolicyResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializePutScalingPolicyOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwPutScalingPolicyError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ApplicationAutoScalingException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConcurrentUpdateException" -> ConcurrentUpdateExceptionDeserializer().deserialize(context, wrappedResponse)
        "FailedResourceAccessException" -> FailedResourceAccessExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ObjectNotFoundException" -> ObjectNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ApplicationAutoScalingException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePutScalingPolicyOperationBody(builder: PutScalingPolicyResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ALARMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Alarms"))
    val POLICYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PolicyARN"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALARMS_DESCRIPTOR)
        field(POLICYARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ALARMS_DESCRIPTOR.index -> builder.alarms =
                    deserializer.deserializeList(ALARMS_DESCRIPTOR) {
                        val col0 = mutableListOf<Alarm>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAlarmDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                POLICYARN_DESCRIPTOR.index -> builder.policyArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
