// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationautoscaling.transform

import aws.sdk.kotlin.services.applicationautoscaling.model.PutScheduledActionRequest
import aws.sdk.kotlin.services.applicationautoscaling.model.ScalableDimension
import aws.sdk.kotlin.services.applicationautoscaling.model.ScalableTargetAction
import aws.sdk.kotlin.services.applicationautoscaling.model.ServiceNamespace
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class PutScheduledActionOperationSerializer: HttpSerialize<PutScheduledActionRequest> {
    override suspend fun serialize(context: ExecutionContext, input: PutScheduledActionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializePutScheduledActionOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializePutScheduledActionOperationBody(context: ExecutionContext, input: PutScheduledActionRequest): ByteArray {
    val serializer = JsonSerializer()
    val ENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("EndTime"))
    val RESOURCEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ResourceId"))
    val SCALABLEDIMENSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ScalableDimension"))
    val SCALABLETARGETACTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ScalableTargetAction"))
    val SCHEDULE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Schedule"))
    val SCHEDULEDACTIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ScheduledActionName"))
    val SERVICENAMESPACE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ServiceNamespace"))
    val STARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("StartTime"))
    val TIMEZONE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Timezone"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ENDTIME_DESCRIPTOR)
        field(RESOURCEID_DESCRIPTOR)
        field(SCALABLEDIMENSION_DESCRIPTOR)
        field(SCALABLETARGETACTION_DESCRIPTOR)
        field(SCHEDULE_DESCRIPTOR)
        field(SCHEDULEDACTIONNAME_DESCRIPTOR)
        field(SERVICENAMESPACE_DESCRIPTOR)
        field(STARTTIME_DESCRIPTOR)
        field(TIMEZONE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.endTime?.let { field(ENDTIME_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        input.resourceId?.let { field(RESOURCEID_DESCRIPTOR, it) }
        input.scalableDimension?.let { field(SCALABLEDIMENSION_DESCRIPTOR, it.value) }
        input.scalableTargetAction?.let { field(SCALABLETARGETACTION_DESCRIPTOR, it, ::serializeScalableTargetActionDocument) }
        input.schedule?.let { field(SCHEDULE_DESCRIPTOR, it) }
        input.scheduledActionName?.let { field(SCHEDULEDACTIONNAME_DESCRIPTOR, it) }
        input.serviceNamespace?.let { field(SERVICENAMESPACE_DESCRIPTOR, it.value) }
        input.startTime?.let { field(STARTTIME_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        input.timezone?.let { field(TIMEZONE_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
