// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationautoscaling.model

import aws.smithy.kotlin.runtime.time.Instant

public class PutScheduledActionRequest private constructor(builder: Builder) {
    /**
     * The date and time for the recurring schedule to end, in UTC.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The identifier of the resource associated with the scheduled action. This string consists of the resource type and unique identifier.
     * + ECS service - The resource type is `service` and the unique identifier is the cluster name and service name. Example: `service/default/sample-webapp`.
     * + Spot Fleet - The resource type is `spot-fleet-request` and the unique identifier is the Spot Fleet request ID. Example: `spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE`.
     * + EMR cluster - The resource type is `instancegroup` and the unique identifier is the cluster ID and instance group ID. Example: `instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0`.
     * + AppStream 2.0 fleet - The resource type is `fleet` and the unique identifier is the fleet name. Example: `fleet/sample-fleet`.
     * + DynamoDB table - The resource type is `table` and the unique identifier is the table name. Example: `table/my-table`.
     * + DynamoDB global secondary index - The resource type is `index` and the unique identifier is the index name. Example: `table/my-table/index/my-table-index`.
     * + Aurora DB cluster - The resource type is `cluster` and the unique identifier is the cluster name. Example: `cluster:my-db-cluster`.
     * + SageMaker endpoint variant - The resource type is `variant` and the unique identifier is the resource ID. Example: `endpoint/my-end-point/variant/KMeansClustering`.
     * + Custom resources are not supported with a resource type. This parameter must specify the `OutputValue` from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information is available in our [GitHub repository](https://github.com/aws/aws-auto-scaling-custom-resource).
     * + Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: `arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE`.
     * + Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: `arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE`.
     * + Lambda provisioned concurrency - The resource type is `function` and the unique identifier is the function name with a function version or alias name suffix that is not `$LATEST`. Example: `function:my-function:prod` or `function:my-function:1`.
     * + Amazon Keyspaces table - The resource type is `table` and the unique identifier is the table name. Example: `keyspace/mykeyspace/table/mytable`.
     * + Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN. Example: `arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5`.
     * + Amazon ElastiCache replication group - The resource type is `replication-group` and the unique identifier is the replication group name. Example: `replication-group/mycluster`.
     * + Neptune cluster - The resource type is `cluster` and the unique identifier is the cluster name. Example: `cluster:mycluster`.
     */
    public val resourceId: kotlin.String? = builder.resourceId
    /**
     * The scalable dimension. This string consists of the service namespace, resource type, and scaling property.
     * + `ecs:service:DesiredCount` - The desired task count of an ECS service.
     * + `elasticmapreduce:instancegroup:InstanceCount` - The instance count of an EMR Instance Group.
     * + `ec2:spot-fleet-request:TargetCapacity` - The target capacity of a Spot Fleet.
     * + `appstream:fleet:DesiredCapacity` - The desired capacity of an AppStream 2.0 fleet.
     * + `dynamodb:table:ReadCapacityUnits` - The provisioned read capacity for a DynamoDB table.
     * + `dynamodb:table:WriteCapacityUnits` - The provisioned write capacity for a DynamoDB table.
     * + `dynamodb:index:ReadCapacityUnits` - The provisioned read capacity for a DynamoDB global secondary index.
     * + `dynamodb:index:WriteCapacityUnits` - The provisioned write capacity for a DynamoDB global secondary index.
     * + `rds:cluster:ReadReplicaCount` - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
     * + `sagemaker:variant:DesiredInstanceCount` - The number of EC2 instances for a SageMaker model endpoint variant.
     * + `custom-resource:ResourceType:Property` - The scalable dimension for a custom resource provided by your own application or service.
     * + `comprehend:document-classifier-endpoint:DesiredInferenceUnits` - The number of inference units for an Amazon Comprehend document classification endpoint.
     * + `comprehend:entity-recognizer-endpoint:DesiredInferenceUnits` - The number of inference units for an Amazon Comprehend entity recognizer endpoint.
     * + `lambda:function:ProvisionedConcurrency` - The provisioned concurrency for a Lambda function.
     * + `cassandra:table:ReadCapacityUnits` - The provisioned read capacity for an Amazon Keyspaces table.
     * + `cassandra:table:WriteCapacityUnits` - The provisioned write capacity for an Amazon Keyspaces table.
     * + `kafka:broker-storage:VolumeSize` - The provisioned volume size (in GiB) for brokers in an Amazon MSK cluster.
     * + `elasticache:replication-group:NodeGroups` - The number of node groups for an Amazon ElastiCache replication group.
     * + `elasticache:replication-group:Replicas` - The number of replicas per node group for an Amazon ElastiCache replication group.
     * + `neptune:cluster:ReadReplicaCount` - The count of read replicas in an Amazon Neptune DB cluster.
     */
    public val scalableDimension: aws.sdk.kotlin.services.applicationautoscaling.model.ScalableDimension? = builder.scalableDimension
    /**
     * The new minimum and maximum capacity. You can set both values or just one. At the scheduled time, if the current capacity is below the minimum capacity, Application Auto Scaling scales out to the minimum capacity. If the current capacity is above the maximum capacity, Application Auto Scaling scales in to the maximum capacity.
     */
    public val scalableTargetAction: aws.sdk.kotlin.services.applicationautoscaling.model.ScalableTargetAction? = builder.scalableTargetAction
    /**
     * The schedule for this action. The following formats are supported:
     * + At expressions - "`at(<i>yyyy</i>-<i>mm</i>-<i>dd</i>T<i>hh</i>:<i>mm</i>:<i>ss</i>)`"
     * + Rate expressions - "`rate(<i>value</i> <i>unit</i>)`"
     * + Cron expressions - "`cron(<i>fields</i>)`"
     *
     * At expressions are useful for one-time schedules. Cron expressions are useful for scheduled actions that run periodically at a specified date and time, and rate expressions are useful for scheduled actions that run at a regular interval.
     *
     * At and cron expressions use Universal Coordinated Time (UTC) by default.
     *
     * The cron format consists of six fields separated by white spaces: &#91;Minutes&#93; &#91;Hours&#93; &#91;Day_of_Month&#93; &#91;Month&#93; &#91;Day_of_Week&#93; &#91;Year&#93;.
     *
     * For rate expressions, *value* is a positive integer and *unit* is `minute` | `minutes` | `hour` | `hours` | `day` | `days`.
     *
     * For more information and examples, see [Example scheduled actions for Application Auto Scaling](https://docs.aws.amazon.com/autoscaling/application/userguide/examples-scheduled-actions.html) in the *Application Auto Scaling User Guide*.
     */
    public val schedule: kotlin.String? = builder.schedule
    /**
     * The name of the scheduled action. This name must be unique among all other scheduled actions on the specified scalable target.
     */
    public val scheduledActionName: kotlin.String? = builder.scheduledActionName
    /**
     * The namespace of the Amazon Web Services service that provides the resource. For a resource provided by your own application or service, use `custom-resource` instead.
     */
    public val serviceNamespace: aws.sdk.kotlin.services.applicationautoscaling.model.ServiceNamespace? = builder.serviceNamespace
    /**
     * The date and time for this scheduled action to start, in UTC.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * Specifies the time zone used when setting a scheduled action by using an at or cron expression. If a time zone is not provided, UTC is used by default.
     *
     * Valid values are the canonical names of the IANA time zones supported by Joda-Time (such as `Etc/GMT+9` or `Pacific/Tahiti`). For more information, see [https://www.joda.org/joda-time/timezones.html](https://www.joda.org/joda-time/timezones.html).
     */
    public val timezone: kotlin.String? = builder.timezone

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.applicationautoscaling.model.PutScheduledActionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutScheduledActionRequest(")
        append("endTime=$endTime,")
        append("resourceId=$resourceId,")
        append("scalableDimension=$scalableDimension,")
        append("scalableTargetAction=$scalableTargetAction,")
        append("schedule=$schedule,")
        append("scheduledActionName=$scheduledActionName,")
        append("serviceNamespace=$serviceNamespace,")
        append("startTime=$startTime,")
        append("timezone=$timezone")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (scalableDimension?.hashCode() ?: 0)
        result = 31 * result + (scalableTargetAction?.hashCode() ?: 0)
        result = 31 * result + (schedule?.hashCode() ?: 0)
        result = 31 * result + (scheduledActionName?.hashCode() ?: 0)
        result = 31 * result + (serviceNamespace?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (timezone?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutScheduledActionRequest

        if (endTime != other.endTime) return false
        if (resourceId != other.resourceId) return false
        if (scalableDimension != other.scalableDimension) return false
        if (scalableTargetAction != other.scalableTargetAction) return false
        if (schedule != other.schedule) return false
        if (scheduledActionName != other.scheduledActionName) return false
        if (serviceNamespace != other.serviceNamespace) return false
        if (startTime != other.startTime) return false
        if (timezone != other.timezone) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.applicationautoscaling.model.PutScheduledActionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The date and time for the recurring schedule to end, in UTC.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The identifier of the resource associated with the scheduled action. This string consists of the resource type and unique identifier.
         * + ECS service - The resource type is `service` and the unique identifier is the cluster name and service name. Example: `service/default/sample-webapp`.
         * + Spot Fleet - The resource type is `spot-fleet-request` and the unique identifier is the Spot Fleet request ID. Example: `spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE`.
         * + EMR cluster - The resource type is `instancegroup` and the unique identifier is the cluster ID and instance group ID. Example: `instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0`.
         * + AppStream 2.0 fleet - The resource type is `fleet` and the unique identifier is the fleet name. Example: `fleet/sample-fleet`.
         * + DynamoDB table - The resource type is `table` and the unique identifier is the table name. Example: `table/my-table`.
         * + DynamoDB global secondary index - The resource type is `index` and the unique identifier is the index name. Example: `table/my-table/index/my-table-index`.
         * + Aurora DB cluster - The resource type is `cluster` and the unique identifier is the cluster name. Example: `cluster:my-db-cluster`.
         * + SageMaker endpoint variant - The resource type is `variant` and the unique identifier is the resource ID. Example: `endpoint/my-end-point/variant/KMeansClustering`.
         * + Custom resources are not supported with a resource type. This parameter must specify the `OutputValue` from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information is available in our [GitHub repository](https://github.com/aws/aws-auto-scaling-custom-resource).
         * + Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: `arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE`.
         * + Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: `arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE`.
         * + Lambda provisioned concurrency - The resource type is `function` and the unique identifier is the function name with a function version or alias name suffix that is not `$LATEST`. Example: `function:my-function:prod` or `function:my-function:1`.
         * + Amazon Keyspaces table - The resource type is `table` and the unique identifier is the table name. Example: `keyspace/mykeyspace/table/mytable`.
         * + Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN. Example: `arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5`.
         * + Amazon ElastiCache replication group - The resource type is `replication-group` and the unique identifier is the replication group name. Example: `replication-group/mycluster`.
         * + Neptune cluster - The resource type is `cluster` and the unique identifier is the cluster name. Example: `cluster:mycluster`.
         */
        public var resourceId: kotlin.String? = null
        /**
         * The scalable dimension. This string consists of the service namespace, resource type, and scaling property.
         * + `ecs:service:DesiredCount` - The desired task count of an ECS service.
         * + `elasticmapreduce:instancegroup:InstanceCount` - The instance count of an EMR Instance Group.
         * + `ec2:spot-fleet-request:TargetCapacity` - The target capacity of a Spot Fleet.
         * + `appstream:fleet:DesiredCapacity` - The desired capacity of an AppStream 2.0 fleet.
         * + `dynamodb:table:ReadCapacityUnits` - The provisioned read capacity for a DynamoDB table.
         * + `dynamodb:table:WriteCapacityUnits` - The provisioned write capacity for a DynamoDB table.
         * + `dynamodb:index:ReadCapacityUnits` - The provisioned read capacity for a DynamoDB global secondary index.
         * + `dynamodb:index:WriteCapacityUnits` - The provisioned write capacity for a DynamoDB global secondary index.
         * + `rds:cluster:ReadReplicaCount` - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
         * + `sagemaker:variant:DesiredInstanceCount` - The number of EC2 instances for a SageMaker model endpoint variant.
         * + `custom-resource:ResourceType:Property` - The scalable dimension for a custom resource provided by your own application or service.
         * + `comprehend:document-classifier-endpoint:DesiredInferenceUnits` - The number of inference units for an Amazon Comprehend document classification endpoint.
         * + `comprehend:entity-recognizer-endpoint:DesiredInferenceUnits` - The number of inference units for an Amazon Comprehend entity recognizer endpoint.
         * + `lambda:function:ProvisionedConcurrency` - The provisioned concurrency for a Lambda function.
         * + `cassandra:table:ReadCapacityUnits` - The provisioned read capacity for an Amazon Keyspaces table.
         * + `cassandra:table:WriteCapacityUnits` - The provisioned write capacity for an Amazon Keyspaces table.
         * + `kafka:broker-storage:VolumeSize` - The provisioned volume size (in GiB) for brokers in an Amazon MSK cluster.
         * + `elasticache:replication-group:NodeGroups` - The number of node groups for an Amazon ElastiCache replication group.
         * + `elasticache:replication-group:Replicas` - The number of replicas per node group for an Amazon ElastiCache replication group.
         * + `neptune:cluster:ReadReplicaCount` - The count of read replicas in an Amazon Neptune DB cluster.
         */
        public var scalableDimension: aws.sdk.kotlin.services.applicationautoscaling.model.ScalableDimension? = null
        /**
         * The new minimum and maximum capacity. You can set both values or just one. At the scheduled time, if the current capacity is below the minimum capacity, Application Auto Scaling scales out to the minimum capacity. If the current capacity is above the maximum capacity, Application Auto Scaling scales in to the maximum capacity.
         */
        public var scalableTargetAction: aws.sdk.kotlin.services.applicationautoscaling.model.ScalableTargetAction? = null
        /**
         * The schedule for this action. The following formats are supported:
         * + At expressions - "`at(<i>yyyy</i>-<i>mm</i>-<i>dd</i>T<i>hh</i>:<i>mm</i>:<i>ss</i>)`"
         * + Rate expressions - "`rate(<i>value</i> <i>unit</i>)`"
         * + Cron expressions - "`cron(<i>fields</i>)`"
         *
         * At expressions are useful for one-time schedules. Cron expressions are useful for scheduled actions that run periodically at a specified date and time, and rate expressions are useful for scheduled actions that run at a regular interval.
         *
         * At and cron expressions use Universal Coordinated Time (UTC) by default.
         *
         * The cron format consists of six fields separated by white spaces: &#91;Minutes&#93; &#91;Hours&#93; &#91;Day_of_Month&#93; &#91;Month&#93; &#91;Day_of_Week&#93; &#91;Year&#93;.
         *
         * For rate expressions, *value* is a positive integer and *unit* is `minute` | `minutes` | `hour` | `hours` | `day` | `days`.
         *
         * For more information and examples, see [Example scheduled actions for Application Auto Scaling](https://docs.aws.amazon.com/autoscaling/application/userguide/examples-scheduled-actions.html) in the *Application Auto Scaling User Guide*.
         */
        public var schedule: kotlin.String? = null
        /**
         * The name of the scheduled action. This name must be unique among all other scheduled actions on the specified scalable target.
         */
        public var scheduledActionName: kotlin.String? = null
        /**
         * The namespace of the Amazon Web Services service that provides the resource. For a resource provided by your own application or service, use `custom-resource` instead.
         */
        public var serviceNamespace: aws.sdk.kotlin.services.applicationautoscaling.model.ServiceNamespace? = null
        /**
         * The date and time for this scheduled action to start, in UTC.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies the time zone used when setting a scheduled action by using an at or cron expression. If a time zone is not provided, UTC is used by default.
         *
         * Valid values are the canonical names of the IANA time zones supported by Joda-Time (such as `Etc/GMT+9` or `Pacific/Tahiti`). For more information, see [https://www.joda.org/joda-time/timezones.html](https://www.joda.org/joda-time/timezones.html).
         */
        public var timezone: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.applicationautoscaling.model.PutScheduledActionRequest) : this() {
            this.endTime = x.endTime
            this.resourceId = x.resourceId
            this.scalableDimension = x.scalableDimension
            this.scalableTargetAction = x.scalableTargetAction
            this.schedule = x.schedule
            this.scheduledActionName = x.scheduledActionName
            this.serviceNamespace = x.serviceNamespace
            this.startTime = x.startTime
            this.timezone = x.timezone
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.applicationautoscaling.model.PutScheduledActionRequest = PutScheduledActionRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.applicationautoscaling.model.ScalableTargetAction] inside the given [block]
         */
        public fun scalableTargetAction(block: aws.sdk.kotlin.services.applicationautoscaling.model.ScalableTargetAction.Builder.() -> kotlin.Unit) {
            this.scalableTargetAction = aws.sdk.kotlin.services.applicationautoscaling.model.ScalableTargetAction.invoke(block)
        }
    }
}
