// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationautoscaling.model



/**
 * Describes the reason for an activity that isn't scaled (*not scaled activity*), in machine-readable format. For help interpreting the not scaled reason details, see [Scaling activities for Application Auto Scaling](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-scaling-activities.html).
 */
public class NotScaledReason private constructor(builder: Builder) {
    /**
     * A code that represents the reason for not scaling.
     *
     * Valid values:
     * + AutoScalingAnticipatedFlapping
     * + TargetServicePutResourceAsUnscalable
     * + AlreadyAtMaxCapacity
     * + AlreadyAtMinCapacity
     * + AlreadyAtDesiredCapacity
     */
    public val code: kotlin.String? = builder.code
    /**
     * The current capacity.
     */
    public val currentCapacity: kotlin.Int? = builder.currentCapacity
    /**
     * The maximum capacity.
     */
    public val maxCapacity: kotlin.Int? = builder.maxCapacity
    /**
     * The minimum capacity.
     */
    public val minCapacity: kotlin.Int? = builder.minCapacity

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.applicationautoscaling.model.NotScaledReason = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NotScaledReason(")
        append("code=$code,")
        append("currentCapacity=$currentCapacity,")
        append("maxCapacity=$maxCapacity,")
        append("minCapacity=$minCapacity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = code?.hashCode() ?: 0
        result = 31 * result + (currentCapacity ?: 0)
        result = 31 * result + (maxCapacity ?: 0)
        result = 31 * result + (minCapacity ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NotScaledReason

        if (code != other.code) return false
        if (currentCapacity != other.currentCapacity) return false
        if (maxCapacity != other.maxCapacity) return false
        if (minCapacity != other.minCapacity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.applicationautoscaling.model.NotScaledReason = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A code that represents the reason for not scaling.
         *
         * Valid values:
         * + AutoScalingAnticipatedFlapping
         * + TargetServicePutResourceAsUnscalable
         * + AlreadyAtMaxCapacity
         * + AlreadyAtMinCapacity
         * + AlreadyAtDesiredCapacity
         */
        public var code: kotlin.String? = null
        /**
         * The current capacity.
         */
        public var currentCapacity: kotlin.Int? = null
        /**
         * The maximum capacity.
         */
        public var maxCapacity: kotlin.Int? = null
        /**
         * The minimum capacity.
         */
        public var minCapacity: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.applicationautoscaling.model.NotScaledReason) : this() {
            this.code = x.code
            this.currentCapacity = x.currentCapacity
            this.maxCapacity = x.maxCapacity
            this.minCapacity = x.minCapacity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.applicationautoscaling.model.NotScaledReason = NotScaledReason(this)
    }
}
