// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationautoscaling.model



/**
 * This structure defines the CloudWatch metric to return, along with the statistic, period, and unit.
 *
 * For more information about the CloudWatch terminology below, see [Amazon CloudWatch concepts](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html) in the *Amazon CloudWatch User Guide*.
 */
public class TargetTrackingMetricStat private constructor(builder: Builder) {
    /**
     * The CloudWatch metric to return, including the metric name, namespace, and dimensions. To get the exact metric name, namespace, and dimensions, inspect the [Metric](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html) object that is returned by a call to [ListMetrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html).
     */
    public val metric: aws.sdk.kotlin.services.applicationautoscaling.model.TargetTrackingMetric? = builder.metric
    /**
     * The statistic to return. It can include any CloudWatch statistic or extended statistic. For a list of valid values, see the table in [Statistics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic) in the *Amazon CloudWatch User Guide*.
     *
     * The most commonly used metric for scaling is `Average`.
     */
    public val stat: kotlin.String? = builder.stat
    /**
     * The unit to use for the returned data points. For a complete list of the units that CloudWatch supports, see the [MetricDatum](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html) data type in the *Amazon CloudWatch API Reference*.
     */
    public val unit: kotlin.String? = builder.unit

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.applicationautoscaling.model.TargetTrackingMetricStat = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TargetTrackingMetricStat(")
        append("metric=$metric,")
        append("stat=$stat,")
        append("unit=$unit")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = metric?.hashCode() ?: 0
        result = 31 * result + (stat?.hashCode() ?: 0)
        result = 31 * result + (unit?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TargetTrackingMetricStat

        if (metric != other.metric) return false
        if (stat != other.stat) return false
        if (unit != other.unit) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.applicationautoscaling.model.TargetTrackingMetricStat = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The CloudWatch metric to return, including the metric name, namespace, and dimensions. To get the exact metric name, namespace, and dimensions, inspect the [Metric](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html) object that is returned by a call to [ListMetrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html).
         */
        public var metric: aws.sdk.kotlin.services.applicationautoscaling.model.TargetTrackingMetric? = null
        /**
         * The statistic to return. It can include any CloudWatch statistic or extended statistic. For a list of valid values, see the table in [Statistics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic) in the *Amazon CloudWatch User Guide*.
         *
         * The most commonly used metric for scaling is `Average`.
         */
        public var stat: kotlin.String? = null
        /**
         * The unit to use for the returned data points. For a complete list of the units that CloudWatch supports, see the [MetricDatum](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html) data type in the *Amazon CloudWatch API Reference*.
         */
        public var unit: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.applicationautoscaling.model.TargetTrackingMetricStat) : this() {
            this.metric = x.metric
            this.stat = x.stat
            this.unit = x.unit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.applicationautoscaling.model.TargetTrackingMetricStat = TargetTrackingMetricStat(this)

        /**
         * construct an [aws.sdk.kotlin.services.applicationautoscaling.model.TargetTrackingMetric] inside the given [block]
         */
        public fun metric(block: aws.sdk.kotlin.services.applicationautoscaling.model.TargetTrackingMetric.Builder.() -> kotlin.Unit) {
            this.metric = aws.sdk.kotlin.services.applicationautoscaling.model.TargetTrackingMetric.invoke(block)
        }
    }
}
