// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationautoscaling.model



/**
 * Represents a target tracking scaling policy configuration to use with Application Auto Scaling.
 *
 * For more information, see [Target tracking scaling policies](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html) in the *Application Auto Scaling User Guide*.
 */
public class TargetTrackingScalingPolicyConfiguration private constructor(builder: Builder) {
    /**
     * A customized metric. You can specify either a predefined metric or a customized metric.
     */
    public val customizedMetricSpecification: aws.sdk.kotlin.services.applicationautoscaling.model.CustomizedMetricSpecification? = builder.customizedMetricSpecification
    /**
     * Indicates whether scale in by the target tracking scaling policy is disabled. If the value is `true`, scale in is disabled and the target tracking scaling policy won't remove capacity from the scalable target. Otherwise, scale in is enabled and the target tracking scaling policy can remove capacity from the scalable target. The default value is `false`.
     */
    public val disableScaleIn: kotlin.Boolean? = builder.disableScaleIn
    /**
     * A predefined metric. You can specify either a predefined metric or a customized metric.
     */
    public val predefinedMetricSpecification: aws.sdk.kotlin.services.applicationautoscaling.model.PredefinedMetricSpecification? = builder.predefinedMetricSpecification
    /**
     * The amount of time, in seconds, after a scale-in activity completes before another scale-in activity can start. For more information and for default values, see [Define cooldown periods](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html#target-tracking-cooldown) in the *Application Auto Scaling User Guide*.
     */
    public val scaleInCooldown: kotlin.Int? = builder.scaleInCooldown
    /**
     * The amount of time, in seconds, to wait for a previous scale-out activity to take effect. For more information and for default values, see [Define cooldown periods](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html#target-tracking-cooldown) in the *Application Auto Scaling User Guide*.
     */
    public val scaleOutCooldown: kotlin.Int? = builder.scaleOutCooldown
    /**
     * The target value for the metric. Although this property accepts numbers of type Double, it won't accept values that are either too small or too large. Values must be in the range of -2^360 to 2^360. The value must be a valid number based on the choice of metric. For example, if the metric is CPU utilization, then the target value is a percent value that represents how much of the CPU can be used before scaling out.
     *
     * If the scaling policy specifies the `ALBRequestCountPerTarget` predefined metric, specify the target utilization as the optimal average request count per target during any one-minute interval.
     */
    public val targetValue: kotlin.Double? = builder.targetValue

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.applicationautoscaling.model.TargetTrackingScalingPolicyConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TargetTrackingScalingPolicyConfiguration(")
        append("customizedMetricSpecification=$customizedMetricSpecification,")
        append("disableScaleIn=$disableScaleIn,")
        append("predefinedMetricSpecification=$predefinedMetricSpecification,")
        append("scaleInCooldown=$scaleInCooldown,")
        append("scaleOutCooldown=$scaleOutCooldown,")
        append("targetValue=$targetValue")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = customizedMetricSpecification?.hashCode() ?: 0
        result = 31 * result + (disableScaleIn?.hashCode() ?: 0)
        result = 31 * result + (predefinedMetricSpecification?.hashCode() ?: 0)
        result = 31 * result + (scaleInCooldown ?: 0)
        result = 31 * result + (scaleOutCooldown ?: 0)
        result = 31 * result + (targetValue?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TargetTrackingScalingPolicyConfiguration

        if (customizedMetricSpecification != other.customizedMetricSpecification) return false
        if (disableScaleIn != other.disableScaleIn) return false
        if (predefinedMetricSpecification != other.predefinedMetricSpecification) return false
        if (scaleInCooldown != other.scaleInCooldown) return false
        if (scaleOutCooldown != other.scaleOutCooldown) return false
        if (targetValue != other.targetValue) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.applicationautoscaling.model.TargetTrackingScalingPolicyConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A customized metric. You can specify either a predefined metric or a customized metric.
         */
        public var customizedMetricSpecification: aws.sdk.kotlin.services.applicationautoscaling.model.CustomizedMetricSpecification? = null
        /**
         * Indicates whether scale in by the target tracking scaling policy is disabled. If the value is `true`, scale in is disabled and the target tracking scaling policy won't remove capacity from the scalable target. Otherwise, scale in is enabled and the target tracking scaling policy can remove capacity from the scalable target. The default value is `false`.
         */
        public var disableScaleIn: kotlin.Boolean? = null
        /**
         * A predefined metric. You can specify either a predefined metric or a customized metric.
         */
        public var predefinedMetricSpecification: aws.sdk.kotlin.services.applicationautoscaling.model.PredefinedMetricSpecification? = null
        /**
         * The amount of time, in seconds, after a scale-in activity completes before another scale-in activity can start. For more information and for default values, see [Define cooldown periods](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html#target-tracking-cooldown) in the *Application Auto Scaling User Guide*.
         */
        public var scaleInCooldown: kotlin.Int? = null
        /**
         * The amount of time, in seconds, to wait for a previous scale-out activity to take effect. For more information and for default values, see [Define cooldown periods](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html#target-tracking-cooldown) in the *Application Auto Scaling User Guide*.
         */
        public var scaleOutCooldown: kotlin.Int? = null
        /**
         * The target value for the metric. Although this property accepts numbers of type Double, it won't accept values that are either too small or too large. Values must be in the range of -2^360 to 2^360. The value must be a valid number based on the choice of metric. For example, if the metric is CPU utilization, then the target value is a percent value that represents how much of the CPU can be used before scaling out.
         *
         * If the scaling policy specifies the `ALBRequestCountPerTarget` predefined metric, specify the target utilization as the optimal average request count per target during any one-minute interval.
         */
        public var targetValue: kotlin.Double? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.applicationautoscaling.model.TargetTrackingScalingPolicyConfiguration) : this() {
            this.customizedMetricSpecification = x.customizedMetricSpecification
            this.disableScaleIn = x.disableScaleIn
            this.predefinedMetricSpecification = x.predefinedMetricSpecification
            this.scaleInCooldown = x.scaleInCooldown
            this.scaleOutCooldown = x.scaleOutCooldown
            this.targetValue = x.targetValue
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.applicationautoscaling.model.TargetTrackingScalingPolicyConfiguration = TargetTrackingScalingPolicyConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.applicationautoscaling.model.CustomizedMetricSpecification] inside the given [block]
         */
        public fun customizedMetricSpecification(block: aws.sdk.kotlin.services.applicationautoscaling.model.CustomizedMetricSpecification.Builder.() -> kotlin.Unit) {
            this.customizedMetricSpecification = aws.sdk.kotlin.services.applicationautoscaling.model.CustomizedMetricSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.applicationautoscaling.model.PredefinedMetricSpecification] inside the given [block]
         */
        public fun predefinedMetricSpecification(block: aws.sdk.kotlin.services.applicationautoscaling.model.PredefinedMetricSpecification.Builder.() -> kotlin.Unit) {
            this.predefinedMetricSpecification = aws.sdk.kotlin.services.applicationautoscaling.model.PredefinedMetricSpecification.invoke(block)
        }
    }
}
