// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationautoscaling.transform

import aws.sdk.kotlin.services.applicationautoscaling.model.ApplicationAutoScalingException
import aws.sdk.kotlin.services.applicationautoscaling.model.RegisterScalableTargetResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class RegisterScalableTargetOperationDeserializer: HttpDeserialize<RegisterScalableTargetResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): RegisterScalableTargetResponse {
        if (!response.status.isSuccess()) {
            throwRegisterScalableTargetError(context, response)
        }
        val builder = RegisterScalableTargetResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeRegisterScalableTargetOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwRegisterScalableTargetError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ApplicationAutoScalingException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConcurrentUpdateException" -> ConcurrentUpdateExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ApplicationAutoScalingException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeRegisterScalableTargetOperationBody(builder: RegisterScalableTargetResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val SCALABLETARGETARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ScalableTargetARN"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(SCALABLETARGETARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                SCALABLETARGETARN_DESCRIPTOR.index -> builder.scalableTargetArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
