// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationautoscaling

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.applicationautoscaling.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.applicationautoscaling.endpoints.EndpointParameters
import aws.sdk.kotlin.services.applicationautoscaling.endpoints.EndpointProvider
import aws.sdk.kotlin.services.applicationautoscaling.model.DeleteScalingPolicyRequest
import aws.sdk.kotlin.services.applicationautoscaling.model.DeleteScalingPolicyResponse
import aws.sdk.kotlin.services.applicationautoscaling.model.DeleteScheduledActionRequest
import aws.sdk.kotlin.services.applicationautoscaling.model.DeleteScheduledActionResponse
import aws.sdk.kotlin.services.applicationautoscaling.model.DeregisterScalableTargetRequest
import aws.sdk.kotlin.services.applicationautoscaling.model.DeregisterScalableTargetResponse
import aws.sdk.kotlin.services.applicationautoscaling.model.DescribeScalableTargetsRequest
import aws.sdk.kotlin.services.applicationautoscaling.model.DescribeScalableTargetsResponse
import aws.sdk.kotlin.services.applicationautoscaling.model.DescribeScalingActivitiesRequest
import aws.sdk.kotlin.services.applicationautoscaling.model.DescribeScalingActivitiesResponse
import aws.sdk.kotlin.services.applicationautoscaling.model.DescribeScalingPoliciesRequest
import aws.sdk.kotlin.services.applicationautoscaling.model.DescribeScalingPoliciesResponse
import aws.sdk.kotlin.services.applicationautoscaling.model.DescribeScheduledActionsRequest
import aws.sdk.kotlin.services.applicationautoscaling.model.DescribeScheduledActionsResponse
import aws.sdk.kotlin.services.applicationautoscaling.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.applicationautoscaling.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.applicationautoscaling.model.PutScalingPolicyRequest
import aws.sdk.kotlin.services.applicationautoscaling.model.PutScalingPolicyResponse
import aws.sdk.kotlin.services.applicationautoscaling.model.PutScheduledActionRequest
import aws.sdk.kotlin.services.applicationautoscaling.model.PutScheduledActionResponse
import aws.sdk.kotlin.services.applicationautoscaling.model.RegisterScalableTargetRequest
import aws.sdk.kotlin.services.applicationautoscaling.model.RegisterScalableTargetResponse
import aws.sdk.kotlin.services.applicationautoscaling.model.TagResourceRequest
import aws.sdk.kotlin.services.applicationautoscaling.model.TagResourceResponse
import aws.sdk.kotlin.services.applicationautoscaling.model.UntagResourceRequest
import aws.sdk.kotlin.services.applicationautoscaling.model.UntagResourceResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Application Auto Scaling"
public const val SdkVersion: String = "0.29.1-beta"

/**
 * With Application Auto Scaling, you can configure automatic scaling for the following resources:
 * + Amazon AppStream 2.0 fleets
 * + Amazon Aurora Replicas
 * + Amazon Comprehend document classification and entity recognizer endpoints
 * + Amazon DynamoDB tables and global secondary indexes throughput capacity
 * + Amazon ECS services
 * + Amazon ElastiCache for Redis clusters (replication groups)
 * + Amazon EMR clusters
 * + Amazon Keyspaces (for Apache Cassandra) tables
 * + Lambda function provisioned concurrency
 * + Amazon Managed Streaming for Apache Kafka broker storage
 * + Amazon Neptune clusters
 * + Amazon SageMaker endpoint variants
 * + Amazon SageMaker Serverless endpoint provisioned concurrency
 * + Spot Fleets (Amazon EC2)
 * + Custom resources provided by your own applications or services
 *
 * To learn more about Application Auto Scaling, see the [Application Auto Scaling User Guide](https://docs.aws.amazon.com/autoscaling/application/userguide/what-is-application-auto-scaling.html).
 *
 * **API Summary**
 *
 * The Application Auto Scaling service API includes three key sets of actions:
 * + Register and manage scalable targets - Register Amazon Web Services or custom resources as scalable targets (a resource that Application Auto Scaling can scale), set minimum and maximum capacity limits, and retrieve information on existing scalable targets.
 * + Configure and manage automatic scaling - Define scaling policies to dynamically scale your resources in response to CloudWatch alarms, schedule one-time or recurring scaling actions, and retrieve your recent scaling activity history.
 * + Suspend and resume scaling - Temporarily suspend and later resume automatic scaling by calling the [RegisterScalableTarget](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html) API action for any Application Auto Scaling scalable target. You can suspend and resume (individually or in combination) scale-out activities that are triggered by a scaling policy, scale-in activities that are triggered by a scaling policy, and scheduled scaling.
 */
public interface ApplicationAutoScalingClient : SdkClient {
    /**
     * ApplicationAutoScalingClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, ApplicationAutoScalingClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, ApplicationAutoScalingClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): ApplicationAutoScalingClient = DefaultApplicationAutoScalingClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsDefaultRetryPolicy
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Application Auto Scaling"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [HttpAuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: EndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Deletes the specified scaling policy for an Application Auto Scaling scalable target.
     *
     * Deleting a step scaling policy deletes the underlying alarm action, but does not delete the CloudWatch alarm associated with the scaling policy, even if it no longer has an associated action.
     *
     * For more information, see [Delete a step scaling policy](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html#delete-step-scaling-policy) and [Delete a target tracking scaling policy](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html#delete-target-tracking-policy) in the *Application Auto Scaling User Guide*.
     */
    public suspend fun deleteScalingPolicy(input: DeleteScalingPolicyRequest): DeleteScalingPolicyResponse

    /**
     * Deletes the specified scheduled action for an Application Auto Scaling scalable target.
     *
     * For more information, see [Delete a scheduled action](https://docs.aws.amazon.com/autoscaling/application/userguide/scheduled-scaling-additional-cli-commands.html#delete-scheduled-action) in the *Application Auto Scaling User Guide*.
     */
    public suspend fun deleteScheduledAction(input: DeleteScheduledActionRequest): DeleteScheduledActionResponse

    /**
     * Deregisters an Application Auto Scaling scalable target when you have finished using it. To see which resources have been registered, use [DescribeScalableTargets](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DescribeScalableTargets.html).
     *
     * Deregistering a scalable target deletes the scaling policies and the scheduled actions that are associated with it.
     */
    public suspend fun deregisterScalableTarget(input: DeregisterScalableTargetRequest): DeregisterScalableTargetResponse

    /**
     * Gets information about the scalable targets in the specified namespace.
     *
     * You can filter the results using `ResourceIds` and `ScalableDimension`.
     */
    public suspend fun describeScalableTargets(input: DescribeScalableTargetsRequest): DescribeScalableTargetsResponse

    /**
     * Provides descriptive information about the scaling activities in the specified namespace from the previous six weeks.
     *
     * You can filter the results using `ResourceId` and `ScalableDimension`.
     *
     * For information about viewing scaling activities using the Amazon Web Services CLI, see [Scaling activities for Application Auto Scaling](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-scaling-activities.html).
     */
    public suspend fun describeScalingActivities(input: DescribeScalingActivitiesRequest): DescribeScalingActivitiesResponse

    /**
     * Describes the Application Auto Scaling scaling policies for the specified service namespace.
     *
     * You can filter the results using `ResourceId`, `ScalableDimension`, and `PolicyNames`.
     *
     * For more information, see [Target tracking scaling policies](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html) and [Step scaling policies](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html) in the *Application Auto Scaling User Guide*.
     */
    public suspend fun describeScalingPolicies(input: DescribeScalingPoliciesRequest): DescribeScalingPoliciesResponse

    /**
     * Describes the Application Auto Scaling scheduled actions for the specified service namespace.
     *
     * You can filter the results using the `ResourceId`, `ScalableDimension`, and `ScheduledActionNames` parameters.
     *
     * For more information, see [Scheduled scaling](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-scheduled-scaling.html) and [Managing scheduled scaling](https://docs.aws.amazon.com/autoscaling/application/userguide/scheduled-scaling-additional-cli-commands.html) in the *Application Auto Scaling User Guide*.
     */
    public suspend fun describeScheduledActions(input: DescribeScheduledActionsRequest): DescribeScheduledActionsResponse

    /**
     * Returns all the tags on the specified Application Auto Scaling scalable target.
     *
     * For general information about tags, including the format and syntax, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference*.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Creates or updates a scaling policy for an Application Auto Scaling scalable target.
     *
     * Each scalable target is identified by a service namespace, resource ID, and scalable dimension. A scaling policy applies to the scalable target identified by those three attributes. You cannot create a scaling policy until you have registered the resource as a scalable target.
     *
     * Multiple scaling policies can be in force at the same time for the same scalable target. You can have one or more target tracking scaling policies, one or more step scaling policies, or both. However, there is a chance that multiple policies could conflict, instructing the scalable target to scale out or in at the same time. Application Auto Scaling gives precedence to the policy that provides the largest capacity for both scale out and scale in. For example, if one policy increases capacity by 3, another policy increases capacity by 200 percent, and the current capacity is 10, Application Auto Scaling uses the policy with the highest calculated capacity (200% of 10 = 20) and scales out to 30.
     *
     * We recommend caution, however, when using target tracking scaling policies with step scaling policies because conflicts between these policies can cause undesirable behavior. For example, if the step scaling policy initiates a scale-in activity before the target tracking policy is ready to scale in, the scale-in activity will not be blocked. After the scale-in activity completes, the target tracking policy could instruct the scalable target to scale out again.
     *
     * For more information, see [Target tracking scaling policies](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html) and [Step scaling policies](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html) in the *Application Auto Scaling User Guide*.
     *
     * If a scalable target is deregistered, the scalable target is no longer available to use scaling policies. Any scaling policies that were specified for the scalable target are deleted.
     */
    public suspend fun putScalingPolicy(input: PutScalingPolicyRequest): PutScalingPolicyResponse

    /**
     * Creates or updates a scheduled action for an Application Auto Scaling scalable target.
     *
     * Each scalable target is identified by a service namespace, resource ID, and scalable dimension. A scheduled action applies to the scalable target identified by those three attributes. You cannot create a scheduled action until you have registered the resource as a scalable target.
     *
     * When you specify start and end times with a recurring schedule using a cron expression or rates, they form the boundaries for when the recurring action starts and stops.
     *
     * To update a scheduled action, specify the parameters that you want to change. If you don't specify start and end times, the old values are deleted.
     *
     * For more information, see [Scheduled scaling](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-scheduled-scaling.html) in the *Application Auto Scaling User Guide*.
     *
     * If a scalable target is deregistered, the scalable target is no longer available to run scheduled actions. Any scheduled actions that were specified for the scalable target are deleted.
     */
    public suspend fun putScheduledAction(input: PutScheduledActionRequest): PutScheduledActionResponse

    /**
     * Registers or updates a scalable target, which is the resource that you want to scale.
     *
     * Scalable targets are uniquely identified by the combination of resource ID, scalable dimension, and namespace, which represents some capacity dimension of the underlying service.
     *
     * When you register a new scalable target, you must specify values for the minimum and maximum capacity. If the specified resource is not active in the target service, this operation does not change the resource's current capacity. Otherwise, it changes the resource's current capacity to a value that is inside of this range.
     *
     * If you add a scaling policy, current capacity is adjustable within the specified range when scaling starts. Application Auto Scaling scaling policies will not scale capacity to values that are outside of the minimum and maximum range.
     *
     * After you register a scalable target, you do not need to register it again to use other Application Auto Scaling operations. To see which resources have been registered, use [DescribeScalableTargets](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DescribeScalableTargets.html). You can also view the scaling policies for a service namespace by using [DescribeScalableTargets](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DescribeScalableTargets.html). If you no longer need a scalable target, you can deregister it by using [DeregisterScalableTarget](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DeregisterScalableTarget.html).
     *
     * To update a scalable target, specify the parameters that you want to change. Include the parameters that identify the scalable target: resource ID, scalable dimension, and namespace. Any parameters that you don't specify are not changed by this update request.
     *
     * If you call the `RegisterScalableTarget` API operation to create a scalable target, there might be a brief delay until the operation achieves [eventual consistency](https://en.wikipedia.org/wiki/Eventual_consistency). You might become aware of this brief delay if you get unexpected errors when performing sequential operations. The typical strategy is to retry the request, and some Amazon Web Services SDKs include automatic backoff and retry logic.
     *
     * If you call the `RegisterScalableTarget` API operation to update an existing scalable target, Application Auto Scaling retrieves the current capacity of the resource. If it's below the minimum capacity or above the maximum capacity, Application Auto Scaling adjusts the capacity of the scalable target to place it within these bounds, even if you don't include the `MinCapacity` or `MaxCapacity` request parameters.
     */
    public suspend fun registerScalableTarget(input: RegisterScalableTargetRequest): RegisterScalableTargetResponse

    /**
     * Adds or edits tags on an Application Auto Scaling scalable target.
     *
     * Each tag consists of a tag key and a tag value, which are both case-sensitive strings. To add a tag, specify a new tag key and a tag value. To edit a tag, specify an existing tag key and a new tag value.
     *
     * You can use this operation to tag an Application Auto Scaling scalable target, but you cannot tag a scaling policy or scheduled action.
     *
     * You can also add tags to an Application Auto Scaling scalable target while creating it (`RegisterScalableTarget`).
     *
     * For general information about tags, including the format and syntax, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference*.
     *
     * Use tags to control access to a scalable target. For more information, see [Tagging support for Application Auto Scaling](https://docs.aws.amazon.com/autoscaling/application/userguide/resource-tagging-support.html) in the *Application Auto Scaling User Guide*.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Deletes tags from an Application Auto Scaling scalable target. To delete a tag, specify the tag key and the Application Auto Scaling scalable target.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun ApplicationAutoScalingClient.withConfig(block: ApplicationAutoScalingClient.Config.Builder.() -> Unit): ApplicationAutoScalingClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultApplicationAutoScalingClient(newConfig)
}

/**
 * Deletes the specified scaling policy for an Application Auto Scaling scalable target.
 *
 * Deleting a step scaling policy deletes the underlying alarm action, but does not delete the CloudWatch alarm associated with the scaling policy, even if it no longer has an associated action.
 *
 * For more information, see [Delete a step scaling policy](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html#delete-step-scaling-policy) and [Delete a target tracking scaling policy](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html#delete-target-tracking-policy) in the *Application Auto Scaling User Guide*.
 */
public suspend inline fun ApplicationAutoScalingClient.deleteScalingPolicy(crossinline block: DeleteScalingPolicyRequest.Builder.() -> Unit): DeleteScalingPolicyResponse = deleteScalingPolicy(DeleteScalingPolicyRequest.Builder().apply(block).build())

/**
 * Deletes the specified scheduled action for an Application Auto Scaling scalable target.
 *
 * For more information, see [Delete a scheduled action](https://docs.aws.amazon.com/autoscaling/application/userguide/scheduled-scaling-additional-cli-commands.html#delete-scheduled-action) in the *Application Auto Scaling User Guide*.
 */
public suspend inline fun ApplicationAutoScalingClient.deleteScheduledAction(crossinline block: DeleteScheduledActionRequest.Builder.() -> Unit): DeleteScheduledActionResponse = deleteScheduledAction(DeleteScheduledActionRequest.Builder().apply(block).build())

/**
 * Deregisters an Application Auto Scaling scalable target when you have finished using it. To see which resources have been registered, use [DescribeScalableTargets](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DescribeScalableTargets.html).
 *
 * Deregistering a scalable target deletes the scaling policies and the scheduled actions that are associated with it.
 */
public suspend inline fun ApplicationAutoScalingClient.deregisterScalableTarget(crossinline block: DeregisterScalableTargetRequest.Builder.() -> Unit): DeregisterScalableTargetResponse = deregisterScalableTarget(DeregisterScalableTargetRequest.Builder().apply(block).build())

/**
 * Gets information about the scalable targets in the specified namespace.
 *
 * You can filter the results using `ResourceIds` and `ScalableDimension`.
 */
public suspend inline fun ApplicationAutoScalingClient.describeScalableTargets(crossinline block: DescribeScalableTargetsRequest.Builder.() -> Unit): DescribeScalableTargetsResponse = describeScalableTargets(DescribeScalableTargetsRequest.Builder().apply(block).build())

/**
 * Provides descriptive information about the scaling activities in the specified namespace from the previous six weeks.
 *
 * You can filter the results using `ResourceId` and `ScalableDimension`.
 *
 * For information about viewing scaling activities using the Amazon Web Services CLI, see [Scaling activities for Application Auto Scaling](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-scaling-activities.html).
 */
public suspend inline fun ApplicationAutoScalingClient.describeScalingActivities(crossinline block: DescribeScalingActivitiesRequest.Builder.() -> Unit): DescribeScalingActivitiesResponse = describeScalingActivities(DescribeScalingActivitiesRequest.Builder().apply(block).build())

/**
 * Describes the Application Auto Scaling scaling policies for the specified service namespace.
 *
 * You can filter the results using `ResourceId`, `ScalableDimension`, and `PolicyNames`.
 *
 * For more information, see [Target tracking scaling policies](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html) and [Step scaling policies](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html) in the *Application Auto Scaling User Guide*.
 */
public suspend inline fun ApplicationAutoScalingClient.describeScalingPolicies(crossinline block: DescribeScalingPoliciesRequest.Builder.() -> Unit): DescribeScalingPoliciesResponse = describeScalingPolicies(DescribeScalingPoliciesRequest.Builder().apply(block).build())

/**
 * Describes the Application Auto Scaling scheduled actions for the specified service namespace.
 *
 * You can filter the results using the `ResourceId`, `ScalableDimension`, and `ScheduledActionNames` parameters.
 *
 * For more information, see [Scheduled scaling](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-scheduled-scaling.html) and [Managing scheduled scaling](https://docs.aws.amazon.com/autoscaling/application/userguide/scheduled-scaling-additional-cli-commands.html) in the *Application Auto Scaling User Guide*.
 */
public suspend inline fun ApplicationAutoScalingClient.describeScheduledActions(crossinline block: DescribeScheduledActionsRequest.Builder.() -> Unit): DescribeScheduledActionsResponse = describeScheduledActions(DescribeScheduledActionsRequest.Builder().apply(block).build())

/**
 * Returns all the tags on the specified Application Auto Scaling scalable target.
 *
 * For general information about tags, including the format and syntax, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference*.
 */
public suspend inline fun ApplicationAutoScalingClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Creates or updates a scaling policy for an Application Auto Scaling scalable target.
 *
 * Each scalable target is identified by a service namespace, resource ID, and scalable dimension. A scaling policy applies to the scalable target identified by those three attributes. You cannot create a scaling policy until you have registered the resource as a scalable target.
 *
 * Multiple scaling policies can be in force at the same time for the same scalable target. You can have one or more target tracking scaling policies, one or more step scaling policies, or both. However, there is a chance that multiple policies could conflict, instructing the scalable target to scale out or in at the same time. Application Auto Scaling gives precedence to the policy that provides the largest capacity for both scale out and scale in. For example, if one policy increases capacity by 3, another policy increases capacity by 200 percent, and the current capacity is 10, Application Auto Scaling uses the policy with the highest calculated capacity (200% of 10 = 20) and scales out to 30.
 *
 * We recommend caution, however, when using target tracking scaling policies with step scaling policies because conflicts between these policies can cause undesirable behavior. For example, if the step scaling policy initiates a scale-in activity before the target tracking policy is ready to scale in, the scale-in activity will not be blocked. After the scale-in activity completes, the target tracking policy could instruct the scalable target to scale out again.
 *
 * For more information, see [Target tracking scaling policies](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html) and [Step scaling policies](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html) in the *Application Auto Scaling User Guide*.
 *
 * If a scalable target is deregistered, the scalable target is no longer available to use scaling policies. Any scaling policies that were specified for the scalable target are deleted.
 */
public suspend inline fun ApplicationAutoScalingClient.putScalingPolicy(crossinline block: PutScalingPolicyRequest.Builder.() -> Unit): PutScalingPolicyResponse = putScalingPolicy(PutScalingPolicyRequest.Builder().apply(block).build())

/**
 * Creates or updates a scheduled action for an Application Auto Scaling scalable target.
 *
 * Each scalable target is identified by a service namespace, resource ID, and scalable dimension. A scheduled action applies to the scalable target identified by those three attributes. You cannot create a scheduled action until you have registered the resource as a scalable target.
 *
 * When you specify start and end times with a recurring schedule using a cron expression or rates, they form the boundaries for when the recurring action starts and stops.
 *
 * To update a scheduled action, specify the parameters that you want to change. If you don't specify start and end times, the old values are deleted.
 *
 * For more information, see [Scheduled scaling](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-scheduled-scaling.html) in the *Application Auto Scaling User Guide*.
 *
 * If a scalable target is deregistered, the scalable target is no longer available to run scheduled actions. Any scheduled actions that were specified for the scalable target are deleted.
 */
public suspend inline fun ApplicationAutoScalingClient.putScheduledAction(crossinline block: PutScheduledActionRequest.Builder.() -> Unit): PutScheduledActionResponse = putScheduledAction(PutScheduledActionRequest.Builder().apply(block).build())

/**
 * Registers or updates a scalable target, which is the resource that you want to scale.
 *
 * Scalable targets are uniquely identified by the combination of resource ID, scalable dimension, and namespace, which represents some capacity dimension of the underlying service.
 *
 * When you register a new scalable target, you must specify values for the minimum and maximum capacity. If the specified resource is not active in the target service, this operation does not change the resource's current capacity. Otherwise, it changes the resource's current capacity to a value that is inside of this range.
 *
 * If you add a scaling policy, current capacity is adjustable within the specified range when scaling starts. Application Auto Scaling scaling policies will not scale capacity to values that are outside of the minimum and maximum range.
 *
 * After you register a scalable target, you do not need to register it again to use other Application Auto Scaling operations. To see which resources have been registered, use [DescribeScalableTargets](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DescribeScalableTargets.html). You can also view the scaling policies for a service namespace by using [DescribeScalableTargets](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DescribeScalableTargets.html). If you no longer need a scalable target, you can deregister it by using [DeregisterScalableTarget](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DeregisterScalableTarget.html).
 *
 * To update a scalable target, specify the parameters that you want to change. Include the parameters that identify the scalable target: resource ID, scalable dimension, and namespace. Any parameters that you don't specify are not changed by this update request.
 *
 * If you call the `RegisterScalableTarget` API operation to create a scalable target, there might be a brief delay until the operation achieves [eventual consistency](https://en.wikipedia.org/wiki/Eventual_consistency). You might become aware of this brief delay if you get unexpected errors when performing sequential operations. The typical strategy is to retry the request, and some Amazon Web Services SDKs include automatic backoff and retry logic.
 *
 * If you call the `RegisterScalableTarget` API operation to update an existing scalable target, Application Auto Scaling retrieves the current capacity of the resource. If it's below the minimum capacity or above the maximum capacity, Application Auto Scaling adjusts the capacity of the scalable target to place it within these bounds, even if you don't include the `MinCapacity` or `MaxCapacity` request parameters.
 */
public suspend inline fun ApplicationAutoScalingClient.registerScalableTarget(crossinline block: RegisterScalableTargetRequest.Builder.() -> Unit): RegisterScalableTargetResponse = registerScalableTarget(RegisterScalableTargetRequest.Builder().apply(block).build())

/**
 * Adds or edits tags on an Application Auto Scaling scalable target.
 *
 * Each tag consists of a tag key and a tag value, which are both case-sensitive strings. To add a tag, specify a new tag key and a tag value. To edit a tag, specify an existing tag key and a new tag value.
 *
 * You can use this operation to tag an Application Auto Scaling scalable target, but you cannot tag a scaling policy or scheduled action.
 *
 * You can also add tags to an Application Auto Scaling scalable target while creating it (`RegisterScalableTarget`).
 *
 * For general information about tags, including the format and syntax, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference*.
 *
 * Use tags to control access to a scalable target. For more information, see [Tagging support for Application Auto Scaling](https://docs.aws.amazon.com/autoscaling/application/userguide/resource-tagging-support.html) in the *Application Auto Scaling User Guide*.
 */
public suspend inline fun ApplicationAutoScalingClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Deletes tags from an Application Auto Scaling scalable target. To delete a tag, specify the tag key and the Application Auto Scaling scalable target.
 */
public suspend inline fun ApplicationAutoScalingClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())
