// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationautoscaling.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents a scalable target.
 */
public class ScalableTarget private constructor(builder: Builder) {
    /**
     * The Unix timestamp for when the scalable target was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The maximum value to scale to in response to a scale-out activity.
     */
    public val maxCapacity: kotlin.Int? = builder.maxCapacity
    /**
     * The minimum value to scale to in response to a scale-in activity.
     */
    public val minCapacity: kotlin.Int? = builder.minCapacity
    /**
     * The identifier of the resource associated with the scalable target. This string consists of the resource type and unique identifier.
     * + ECS service - The resource type is `service` and the unique identifier is the cluster name and service name. Example: `service/default/sample-webapp`.
     * + Spot Fleet - The resource type is `spot-fleet-request` and the unique identifier is the Spot Fleet request ID. Example: `spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE`.
     * + EMR cluster - The resource type is `instancegroup` and the unique identifier is the cluster ID and instance group ID. Example: `instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0`.
     * + AppStream 2.0 fleet - The resource type is `fleet` and the unique identifier is the fleet name. Example: `fleet/sample-fleet`.
     * + DynamoDB table - The resource type is `table` and the unique identifier is the table name. Example: `table/my-table`.
     * + DynamoDB global secondary index - The resource type is `index` and the unique identifier is the index name. Example: `table/my-table/index/my-table-index`.
     * + Aurora DB cluster - The resource type is `cluster` and the unique identifier is the cluster name. Example: `cluster:my-db-cluster`.
     * + SageMaker endpoint variant - The resource type is `variant` and the unique identifier is the resource ID. Example: `endpoint/my-end-point/variant/KMeansClustering`.
     * + Custom resources are not supported with a resource type. This parameter must specify the `OutputValue` from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information is available in our [GitHub repository](https://github.com/aws/aws-auto-scaling-custom-resource).
     * + Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: `arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE`.
     * + Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: `arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE`.
     * + Lambda provisioned concurrency - The resource type is `function` and the unique identifier is the function name with a function version or alias name suffix that is not `$LATEST`. Example: `function:my-function:prod` or `function:my-function:1`.
     * + Amazon Keyspaces table - The resource type is `table` and the unique identifier is the table name. Example: `keyspace/mykeyspace/table/mytable`.
     * + Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN. Example: `arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5`.
     * + Amazon ElastiCache replication group - The resource type is `replication-group` and the unique identifier is the replication group name. Example: `replication-group/mycluster`.
     * + Neptune cluster - The resource type is `cluster` and the unique identifier is the cluster name. Example: `cluster:mycluster`.
     * + SageMaker Serverless endpoint - The resource type is `variant` and the unique identifier is the resource ID. Example: `endpoint/my-end-point/variant/KMeansClustering`.
     */
    public val resourceId: kotlin.String? = builder.resourceId
    /**
     * The ARN of an IAM role that allows Application Auto Scaling to modify the scalable target on your behalf.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The scalable dimension associated with the scalable target. This string consists of the service namespace, resource type, and scaling property.
     * + `ecs:service:DesiredCount` - The desired task count of an ECS service.
     * + `elasticmapreduce:instancegroup:InstanceCount` - The instance count of an EMR Instance Group.
     * + `ec2:spot-fleet-request:TargetCapacity` - The target capacity of a Spot Fleet.
     * + `appstream:fleet:DesiredCapacity` - The desired capacity of an AppStream 2.0 fleet.
     * + `dynamodb:table:ReadCapacityUnits` - The provisioned read capacity for a DynamoDB table.
     * + `dynamodb:table:WriteCapacityUnits` - The provisioned write capacity for a DynamoDB table.
     * + `dynamodb:index:ReadCapacityUnits` - The provisioned read capacity for a DynamoDB global secondary index.
     * + `dynamodb:index:WriteCapacityUnits` - The provisioned write capacity for a DynamoDB global secondary index.
     * + `rds:cluster:ReadReplicaCount` - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
     * + `sagemaker:variant:DesiredInstanceCount` - The number of EC2 instances for a SageMaker model endpoint variant.
     * + `custom-resource:ResourceType:Property` - The scalable dimension for a custom resource provided by your own application or service.
     * + `comprehend:document-classifier-endpoint:DesiredInferenceUnits` - The number of inference units for an Amazon Comprehend document classification endpoint.
     * + `comprehend:entity-recognizer-endpoint:DesiredInferenceUnits` - The number of inference units for an Amazon Comprehend entity recognizer endpoint.
     * + `lambda:function:ProvisionedConcurrency` - The provisioned concurrency for a Lambda function.
     * + `cassandra:table:ReadCapacityUnits` - The provisioned read capacity for an Amazon Keyspaces table.
     * + `cassandra:table:WriteCapacityUnits` - The provisioned write capacity for an Amazon Keyspaces table.
     * + `kafka:broker-storage:VolumeSize` - The provisioned volume size (in GiB) for brokers in an Amazon MSK cluster.
     * + `elasticache:replication-group:NodeGroups` - The number of node groups for an Amazon ElastiCache replication group.
     * + `elasticache:replication-group:Replicas` - The number of replicas per node group for an Amazon ElastiCache replication group.
     * + `neptune:cluster:ReadReplicaCount` - The count of read replicas in an Amazon Neptune DB cluster.
     * + `sagemaker:variant:DesiredProvisionedConcurrency` - The provisioned concurrency for a SageMaker Serverless endpoint.
     */
    public val scalableDimension: aws.sdk.kotlin.services.applicationautoscaling.model.ScalableDimension? = builder.scalableDimension
    /**
     * The ARN of the scalable target.
     */
    public val scalableTargetArn: kotlin.String? = builder.scalableTargetArn
    /**
     * The namespace of the Amazon Web Services service that provides the resource, or a `custom-resource`.
     */
    public val serviceNamespace: aws.sdk.kotlin.services.applicationautoscaling.model.ServiceNamespace? = builder.serviceNamespace
    /**
     * Specifies whether the scaling activities for a scalable target are in a suspended state.
     */
    public val suspendedState: aws.sdk.kotlin.services.applicationautoscaling.model.SuspendedState? = builder.suspendedState

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.applicationautoscaling.model.ScalableTarget = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ScalableTarget(")
        append("creationTime=$creationTime,")
        append("maxCapacity=$maxCapacity,")
        append("minCapacity=$minCapacity,")
        append("resourceId=$resourceId,")
        append("roleArn=$roleArn,")
        append("scalableDimension=$scalableDimension,")
        append("scalableTargetArn=$scalableTargetArn,")
        append("serviceNamespace=$serviceNamespace,")
        append("suspendedState=$suspendedState")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (maxCapacity ?: 0)
        result = 31 * result + (minCapacity ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (scalableDimension?.hashCode() ?: 0)
        result = 31 * result + (scalableTargetArn?.hashCode() ?: 0)
        result = 31 * result + (serviceNamespace?.hashCode() ?: 0)
        result = 31 * result + (suspendedState?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ScalableTarget

        if (creationTime != other.creationTime) return false
        if (maxCapacity != other.maxCapacity) return false
        if (minCapacity != other.minCapacity) return false
        if (resourceId != other.resourceId) return false
        if (roleArn != other.roleArn) return false
        if (scalableDimension != other.scalableDimension) return false
        if (scalableTargetArn != other.scalableTargetArn) return false
        if (serviceNamespace != other.serviceNamespace) return false
        if (suspendedState != other.suspendedState) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.applicationautoscaling.model.ScalableTarget = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Unix timestamp for when the scalable target was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The maximum value to scale to in response to a scale-out activity.
         */
        public var maxCapacity: kotlin.Int? = null
        /**
         * The minimum value to scale to in response to a scale-in activity.
         */
        public var minCapacity: kotlin.Int? = null
        /**
         * The identifier of the resource associated with the scalable target. This string consists of the resource type and unique identifier.
         * + ECS service - The resource type is `service` and the unique identifier is the cluster name and service name. Example: `service/default/sample-webapp`.
         * + Spot Fleet - The resource type is `spot-fleet-request` and the unique identifier is the Spot Fleet request ID. Example: `spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE`.
         * + EMR cluster - The resource type is `instancegroup` and the unique identifier is the cluster ID and instance group ID. Example: `instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0`.
         * + AppStream 2.0 fleet - The resource type is `fleet` and the unique identifier is the fleet name. Example: `fleet/sample-fleet`.
         * + DynamoDB table - The resource type is `table` and the unique identifier is the table name. Example: `table/my-table`.
         * + DynamoDB global secondary index - The resource type is `index` and the unique identifier is the index name. Example: `table/my-table/index/my-table-index`.
         * + Aurora DB cluster - The resource type is `cluster` and the unique identifier is the cluster name. Example: `cluster:my-db-cluster`.
         * + SageMaker endpoint variant - The resource type is `variant` and the unique identifier is the resource ID. Example: `endpoint/my-end-point/variant/KMeansClustering`.
         * + Custom resources are not supported with a resource type. This parameter must specify the `OutputValue` from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information is available in our [GitHub repository](https://github.com/aws/aws-auto-scaling-custom-resource).
         * + Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: `arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE`.
         * + Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: `arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE`.
         * + Lambda provisioned concurrency - The resource type is `function` and the unique identifier is the function name with a function version or alias name suffix that is not `$LATEST`. Example: `function:my-function:prod` or `function:my-function:1`.
         * + Amazon Keyspaces table - The resource type is `table` and the unique identifier is the table name. Example: `keyspace/mykeyspace/table/mytable`.
         * + Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN. Example: `arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5`.
         * + Amazon ElastiCache replication group - The resource type is `replication-group` and the unique identifier is the replication group name. Example: `replication-group/mycluster`.
         * + Neptune cluster - The resource type is `cluster` and the unique identifier is the cluster name. Example: `cluster:mycluster`.
         * + SageMaker Serverless endpoint - The resource type is `variant` and the unique identifier is the resource ID. Example: `endpoint/my-end-point/variant/KMeansClustering`.
         */
        public var resourceId: kotlin.String? = null
        /**
         * The ARN of an IAM role that allows Application Auto Scaling to modify the scalable target on your behalf.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The scalable dimension associated with the scalable target. This string consists of the service namespace, resource type, and scaling property.
         * + `ecs:service:DesiredCount` - The desired task count of an ECS service.
         * + `elasticmapreduce:instancegroup:InstanceCount` - The instance count of an EMR Instance Group.
         * + `ec2:spot-fleet-request:TargetCapacity` - The target capacity of a Spot Fleet.
         * + `appstream:fleet:DesiredCapacity` - The desired capacity of an AppStream 2.0 fleet.
         * + `dynamodb:table:ReadCapacityUnits` - The provisioned read capacity for a DynamoDB table.
         * + `dynamodb:table:WriteCapacityUnits` - The provisioned write capacity for a DynamoDB table.
         * + `dynamodb:index:ReadCapacityUnits` - The provisioned read capacity for a DynamoDB global secondary index.
         * + `dynamodb:index:WriteCapacityUnits` - The provisioned write capacity for a DynamoDB global secondary index.
         * + `rds:cluster:ReadReplicaCount` - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
         * + `sagemaker:variant:DesiredInstanceCount` - The number of EC2 instances for a SageMaker model endpoint variant.
         * + `custom-resource:ResourceType:Property` - The scalable dimension for a custom resource provided by your own application or service.
         * + `comprehend:document-classifier-endpoint:DesiredInferenceUnits` - The number of inference units for an Amazon Comprehend document classification endpoint.
         * + `comprehend:entity-recognizer-endpoint:DesiredInferenceUnits` - The number of inference units for an Amazon Comprehend entity recognizer endpoint.
         * + `lambda:function:ProvisionedConcurrency` - The provisioned concurrency for a Lambda function.
         * + `cassandra:table:ReadCapacityUnits` - The provisioned read capacity for an Amazon Keyspaces table.
         * + `cassandra:table:WriteCapacityUnits` - The provisioned write capacity for an Amazon Keyspaces table.
         * + `kafka:broker-storage:VolumeSize` - The provisioned volume size (in GiB) for brokers in an Amazon MSK cluster.
         * + `elasticache:replication-group:NodeGroups` - The number of node groups for an Amazon ElastiCache replication group.
         * + `elasticache:replication-group:Replicas` - The number of replicas per node group for an Amazon ElastiCache replication group.
         * + `neptune:cluster:ReadReplicaCount` - The count of read replicas in an Amazon Neptune DB cluster.
         * + `sagemaker:variant:DesiredProvisionedConcurrency` - The provisioned concurrency for a SageMaker Serverless endpoint.
         */
        public var scalableDimension: aws.sdk.kotlin.services.applicationautoscaling.model.ScalableDimension? = null
        /**
         * The ARN of the scalable target.
         */
        public var scalableTargetArn: kotlin.String? = null
        /**
         * The namespace of the Amazon Web Services service that provides the resource, or a `custom-resource`.
         */
        public var serviceNamespace: aws.sdk.kotlin.services.applicationautoscaling.model.ServiceNamespace? = null
        /**
         * Specifies whether the scaling activities for a scalable target are in a suspended state.
         */
        public var suspendedState: aws.sdk.kotlin.services.applicationautoscaling.model.SuspendedState? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.applicationautoscaling.model.ScalableTarget) : this() {
            this.creationTime = x.creationTime
            this.maxCapacity = x.maxCapacity
            this.minCapacity = x.minCapacity
            this.resourceId = x.resourceId
            this.roleArn = x.roleArn
            this.scalableDimension = x.scalableDimension
            this.scalableTargetArn = x.scalableTargetArn
            this.serviceNamespace = x.serviceNamespace
            this.suspendedState = x.suspendedState
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.applicationautoscaling.model.ScalableTarget = ScalableTarget(this)

        /**
         * construct an [aws.sdk.kotlin.services.applicationautoscaling.model.SuspendedState] inside the given [block]
         */
        public fun suspendedState(block: aws.sdk.kotlin.services.applicationautoscaling.model.SuspendedState.Builder.() -> kotlin.Unit) {
            this.suspendedState = aws.sdk.kotlin.services.applicationautoscaling.model.SuspendedState.invoke(block)
        }
    }
}
