// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationautoscaling.model



/**
 * Represents a step scaling policy configuration to use with Application Auto Scaling.
 *
 * For more information, see [Step scaling policies](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html) in the *Application Auto Scaling User Guide*.
 */
public class StepScalingPolicyConfiguration private constructor(builder: Builder) {
    /**
     * Specifies how the `ScalingAdjustment` value in a [StepAdjustment](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_StepAdjustment.html) is interpreted (for example, an absolute number or a percentage). The valid values are `ChangeInCapacity`, `ExactCapacity`, and `PercentChangeInCapacity`.
     *
     * `AdjustmentType` is required if you are adding a new step scaling policy configuration.
     */
    public val adjustmentType: aws.sdk.kotlin.services.applicationautoscaling.model.AdjustmentType? = builder.adjustmentType
    /**
     * The amount of time, in seconds, to wait for a previous scaling activity to take effect. If not specified, the default value is 300. For more information, see [Cooldown period](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html#step-scaling-cooldown) in the *Application Auto Scaling User Guide*.
     */
    public val cooldown: kotlin.Int? = builder.cooldown
    /**
     * The aggregation type for the CloudWatch metrics. Valid values are `Minimum`, `Maximum`, and `Average`. If the aggregation type is null, the value is treated as `Average`.
     */
    public val metricAggregationType: aws.sdk.kotlin.services.applicationautoscaling.model.MetricAggregationType? = builder.metricAggregationType
    /**
     * The minimum value to scale by when the adjustment type is `PercentChangeInCapacity`. For example, suppose that you create a step scaling policy to scale out an Amazon ECS service by 25 percent and you specify a `MinAdjustmentMagnitude` of 2. If the service has 4 tasks and the scaling policy is performed, 25 percent of 4 is 1. However, because you specified a `MinAdjustmentMagnitude` of 2, Application Auto Scaling scales out the service by 2 tasks.
     */
    public val minAdjustmentMagnitude: kotlin.Int? = builder.minAdjustmentMagnitude
    /**
     * A set of adjustments that enable you to scale based on the size of the alarm breach.
     *
     * At least one step adjustment is required if you are adding a new step scaling policy configuration.
     */
    public val stepAdjustments: List<StepAdjustment>? = builder.stepAdjustments

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.applicationautoscaling.model.StepScalingPolicyConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StepScalingPolicyConfiguration(")
        append("adjustmentType=$adjustmentType,")
        append("cooldown=$cooldown,")
        append("metricAggregationType=$metricAggregationType,")
        append("minAdjustmentMagnitude=$minAdjustmentMagnitude,")
        append("stepAdjustments=$stepAdjustments")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = adjustmentType?.hashCode() ?: 0
        result = 31 * result + (cooldown ?: 0)
        result = 31 * result + (metricAggregationType?.hashCode() ?: 0)
        result = 31 * result + (minAdjustmentMagnitude ?: 0)
        result = 31 * result + (stepAdjustments?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StepScalingPolicyConfiguration

        if (adjustmentType != other.adjustmentType) return false
        if (cooldown != other.cooldown) return false
        if (metricAggregationType != other.metricAggregationType) return false
        if (minAdjustmentMagnitude != other.minAdjustmentMagnitude) return false
        if (stepAdjustments != other.stepAdjustments) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.applicationautoscaling.model.StepScalingPolicyConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies how the `ScalingAdjustment` value in a [StepAdjustment](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_StepAdjustment.html) is interpreted (for example, an absolute number or a percentage). The valid values are `ChangeInCapacity`, `ExactCapacity`, and `PercentChangeInCapacity`.
         *
         * `AdjustmentType` is required if you are adding a new step scaling policy configuration.
         */
        public var adjustmentType: aws.sdk.kotlin.services.applicationautoscaling.model.AdjustmentType? = null
        /**
         * The amount of time, in seconds, to wait for a previous scaling activity to take effect. If not specified, the default value is 300. For more information, see [Cooldown period](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html#step-scaling-cooldown) in the *Application Auto Scaling User Guide*.
         */
        public var cooldown: kotlin.Int? = null
        /**
         * The aggregation type for the CloudWatch metrics. Valid values are `Minimum`, `Maximum`, and `Average`. If the aggregation type is null, the value is treated as `Average`.
         */
        public var metricAggregationType: aws.sdk.kotlin.services.applicationautoscaling.model.MetricAggregationType? = null
        /**
         * The minimum value to scale by when the adjustment type is `PercentChangeInCapacity`. For example, suppose that you create a step scaling policy to scale out an Amazon ECS service by 25 percent and you specify a `MinAdjustmentMagnitude` of 2. If the service has 4 tasks and the scaling policy is performed, 25 percent of 4 is 1. However, because you specified a `MinAdjustmentMagnitude` of 2, Application Auto Scaling scales out the service by 2 tasks.
         */
        public var minAdjustmentMagnitude: kotlin.Int? = null
        /**
         * A set of adjustments that enable you to scale based on the size of the alarm breach.
         *
         * At least one step adjustment is required if you are adding a new step scaling policy configuration.
         */
        public var stepAdjustments: List<StepAdjustment>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.applicationautoscaling.model.StepScalingPolicyConfiguration) : this() {
            this.adjustmentType = x.adjustmentType
            this.cooldown = x.cooldown
            this.metricAggregationType = x.metricAggregationType
            this.minAdjustmentMagnitude = x.minAdjustmentMagnitude
            this.stepAdjustments = x.stepAdjustments
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.applicationautoscaling.model.StepScalingPolicyConfiguration = StepScalingPolicyConfiguration(this)
    }
}
