// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationautoscaling.model



class RegisterScalableTargetRequest private constructor(builder: BuilderImpl) {
    /**
     * The maximum value that you plan to scale out to. When a scaling policy is in effect,
     * Application Auto Scaling can scale out (expand) as needed to the maximum capacity limit in response to
     * changing demand. This property is required when registering a new scalable target.
     * Although you can specify a large maximum capacity, note that service quotas may impose
     * lower limits. Each service has its own default quotas for the maximum capacity of the
     * resource. If you want to specify a higher limit, you can request an increase. For more
     * information, consult the documentation for that service. For information about the default
     * quotas for each service, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-service-information.html">Service Endpoints and
     * Quotas in the Amazon Web Services General Reference.
     */
    val maxCapacity: Int? = builder.maxCapacity
    /**
     * The minimum value that you plan to scale in to. When a scaling policy is in effect,
     * Application Auto Scaling can scale in (contract) as needed to the minimum capacity limit in response to
     * changing demand. This property is required when registering a new scalable target.
     * For certain resources, the minimum value allowed is 0. This includes Lambda provisioned
     * concurrency, Spot Fleet, ECS services, Aurora DB clusters, EMR clusters, and custom resources.
     * For all other resources, the minimum value allowed is 1.
     */
    val minCapacity: Int? = builder.minCapacity
    /**
     * The identifier of the resource that is associated with the scalable target.
     * This string consists of the resource type and unique identifier.
     * ECS service - The resource type is service and the unique identifier is the cluster name
     * and service name. Example: service/default/sample-webapp.
     * Spot Fleet - The resource type is spot-fleet-request and the unique identifier is the
     * Spot Fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
     * EMR cluster - The resource type is instancegroup and the unique identifier is the cluster ID and instance group ID.
     * Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.
     * AppStream 2.0 fleet - The resource type is fleet and the unique identifier is the fleet name.
     * Example: fleet/sample-fleet.
     * DynamoDB table - The resource type is table and the unique identifier is the table name.
     * Example: table/my-table.
     * DynamoDB global secondary index - The resource type is index and the unique identifier is the index name.
     * Example: table/my-table/index/my-table-index.
     * Aurora DB cluster - The resource type is cluster and the unique identifier is the cluster name.
     * Example: cluster:my-db-cluster.
     * SageMaker endpoint variant - The resource type is variant and the unique identifier is the resource ID.
     * Example: endpoint/my-end-point/variant/KMeansClustering.
     * Custom resources are not supported with a resource type. This parameter must specify the OutputValue from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information
     * is available in our <a href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub
     * repository.
     * Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE.
     * Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE.
     * Lambda provisioned concurrency - The resource type is function and the unique identifier is the function name with a function version or alias name suffix that is not $LATEST.
     * Example: function:my-function:prod or function:my-function:1.
     * Amazon Keyspaces table - The resource type is table and the unique identifier is the table name.
     * Example: keyspace/mykeyspace/table/mytable.
     * Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN.
     * Example: arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5.
     * Amazon ElastiCache replication group - The resource type is replication-group and the unique identifier is the replication group name.
     * Example: replication-group/mycluster.
     * Neptune cluster - The resource type is cluster and the unique identifier is the cluster name. Example: cluster:mycluster.
     */
    val resourceId: String? = builder.resourceId
    /**
     * This parameter is required for services that do not support service-linked roles (such as
     * Amazon EMR), and it must specify the ARN of an IAM role that allows Application Auto Scaling to modify the scalable
     * target on your behalf.
     * If the service supports service-linked roles, Application Auto Scaling uses a service-linked role, which
     * it creates if it does not yet exist. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/security_iam_service-with-iam.html#security_iam_service-with-iam-roles">Application Auto Scaling IAM roles.
     */
    val roleArn: String? = builder.roleArn
    /**
     * The scalable dimension associated with the scalable target.
     * This string consists of the service namespace, resource type, and scaling property.
     * ecs:service:DesiredCount - The desired task count of an ECS service.
     * elasticmapreduce:instancegroup:InstanceCount - The instance count of an EMR Instance Group.
     * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot Fleet.
     * appstream:fleet:DesiredCapacity - The desired capacity of an AppStream 2.0 fleet.
     * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for a DynamoDB table.
     * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for a DynamoDB table.
     * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for a DynamoDB global secondary index.
     * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for a DynamoDB global secondary index.
     * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
     * sagemaker:variant:DesiredInstanceCount - The number of EC2 instances for an SageMaker model endpoint variant.
     * custom-resource:ResourceType:Property - The scalable dimension for a custom resource provided by your own application or service.
     * comprehend:document-classifier-endpoint:DesiredInferenceUnits - The number of inference units for an Amazon Comprehend document classification endpoint.
     * comprehend:entity-recognizer-endpoint:DesiredInferenceUnits - The number of inference units for an Amazon Comprehend entity recognizer endpoint.
     * lambda:function:ProvisionedConcurrency - The provisioned concurrency for a Lambda function.
     * cassandra:table:ReadCapacityUnits - The provisioned read capacity for an Amazon Keyspaces table.
     * cassandra:table:WriteCapacityUnits - The provisioned write capacity for an Amazon Keyspaces table.
     * kafka:broker-storage:VolumeSize - The provisioned volume size (in GiB) for brokers in an Amazon MSK cluster.
     * elasticache:replication-group:NodeGroups - The number of node groups for an Amazon ElastiCache replication group.
     * elasticache:replication-group:Replicas - The number of replicas per node group for an Amazon ElastiCache replication group.
     * neptune:cluster:ReadReplicaCount - The count of read replicas in an Amazon Neptune DB cluster.
     */
    val scalableDimension: ScalableDimension? = builder.scalableDimension
    /**
     * The namespace of the Amazon Web Services service that provides the resource. For a resource provided
     * by your own application or service, use custom-resource instead.
     */
    val serviceNamespace: ServiceNamespace? = builder.serviceNamespace
    /**
     * An embedded object that contains attributes and attribute values that are used to
     * suspend and resume automatic scaling. Setting the value of an attribute to
     * true suspends the specified scaling activities. Setting it to
     * false (default) resumes the specified scaling activities.
     * Suspension Outcomes
     * For DynamicScalingInSuspended, while a suspension is in effect, all
     * scale-in activities that are triggered by a scaling policy are suspended.
     * For DynamicScalingOutSuspended, while a suspension is in effect, all
     * scale-out activities that are triggered by a scaling policy are suspended.
     * For ScheduledScalingSuspended, while a suspension is in effect, all
     * scaling activities that involve scheduled actions are suspended.
     * For more information, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-suspend-resume-scaling.html">Suspending and resuming scaling in the Application Auto Scaling User
     * Guide.
     */
    val suspendedState: SuspendedState? = builder.suspendedState

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): RegisterScalableTargetRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("RegisterScalableTargetRequest(")
        append("maxCapacity=$maxCapacity,")
        append("minCapacity=$minCapacity,")
        append("resourceId=$resourceId,")
        append("roleArn=$roleArn,")
        append("scalableDimension=$scalableDimension,")
        append("serviceNamespace=$serviceNamespace,")
        append("suspendedState=$suspendedState)")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxCapacity ?: 0
        result = 31 * result + (minCapacity ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (scalableDimension?.hashCode() ?: 0)
        result = 31 * result + (serviceNamespace?.hashCode() ?: 0)
        result = 31 * result + (suspendedState?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as RegisterScalableTargetRequest

        if (maxCapacity != other.maxCapacity) return false
        if (minCapacity != other.minCapacity) return false
        if (resourceId != other.resourceId) return false
        if (roleArn != other.roleArn) return false
        if (scalableDimension != other.scalableDimension) return false
        if (serviceNamespace != other.serviceNamespace) return false
        if (suspendedState != other.suspendedState) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): RegisterScalableTargetRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): RegisterScalableTargetRequest
        /**
         * The maximum value that you plan to scale out to. When a scaling policy is in effect,
         * Application Auto Scaling can scale out (expand) as needed to the maximum capacity limit in response to
         * changing demand. This property is required when registering a new scalable target.
         * Although you can specify a large maximum capacity, note that service quotas may impose
         * lower limits. Each service has its own default quotas for the maximum capacity of the
         * resource. If you want to specify a higher limit, you can request an increase. For more
         * information, consult the documentation for that service. For information about the default
         * quotas for each service, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-service-information.html">Service Endpoints and
         * Quotas in the Amazon Web Services General Reference.
         */
        fun maxCapacity(maxCapacity: Int): FluentBuilder
        /**
         * The minimum value that you plan to scale in to. When a scaling policy is in effect,
         * Application Auto Scaling can scale in (contract) as needed to the minimum capacity limit in response to
         * changing demand. This property is required when registering a new scalable target.
         * For certain resources, the minimum value allowed is 0. This includes Lambda provisioned
         * concurrency, Spot Fleet, ECS services, Aurora DB clusters, EMR clusters, and custom resources.
         * For all other resources, the minimum value allowed is 1.
         */
        fun minCapacity(minCapacity: Int): FluentBuilder
        /**
         * The identifier of the resource that is associated with the scalable target.
         * This string consists of the resource type and unique identifier.
         * ECS service - The resource type is service and the unique identifier is the cluster name
         * and service name. Example: service/default/sample-webapp.
         * Spot Fleet - The resource type is spot-fleet-request and the unique identifier is the
         * Spot Fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
         * EMR cluster - The resource type is instancegroup and the unique identifier is the cluster ID and instance group ID.
         * Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.
         * AppStream 2.0 fleet - The resource type is fleet and the unique identifier is the fleet name.
         * Example: fleet/sample-fleet.
         * DynamoDB table - The resource type is table and the unique identifier is the table name.
         * Example: table/my-table.
         * DynamoDB global secondary index - The resource type is index and the unique identifier is the index name.
         * Example: table/my-table/index/my-table-index.
         * Aurora DB cluster - The resource type is cluster and the unique identifier is the cluster name.
         * Example: cluster:my-db-cluster.
         * SageMaker endpoint variant - The resource type is variant and the unique identifier is the resource ID.
         * Example: endpoint/my-end-point/variant/KMeansClustering.
         * Custom resources are not supported with a resource type. This parameter must specify the OutputValue from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information
         * is available in our <a href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub
         * repository.
         * Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE.
         * Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE.
         * Lambda provisioned concurrency - The resource type is function and the unique identifier is the function name with a function version or alias name suffix that is not $LATEST.
         * Example: function:my-function:prod or function:my-function:1.
         * Amazon Keyspaces table - The resource type is table and the unique identifier is the table name.
         * Example: keyspace/mykeyspace/table/mytable.
         * Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN.
         * Example: arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5.
         * Amazon ElastiCache replication group - The resource type is replication-group and the unique identifier is the replication group name.
         * Example: replication-group/mycluster.
         * Neptune cluster - The resource type is cluster and the unique identifier is the cluster name. Example: cluster:mycluster.
         */
        fun resourceId(resourceId: String): FluentBuilder
        /**
         * This parameter is required for services that do not support service-linked roles (such as
         * Amazon EMR), and it must specify the ARN of an IAM role that allows Application Auto Scaling to modify the scalable
         * target on your behalf.
         * If the service supports service-linked roles, Application Auto Scaling uses a service-linked role, which
         * it creates if it does not yet exist. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/security_iam_service-with-iam.html#security_iam_service-with-iam-roles">Application Auto Scaling IAM roles.
         */
        fun roleArn(roleArn: String): FluentBuilder
        /**
         * The scalable dimension associated with the scalable target.
         * This string consists of the service namespace, resource type, and scaling property.
         * ecs:service:DesiredCount - The desired task count of an ECS service.
         * elasticmapreduce:instancegroup:InstanceCount - The instance count of an EMR Instance Group.
         * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot Fleet.
         * appstream:fleet:DesiredCapacity - The desired capacity of an AppStream 2.0 fleet.
         * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for a DynamoDB table.
         * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for a DynamoDB table.
         * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for a DynamoDB global secondary index.
         * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for a DynamoDB global secondary index.
         * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
         * sagemaker:variant:DesiredInstanceCount - The number of EC2 instances for an SageMaker model endpoint variant.
         * custom-resource:ResourceType:Property - The scalable dimension for a custom resource provided by your own application or service.
         * comprehend:document-classifier-endpoint:DesiredInferenceUnits - The number of inference units for an Amazon Comprehend document classification endpoint.
         * comprehend:entity-recognizer-endpoint:DesiredInferenceUnits - The number of inference units for an Amazon Comprehend entity recognizer endpoint.
         * lambda:function:ProvisionedConcurrency - The provisioned concurrency for a Lambda function.
         * cassandra:table:ReadCapacityUnits - The provisioned read capacity for an Amazon Keyspaces table.
         * cassandra:table:WriteCapacityUnits - The provisioned write capacity for an Amazon Keyspaces table.
         * kafka:broker-storage:VolumeSize - The provisioned volume size (in GiB) for brokers in an Amazon MSK cluster.
         * elasticache:replication-group:NodeGroups - The number of node groups for an Amazon ElastiCache replication group.
         * elasticache:replication-group:Replicas - The number of replicas per node group for an Amazon ElastiCache replication group.
         * neptune:cluster:ReadReplicaCount - The count of read replicas in an Amazon Neptune DB cluster.
         */
        fun scalableDimension(scalableDimension: ScalableDimension): FluentBuilder
        /**
         * The namespace of the Amazon Web Services service that provides the resource. For a resource provided
         * by your own application or service, use custom-resource instead.
         */
        fun serviceNamespace(serviceNamespace: ServiceNamespace): FluentBuilder
        /**
         * An embedded object that contains attributes and attribute values that are used to
         * suspend and resume automatic scaling. Setting the value of an attribute to
         * true suspends the specified scaling activities. Setting it to
         * false (default) resumes the specified scaling activities.
         * Suspension Outcomes
         * For DynamicScalingInSuspended, while a suspension is in effect, all
         * scale-in activities that are triggered by a scaling policy are suspended.
         * For DynamicScalingOutSuspended, while a suspension is in effect, all
         * scale-out activities that are triggered by a scaling policy are suspended.
         * For ScheduledScalingSuspended, while a suspension is in effect, all
         * scaling activities that involve scheduled actions are suspended.
         * For more information, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-suspend-resume-scaling.html">Suspending and resuming scaling in the Application Auto Scaling User
         * Guide.
         */
        fun suspendedState(suspendedState: SuspendedState): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The maximum value that you plan to scale out to. When a scaling policy is in effect,
         * Application Auto Scaling can scale out (expand) as needed to the maximum capacity limit in response to
         * changing demand. This property is required when registering a new scalable target.
         * Although you can specify a large maximum capacity, note that service quotas may impose
         * lower limits. Each service has its own default quotas for the maximum capacity of the
         * resource. If you want to specify a higher limit, you can request an increase. For more
         * information, consult the documentation for that service. For information about the default
         * quotas for each service, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-service-information.html">Service Endpoints and
         * Quotas in the Amazon Web Services General Reference.
         */
        var maxCapacity: Int?
        /**
         * The minimum value that you plan to scale in to. When a scaling policy is in effect,
         * Application Auto Scaling can scale in (contract) as needed to the minimum capacity limit in response to
         * changing demand. This property is required when registering a new scalable target.
         * For certain resources, the minimum value allowed is 0. This includes Lambda provisioned
         * concurrency, Spot Fleet, ECS services, Aurora DB clusters, EMR clusters, and custom resources.
         * For all other resources, the minimum value allowed is 1.
         */
        var minCapacity: Int?
        /**
         * The identifier of the resource that is associated with the scalable target.
         * This string consists of the resource type and unique identifier.
         * ECS service - The resource type is service and the unique identifier is the cluster name
         * and service name. Example: service/default/sample-webapp.
         * Spot Fleet - The resource type is spot-fleet-request and the unique identifier is the
         * Spot Fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
         * EMR cluster - The resource type is instancegroup and the unique identifier is the cluster ID and instance group ID.
         * Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.
         * AppStream 2.0 fleet - The resource type is fleet and the unique identifier is the fleet name.
         * Example: fleet/sample-fleet.
         * DynamoDB table - The resource type is table and the unique identifier is the table name.
         * Example: table/my-table.
         * DynamoDB global secondary index - The resource type is index and the unique identifier is the index name.
         * Example: table/my-table/index/my-table-index.
         * Aurora DB cluster - The resource type is cluster and the unique identifier is the cluster name.
         * Example: cluster:my-db-cluster.
         * SageMaker endpoint variant - The resource type is variant and the unique identifier is the resource ID.
         * Example: endpoint/my-end-point/variant/KMeansClustering.
         * Custom resources are not supported with a resource type. This parameter must specify the OutputValue from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information
         * is available in our <a href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub
         * repository.
         * Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE.
         * Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE.
         * Lambda provisioned concurrency - The resource type is function and the unique identifier is the function name with a function version or alias name suffix that is not $LATEST.
         * Example: function:my-function:prod or function:my-function:1.
         * Amazon Keyspaces table - The resource type is table and the unique identifier is the table name.
         * Example: keyspace/mykeyspace/table/mytable.
         * Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN.
         * Example: arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5.
         * Amazon ElastiCache replication group - The resource type is replication-group and the unique identifier is the replication group name.
         * Example: replication-group/mycluster.
         * Neptune cluster - The resource type is cluster and the unique identifier is the cluster name. Example: cluster:mycluster.
         */
        var resourceId: String?
        /**
         * This parameter is required for services that do not support service-linked roles (such as
         * Amazon EMR), and it must specify the ARN of an IAM role that allows Application Auto Scaling to modify the scalable
         * target on your behalf.
         * If the service supports service-linked roles, Application Auto Scaling uses a service-linked role, which
         * it creates if it does not yet exist. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/security_iam_service-with-iam.html#security_iam_service-with-iam-roles">Application Auto Scaling IAM roles.
         */
        var roleArn: String?
        /**
         * The scalable dimension associated with the scalable target.
         * This string consists of the service namespace, resource type, and scaling property.
         * ecs:service:DesiredCount - The desired task count of an ECS service.
         * elasticmapreduce:instancegroup:InstanceCount - The instance count of an EMR Instance Group.
         * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot Fleet.
         * appstream:fleet:DesiredCapacity - The desired capacity of an AppStream 2.0 fleet.
         * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for a DynamoDB table.
         * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for a DynamoDB table.
         * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for a DynamoDB global secondary index.
         * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for a DynamoDB global secondary index.
         * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
         * sagemaker:variant:DesiredInstanceCount - The number of EC2 instances for an SageMaker model endpoint variant.
         * custom-resource:ResourceType:Property - The scalable dimension for a custom resource provided by your own application or service.
         * comprehend:document-classifier-endpoint:DesiredInferenceUnits - The number of inference units for an Amazon Comprehend document classification endpoint.
         * comprehend:entity-recognizer-endpoint:DesiredInferenceUnits - The number of inference units for an Amazon Comprehend entity recognizer endpoint.
         * lambda:function:ProvisionedConcurrency - The provisioned concurrency for a Lambda function.
         * cassandra:table:ReadCapacityUnits - The provisioned read capacity for an Amazon Keyspaces table.
         * cassandra:table:WriteCapacityUnits - The provisioned write capacity for an Amazon Keyspaces table.
         * kafka:broker-storage:VolumeSize - The provisioned volume size (in GiB) for brokers in an Amazon MSK cluster.
         * elasticache:replication-group:NodeGroups - The number of node groups for an Amazon ElastiCache replication group.
         * elasticache:replication-group:Replicas - The number of replicas per node group for an Amazon ElastiCache replication group.
         * neptune:cluster:ReadReplicaCount - The count of read replicas in an Amazon Neptune DB cluster.
         */
        var scalableDimension: ScalableDimension?
        /**
         * The namespace of the Amazon Web Services service that provides the resource. For a resource provided
         * by your own application or service, use custom-resource instead.
         */
        var serviceNamespace: ServiceNamespace?
        /**
         * An embedded object that contains attributes and attribute values that are used to
         * suspend and resume automatic scaling. Setting the value of an attribute to
         * true suspends the specified scaling activities. Setting it to
         * false (default) resumes the specified scaling activities.
         * Suspension Outcomes
         * For DynamicScalingInSuspended, while a suspension is in effect, all
         * scale-in activities that are triggered by a scaling policy are suspended.
         * For DynamicScalingOutSuspended, while a suspension is in effect, all
         * scale-out activities that are triggered by a scaling policy are suspended.
         * For ScheduledScalingSuspended, while a suspension is in effect, all
         * scaling activities that involve scheduled actions are suspended.
         * For more information, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-suspend-resume-scaling.html">Suspending and resuming scaling in the Application Auto Scaling User
         * Guide.
         */
        var suspendedState: SuspendedState?

        fun build(): RegisterScalableTargetRequest
        /**
         * construct an [aws.sdk.kotlin.services.applicationautoscaling.model.SuspendedState] inside the given [block]
         */
        fun suspendedState(block: SuspendedState.DslBuilder.() -> kotlin.Unit) {
            this.suspendedState = SuspendedState.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var maxCapacity: Int? = null
        override var minCapacity: Int? = null
        override var resourceId: String? = null
        override var roleArn: String? = null
        override var scalableDimension: ScalableDimension? = null
        override var serviceNamespace: ServiceNamespace? = null
        override var suspendedState: SuspendedState? = null

        constructor(x: RegisterScalableTargetRequest) : this() {
            this.maxCapacity = x.maxCapacity
            this.minCapacity = x.minCapacity
            this.resourceId = x.resourceId
            this.roleArn = x.roleArn
            this.scalableDimension = x.scalableDimension
            this.serviceNamespace = x.serviceNamespace
            this.suspendedState = x.suspendedState
        }

        override fun build(): RegisterScalableTargetRequest = RegisterScalableTargetRequest(this)
        override fun maxCapacity(maxCapacity: Int): FluentBuilder = apply { this.maxCapacity = maxCapacity }
        override fun minCapacity(minCapacity: Int): FluentBuilder = apply { this.minCapacity = minCapacity }
        override fun resourceId(resourceId: String): FluentBuilder = apply { this.resourceId = resourceId }
        override fun roleArn(roleArn: String): FluentBuilder = apply { this.roleArn = roleArn }
        override fun scalableDimension(scalableDimension: ScalableDimension): FluentBuilder = apply { this.scalableDimension = scalableDimension }
        override fun serviceNamespace(serviceNamespace: ServiceNamespace): FluentBuilder = apply { this.serviceNamespace = serviceNamespace }
        override fun suspendedState(suspendedState: SuspendedState): FluentBuilder = apply { this.suspendedState = suspendedState }
    }
}
