// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationautoscaling.model



/**
 * Represents the minimum and maximum capacity for a scheduled action.
 */
class ScalableTargetAction private constructor(builder: BuilderImpl) {
    /**
     * The maximum capacity.
     * Although you can specify a large maximum capacity, note that service quotas may impose
     * lower limits. Each service has its own default quotas for the maximum capacity of the
     * resource. If you want to specify a higher limit, you can request an increase. For more
     * information, consult the documentation for that service. For information about the default
     * quotas for each service, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-service-information.html">Service Endpoints and
     * Quotas in the Amazon Web Services General Reference.
     */
    val maxCapacity: Int? = builder.maxCapacity
    /**
     * The minimum capacity.
     * For certain resources, the minimum value allowed is 0. This includes Lambda provisioned
     * concurrency, Spot Fleet, ECS services, Aurora DB clusters, EMR clusters, and custom resources.
     * For all other resources, the minimum value allowed is 1.
     */
    val minCapacity: Int? = builder.minCapacity

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ScalableTargetAction = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ScalableTargetAction(")
        append("maxCapacity=$maxCapacity,")
        append("minCapacity=$minCapacity)")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxCapacity ?: 0
        result = 31 * result + (minCapacity ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ScalableTargetAction

        if (maxCapacity != other.maxCapacity) return false
        if (minCapacity != other.minCapacity) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ScalableTargetAction = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ScalableTargetAction
        /**
         * The maximum capacity.
         * Although you can specify a large maximum capacity, note that service quotas may impose
         * lower limits. Each service has its own default quotas for the maximum capacity of the
         * resource. If you want to specify a higher limit, you can request an increase. For more
         * information, consult the documentation for that service. For information about the default
         * quotas for each service, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-service-information.html">Service Endpoints and
         * Quotas in the Amazon Web Services General Reference.
         */
        fun maxCapacity(maxCapacity: Int): FluentBuilder
        /**
         * The minimum capacity.
         * For certain resources, the minimum value allowed is 0. This includes Lambda provisioned
         * concurrency, Spot Fleet, ECS services, Aurora DB clusters, EMR clusters, and custom resources.
         * For all other resources, the minimum value allowed is 1.
         */
        fun minCapacity(minCapacity: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The maximum capacity.
         * Although you can specify a large maximum capacity, note that service quotas may impose
         * lower limits. Each service has its own default quotas for the maximum capacity of the
         * resource. If you want to specify a higher limit, you can request an increase. For more
         * information, consult the documentation for that service. For information about the default
         * quotas for each service, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-service-information.html">Service Endpoints and
         * Quotas in the Amazon Web Services General Reference.
         */
        var maxCapacity: Int?
        /**
         * The minimum capacity.
         * For certain resources, the minimum value allowed is 0. This includes Lambda provisioned
         * concurrency, Spot Fleet, ECS services, Aurora DB clusters, EMR clusters, and custom resources.
         * For all other resources, the minimum value allowed is 1.
         */
        var minCapacity: Int?

        fun build(): ScalableTargetAction
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var maxCapacity: Int? = null
        override var minCapacity: Int? = null

        constructor(x: ScalableTargetAction) : this() {
            this.maxCapacity = x.maxCapacity
            this.minCapacity = x.minCapacity
        }

        override fun build(): ScalableTargetAction = ScalableTargetAction(this)
        override fun maxCapacity(maxCapacity: Int): FluentBuilder = apply { this.maxCapacity = maxCapacity }
        override fun minCapacity(minCapacity: Int): FluentBuilder = apply { this.minCapacity = minCapacity }
    }
}
