// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationautoscaling.model



/**
 * Specifies whether the scaling activities for a scalable target are in a suspended state.
 */
class SuspendedState private constructor(builder: BuilderImpl) {
    /**
     * Whether scale in by a target tracking scaling policy or a step scaling policy is
     * suspended. Set the value to true if you don't want Application Auto Scaling to remove capacity
     * when a scaling policy is triggered. The default is false.
     */
    val dynamicScalingInSuspended: Boolean? = builder.dynamicScalingInSuspended
    /**
     * Whether scale out by a target tracking scaling policy or a step scaling policy is
     * suspended. Set the value to true if you don't want Application Auto Scaling to add capacity
     * when a scaling policy is triggered. The default is false.
     */
    val dynamicScalingOutSuspended: Boolean? = builder.dynamicScalingOutSuspended
    /**
     * Whether scheduled scaling is suspended. Set the value to true if you don't
     * want Application Auto Scaling to add or remove capacity by initiating scheduled actions. The default is
     * false.
     */
    val scheduledScalingSuspended: Boolean? = builder.scheduledScalingSuspended

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): SuspendedState = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("SuspendedState(")
        append("dynamicScalingInSuspended=$dynamicScalingInSuspended,")
        append("dynamicScalingOutSuspended=$dynamicScalingOutSuspended,")
        append("scheduledScalingSuspended=$scheduledScalingSuspended)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dynamicScalingInSuspended?.hashCode() ?: 0
        result = 31 * result + (dynamicScalingOutSuspended?.hashCode() ?: 0)
        result = 31 * result + (scheduledScalingSuspended?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as SuspendedState

        if (dynamicScalingInSuspended != other.dynamicScalingInSuspended) return false
        if (dynamicScalingOutSuspended != other.dynamicScalingOutSuspended) return false
        if (scheduledScalingSuspended != other.scheduledScalingSuspended) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): SuspendedState = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): SuspendedState
        /**
         * Whether scale in by a target tracking scaling policy or a step scaling policy is
         * suspended. Set the value to true if you don't want Application Auto Scaling to remove capacity
         * when a scaling policy is triggered. The default is false.
         */
        fun dynamicScalingInSuspended(dynamicScalingInSuspended: Boolean): FluentBuilder
        /**
         * Whether scale out by a target tracking scaling policy or a step scaling policy is
         * suspended. Set the value to true if you don't want Application Auto Scaling to add capacity
         * when a scaling policy is triggered. The default is false.
         */
        fun dynamicScalingOutSuspended(dynamicScalingOutSuspended: Boolean): FluentBuilder
        /**
         * Whether scheduled scaling is suspended. Set the value to true if you don't
         * want Application Auto Scaling to add or remove capacity by initiating scheduled actions. The default is
         * false.
         */
        fun scheduledScalingSuspended(scheduledScalingSuspended: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Whether scale in by a target tracking scaling policy or a step scaling policy is
         * suspended. Set the value to true if you don't want Application Auto Scaling to remove capacity
         * when a scaling policy is triggered. The default is false.
         */
        var dynamicScalingInSuspended: Boolean?
        /**
         * Whether scale out by a target tracking scaling policy or a step scaling policy is
         * suspended. Set the value to true if you don't want Application Auto Scaling to add capacity
         * when a scaling policy is triggered. The default is false.
         */
        var dynamicScalingOutSuspended: Boolean?
        /**
         * Whether scheduled scaling is suspended. Set the value to true if you don't
         * want Application Auto Scaling to add or remove capacity by initiating scheduled actions. The default is
         * false.
         */
        var scheduledScalingSuspended: Boolean?

        fun build(): SuspendedState
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dynamicScalingInSuspended: Boolean? = null
        override var dynamicScalingOutSuspended: Boolean? = null
        override var scheduledScalingSuspended: Boolean? = null

        constructor(x: SuspendedState) : this() {
            this.dynamicScalingInSuspended = x.dynamicScalingInSuspended
            this.dynamicScalingOutSuspended = x.dynamicScalingOutSuspended
            this.scheduledScalingSuspended = x.scheduledScalingSuspended
        }

        override fun build(): SuspendedState = SuspendedState(this)
        override fun dynamicScalingInSuspended(dynamicScalingInSuspended: Boolean): FluentBuilder = apply { this.dynamicScalingInSuspended = dynamicScalingInSuspended }
        override fun dynamicScalingOutSuspended(dynamicScalingOutSuspended: Boolean): FluentBuilder = apply { this.dynamicScalingOutSuspended = dynamicScalingOutSuspended }
        override fun scheduledScalingSuspended(scheduledScalingSuspended: Boolean): FluentBuilder = apply { this.scheduledScalingSuspended = scheduledScalingSuspended }
    }
}
