// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationautoscaling.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.applicationautoscaling.model.ApplicationAutoScalingException
import aws.sdk.kotlin.services.applicationautoscaling.model.PutScheduledActionResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class PutScheduledActionOperationDeserializer: HttpDeserialize<PutScheduledActionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): PutScheduledActionResponse {
        if (!response.status.isSuccess()) {
            throwPutScheduledActionError(context, response)
        }
        val builder = PutScheduledActionResponse.builder()

        return builder.build()
    }
}

private suspend fun throwPutScheduledActionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsJson1_1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "ConcurrentUpdateException" -> ConcurrentUpdateExceptionDeserializer()
        "InternalServiceException" -> InternalServiceExceptionDeserializer()
        "LimitExceededException" -> LimitExceededExceptionDeserializer()
        "ObjectNotFoundException" -> ObjectNotFoundExceptionDeserializer()
        "ValidationException" -> ValidationExceptionDeserializer()
        else -> throw ApplicationAutoScalingException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
