// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationautoscaling.model



class DescribeScheduledActionsRequest private constructor(builder: BuilderImpl) {
    /**
     * The maximum number of scheduled action results. This value can be between
     * 1 and 50. The default value is 50.
     * If this parameter is used, the operation returns up to MaxResults results
     * at a time, along with a NextToken value. To get the next set of results,
     * include the NextToken value in a subsequent call. If this parameter is not
     * used, the operation returns up to 50 results and a
     * NextToken value, if applicable.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * The token for the next set of results.
     */
    val nextToken: String? = builder.nextToken
    /**
     * The identifier of the resource associated with the scheduled action.
     * This string consists of the resource type and unique identifier.
     * ECS service - The resource type is service and the unique identifier is the cluster name
     * and service name. Example: service/default/sample-webapp.
     * Spot Fleet - The resource type is spot-fleet-request and the unique identifier is the
     * Spot Fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
     * EMR cluster - The resource type is instancegroup and the unique identifier is the cluster ID and instance group ID.
     * Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.
     * AppStream 2.0 fleet - The resource type is fleet and the unique identifier is the fleet name.
     * Example: fleet/sample-fleet.
     * DynamoDB table - The resource type is table and the unique identifier is the table name.
     * Example: table/my-table.
     * DynamoDB global secondary index - The resource type is index and the unique identifier is the index name.
     * Example: table/my-table/index/my-table-index.
     * Aurora DB cluster - The resource type is cluster and the unique identifier is the cluster name.
     * Example: cluster:my-db-cluster.
     * SageMaker endpoint variant - The resource type is variant and the unique identifier is the resource ID.
     * Example: endpoint/my-end-point/variant/KMeansClustering.
     * Custom resources are not supported with a resource type. This parameter must specify the OutputValue from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information
     * is available in our <a href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub
     * repository.
     * Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE.
     * Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE.
     * Lambda provisioned concurrency - The resource type is function and the unique identifier is the function name with a function version or alias name suffix that is not $LATEST.
     * Example: function:my-function:prod or function:my-function:1.
     * Amazon Keyspaces table - The resource type is table and the unique identifier is the table name.
     * Example: keyspace/mykeyspace/table/mytable.
     * Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN.
     * Example: arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5.
     * Amazon ElastiCache replication group - The resource type is replication-group and the unique identifier is the replication group name.
     * Example: replication-group/mycluster.
     * Neptune cluster - The resource type is cluster and the unique identifier is the cluster name. Example: cluster:mycluster.
     */
    val resourceId: String? = builder.resourceId
    /**
     * The scalable dimension. This string consists of the service namespace, resource type, and scaling property.
     * If you specify a scalable dimension, you must also specify a resource ID.
     * ecs:service:DesiredCount - The desired task count of an ECS service.
     * elasticmapreduce:instancegroup:InstanceCount - The instance count of an EMR Instance Group.
     * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot Fleet.
     * appstream:fleet:DesiredCapacity - The desired capacity of an AppStream 2.0 fleet.
     * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for a DynamoDB table.
     * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for a DynamoDB table.
     * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for a DynamoDB global secondary index.
     * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for a DynamoDB global secondary index.
     * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
     * sagemaker:variant:DesiredInstanceCount - The number of EC2 instances for an SageMaker model endpoint variant.
     * custom-resource:ResourceType:Property - The scalable dimension for a custom resource provided by your own application or service.
     * comprehend:document-classifier-endpoint:DesiredInferenceUnits - The number of inference units for an Amazon Comprehend document classification endpoint.
     * comprehend:entity-recognizer-endpoint:DesiredInferenceUnits - The number of inference units for an Amazon Comprehend entity recognizer endpoint.
     * lambda:function:ProvisionedConcurrency - The provisioned concurrency for a Lambda function.
     * cassandra:table:ReadCapacityUnits - The provisioned read capacity for an Amazon Keyspaces table.
     * cassandra:table:WriteCapacityUnits - The provisioned write capacity for an Amazon Keyspaces table.
     * kafka:broker-storage:VolumeSize - The provisioned volume size (in GiB) for brokers in an Amazon MSK cluster.
     * elasticache:replication-group:NodeGroups - The number of node groups for an Amazon ElastiCache replication group.
     * elasticache:replication-group:Replicas - The number of replicas per node group for an Amazon ElastiCache replication group.
     * neptune:cluster:ReadReplicaCount - The count of read replicas in an Amazon Neptune DB cluster.
     */
    val scalableDimension: ScalableDimension? = builder.scalableDimension
    /**
     * The names of the scheduled actions to describe.
     */
    val scheduledActionNames: List<String>? = builder.scheduledActionNames
    /**
     * The namespace of the Amazon Web Services service that provides the resource. For a resource provided
     * by your own application or service, use custom-resource instead.
     */
    val serviceNamespace: ServiceNamespace? = builder.serviceNamespace

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeScheduledActionsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeScheduledActionsRequest(")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("resourceId=$resourceId,")
        append("scalableDimension=$scalableDimension,")
        append("scheduledActionNames=$scheduledActionNames,")
        append("serviceNamespace=$serviceNamespace)")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxResults ?: 0
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (scalableDimension?.hashCode() ?: 0)
        result = 31 * result + (scheduledActionNames?.hashCode() ?: 0)
        result = 31 * result + (serviceNamespace?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeScheduledActionsRequest

        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (resourceId != other.resourceId) return false
        if (scalableDimension != other.scalableDimension) return false
        if (scheduledActionNames != other.scheduledActionNames) return false
        if (serviceNamespace != other.serviceNamespace) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeScheduledActionsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeScheduledActionsRequest
        /**
         * The maximum number of scheduled action results. This value can be between
         * 1 and 50. The default value is 50.
         * If this parameter is used, the operation returns up to MaxResults results
         * at a time, along with a NextToken value. To get the next set of results,
         * include the NextToken value in a subsequent call. If this parameter is not
         * used, the operation returns up to 50 results and a
         * NextToken value, if applicable.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The token for the next set of results.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * The identifier of the resource associated with the scheduled action.
         * This string consists of the resource type and unique identifier.
         * ECS service - The resource type is service and the unique identifier is the cluster name
         * and service name. Example: service/default/sample-webapp.
         * Spot Fleet - The resource type is spot-fleet-request and the unique identifier is the
         * Spot Fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
         * EMR cluster - The resource type is instancegroup and the unique identifier is the cluster ID and instance group ID.
         * Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.
         * AppStream 2.0 fleet - The resource type is fleet and the unique identifier is the fleet name.
         * Example: fleet/sample-fleet.
         * DynamoDB table - The resource type is table and the unique identifier is the table name.
         * Example: table/my-table.
         * DynamoDB global secondary index - The resource type is index and the unique identifier is the index name.
         * Example: table/my-table/index/my-table-index.
         * Aurora DB cluster - The resource type is cluster and the unique identifier is the cluster name.
         * Example: cluster:my-db-cluster.
         * SageMaker endpoint variant - The resource type is variant and the unique identifier is the resource ID.
         * Example: endpoint/my-end-point/variant/KMeansClustering.
         * Custom resources are not supported with a resource type. This parameter must specify the OutputValue from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information
         * is available in our <a href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub
         * repository.
         * Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE.
         * Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE.
         * Lambda provisioned concurrency - The resource type is function and the unique identifier is the function name with a function version or alias name suffix that is not $LATEST.
         * Example: function:my-function:prod or function:my-function:1.
         * Amazon Keyspaces table - The resource type is table and the unique identifier is the table name.
         * Example: keyspace/mykeyspace/table/mytable.
         * Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN.
         * Example: arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5.
         * Amazon ElastiCache replication group - The resource type is replication-group and the unique identifier is the replication group name.
         * Example: replication-group/mycluster.
         * Neptune cluster - The resource type is cluster and the unique identifier is the cluster name. Example: cluster:mycluster.
         */
        fun resourceId(resourceId: String): FluentBuilder
        /**
         * The scalable dimension. This string consists of the service namespace, resource type, and scaling property.
         * If you specify a scalable dimension, you must also specify a resource ID.
         * ecs:service:DesiredCount - The desired task count of an ECS service.
         * elasticmapreduce:instancegroup:InstanceCount - The instance count of an EMR Instance Group.
         * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot Fleet.
         * appstream:fleet:DesiredCapacity - The desired capacity of an AppStream 2.0 fleet.
         * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for a DynamoDB table.
         * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for a DynamoDB table.
         * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for a DynamoDB global secondary index.
         * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for a DynamoDB global secondary index.
         * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
         * sagemaker:variant:DesiredInstanceCount - The number of EC2 instances for an SageMaker model endpoint variant.
         * custom-resource:ResourceType:Property - The scalable dimension for a custom resource provided by your own application or service.
         * comprehend:document-classifier-endpoint:DesiredInferenceUnits - The number of inference units for an Amazon Comprehend document classification endpoint.
         * comprehend:entity-recognizer-endpoint:DesiredInferenceUnits - The number of inference units for an Amazon Comprehend entity recognizer endpoint.
         * lambda:function:ProvisionedConcurrency - The provisioned concurrency for a Lambda function.
         * cassandra:table:ReadCapacityUnits - The provisioned read capacity for an Amazon Keyspaces table.
         * cassandra:table:WriteCapacityUnits - The provisioned write capacity for an Amazon Keyspaces table.
         * kafka:broker-storage:VolumeSize - The provisioned volume size (in GiB) for brokers in an Amazon MSK cluster.
         * elasticache:replication-group:NodeGroups - The number of node groups for an Amazon ElastiCache replication group.
         * elasticache:replication-group:Replicas - The number of replicas per node group for an Amazon ElastiCache replication group.
         * neptune:cluster:ReadReplicaCount - The count of read replicas in an Amazon Neptune DB cluster.
         */
        fun scalableDimension(scalableDimension: ScalableDimension): FluentBuilder
        /**
         * The names of the scheduled actions to describe.
         */
        fun scheduledActionNames(scheduledActionNames: List<String>): FluentBuilder
        /**
         * The namespace of the Amazon Web Services service that provides the resource. For a resource provided
         * by your own application or service, use custom-resource instead.
         */
        fun serviceNamespace(serviceNamespace: ServiceNamespace): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The maximum number of scheduled action results. This value can be between
         * 1 and 50. The default value is 50.
         * If this parameter is used, the operation returns up to MaxResults results
         * at a time, along with a NextToken value. To get the next set of results,
         * include the NextToken value in a subsequent call. If this parameter is not
         * used, the operation returns up to 50 results and a
         * NextToken value, if applicable.
         */
        var maxResults: Int?
        /**
         * The token for the next set of results.
         */
        var nextToken: String?
        /**
         * The identifier of the resource associated with the scheduled action.
         * This string consists of the resource type and unique identifier.
         * ECS service - The resource type is service and the unique identifier is the cluster name
         * and service name. Example: service/default/sample-webapp.
         * Spot Fleet - The resource type is spot-fleet-request and the unique identifier is the
         * Spot Fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
         * EMR cluster - The resource type is instancegroup and the unique identifier is the cluster ID and instance group ID.
         * Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.
         * AppStream 2.0 fleet - The resource type is fleet and the unique identifier is the fleet name.
         * Example: fleet/sample-fleet.
         * DynamoDB table - The resource type is table and the unique identifier is the table name.
         * Example: table/my-table.
         * DynamoDB global secondary index - The resource type is index and the unique identifier is the index name.
         * Example: table/my-table/index/my-table-index.
         * Aurora DB cluster - The resource type is cluster and the unique identifier is the cluster name.
         * Example: cluster:my-db-cluster.
         * SageMaker endpoint variant - The resource type is variant and the unique identifier is the resource ID.
         * Example: endpoint/my-end-point/variant/KMeansClustering.
         * Custom resources are not supported with a resource type. This parameter must specify the OutputValue from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information
         * is available in our <a href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub
         * repository.
         * Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE.
         * Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE.
         * Lambda provisioned concurrency - The resource type is function and the unique identifier is the function name with a function version or alias name suffix that is not $LATEST.
         * Example: function:my-function:prod or function:my-function:1.
         * Amazon Keyspaces table - The resource type is table and the unique identifier is the table name.
         * Example: keyspace/mykeyspace/table/mytable.
         * Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN.
         * Example: arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5.
         * Amazon ElastiCache replication group - The resource type is replication-group and the unique identifier is the replication group name.
         * Example: replication-group/mycluster.
         * Neptune cluster - The resource type is cluster and the unique identifier is the cluster name. Example: cluster:mycluster.
         */
        var resourceId: String?
        /**
         * The scalable dimension. This string consists of the service namespace, resource type, and scaling property.
         * If you specify a scalable dimension, you must also specify a resource ID.
         * ecs:service:DesiredCount - The desired task count of an ECS service.
         * elasticmapreduce:instancegroup:InstanceCount - The instance count of an EMR Instance Group.
         * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot Fleet.
         * appstream:fleet:DesiredCapacity - The desired capacity of an AppStream 2.0 fleet.
         * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for a DynamoDB table.
         * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for a DynamoDB table.
         * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for a DynamoDB global secondary index.
         * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for a DynamoDB global secondary index.
         * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
         * sagemaker:variant:DesiredInstanceCount - The number of EC2 instances for an SageMaker model endpoint variant.
         * custom-resource:ResourceType:Property - The scalable dimension for a custom resource provided by your own application or service.
         * comprehend:document-classifier-endpoint:DesiredInferenceUnits - The number of inference units for an Amazon Comprehend document classification endpoint.
         * comprehend:entity-recognizer-endpoint:DesiredInferenceUnits - The number of inference units for an Amazon Comprehend entity recognizer endpoint.
         * lambda:function:ProvisionedConcurrency - The provisioned concurrency for a Lambda function.
         * cassandra:table:ReadCapacityUnits - The provisioned read capacity for an Amazon Keyspaces table.
         * cassandra:table:WriteCapacityUnits - The provisioned write capacity for an Amazon Keyspaces table.
         * kafka:broker-storage:VolumeSize - The provisioned volume size (in GiB) for brokers in an Amazon MSK cluster.
         * elasticache:replication-group:NodeGroups - The number of node groups for an Amazon ElastiCache replication group.
         * elasticache:replication-group:Replicas - The number of replicas per node group for an Amazon ElastiCache replication group.
         * neptune:cluster:ReadReplicaCount - The count of read replicas in an Amazon Neptune DB cluster.
         */
        var scalableDimension: ScalableDimension?
        /**
         * The names of the scheduled actions to describe.
         */
        var scheduledActionNames: List<String>?
        /**
         * The namespace of the Amazon Web Services service that provides the resource. For a resource provided
         * by your own application or service, use custom-resource instead.
         */
        var serviceNamespace: ServiceNamespace?

        fun build(): DescribeScheduledActionsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var maxResults: Int? = null
        override var nextToken: String? = null
        override var resourceId: String? = null
        override var scalableDimension: ScalableDimension? = null
        override var scheduledActionNames: List<String>? = null
        override var serviceNamespace: ServiceNamespace? = null

        constructor(x: DescribeScheduledActionsRequest) : this() {
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.resourceId = x.resourceId
            this.scalableDimension = x.scalableDimension
            this.scheduledActionNames = x.scheduledActionNames
            this.serviceNamespace = x.serviceNamespace
        }

        override fun build(): DescribeScheduledActionsRequest = DescribeScheduledActionsRequest(this)
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun resourceId(resourceId: String): FluentBuilder = apply { this.resourceId = resourceId }
        override fun scalableDimension(scalableDimension: ScalableDimension): FluentBuilder = apply { this.scalableDimension = scalableDimension }
        override fun scheduledActionNames(scheduledActionNames: List<String>): FluentBuilder = apply { this.scheduledActionNames = scheduledActionNames }
        override fun serviceNamespace(serviceNamespace: ServiceNamespace): FluentBuilder = apply { this.serviceNamespace = serviceNamespace }
    }
}
