// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationautoscaling.model



/**
 * Represents a predefined metric for a target tracking scaling policy to use with
 * Application Auto Scaling.
 * Only the Amazon Web Services that you're using send metrics to Amazon CloudWatch. To determine whether a
 * desired metric already exists by looking up its namespace and dimension using the CloudWatch
 * metrics dashboard in the console, follow the procedure in <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/monitoring-cloudwatch.html">Building dashboards
 * with CloudWatch in the Application Auto Scaling User Guide.
 */
class PredefinedMetricSpecification private constructor(builder: BuilderImpl) {
    /**
     * The metric type. The ALBRequestCountPerTarget metric type applies only to
     * Spot Fleet requests and ECS services.
     */
    val predefinedMetricType: MetricType? = builder.predefinedMetricType
    /**
     * Identifies the resource associated with the metric type. You can't specify a resource
     * label unless the metric type is ALBRequestCountPerTarget and there is a target
     * group attached to the Spot Fleet request or ECS service.
     * You create the resource label by appending the final portion of the load balancer ARN
     * and the final portion of the target group ARN into a single value, separated by a forward
     * slash (/). The format of the resource label is:
     * app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff.
     * Where:
     * app/<load-balancer-name>/<load-balancer-id> is the final portion of
     * the load balancer ARN
     * targetgroup/<target-group-name>/<target-group-id> is the final portion
     * of the target group ARN.
     * To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers API operation. To find the ARN for the target group, use
     * the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups API operation.
     */
    val resourceLabel: String? = builder.resourceLabel

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PredefinedMetricSpecification = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PredefinedMetricSpecification(")
        append("predefinedMetricType=$predefinedMetricType,")
        append("resourceLabel=$resourceLabel)")
    }

    override fun hashCode(): kotlin.Int {
        var result = predefinedMetricType?.hashCode() ?: 0
        result = 31 * result + (resourceLabel?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PredefinedMetricSpecification

        if (predefinedMetricType != other.predefinedMetricType) return false
        if (resourceLabel != other.resourceLabel) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PredefinedMetricSpecification = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PredefinedMetricSpecification
        /**
         * The metric type. The ALBRequestCountPerTarget metric type applies only to
         * Spot Fleet requests and ECS services.
         */
        fun predefinedMetricType(predefinedMetricType: MetricType): FluentBuilder
        /**
         * Identifies the resource associated with the metric type. You can't specify a resource
         * label unless the metric type is ALBRequestCountPerTarget and there is a target
         * group attached to the Spot Fleet request or ECS service.
         * You create the resource label by appending the final portion of the load balancer ARN
         * and the final portion of the target group ARN into a single value, separated by a forward
         * slash (/). The format of the resource label is:
         * app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff.
         * Where:
         * app/<load-balancer-name>/<load-balancer-id> is the final portion of
         * the load balancer ARN
         * targetgroup/<target-group-name>/<target-group-id> is the final portion
         * of the target group ARN.
         * To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers API operation. To find the ARN for the target group, use
         * the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups API operation.
         */
        fun resourceLabel(resourceLabel: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The metric type. The ALBRequestCountPerTarget metric type applies only to
         * Spot Fleet requests and ECS services.
         */
        var predefinedMetricType: MetricType?
        /**
         * Identifies the resource associated with the metric type. You can't specify a resource
         * label unless the metric type is ALBRequestCountPerTarget and there is a target
         * group attached to the Spot Fleet request or ECS service.
         * You create the resource label by appending the final portion of the load balancer ARN
         * and the final portion of the target group ARN into a single value, separated by a forward
         * slash (/). The format of the resource label is:
         * app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff.
         * Where:
         * app/<load-balancer-name>/<load-balancer-id> is the final portion of
         * the load balancer ARN
         * targetgroup/<target-group-name>/<target-group-id> is the final portion
         * of the target group ARN.
         * To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers API operation. To find the ARN for the target group, use
         * the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups API operation.
         */
        var resourceLabel: String?

        fun build(): PredefinedMetricSpecification
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var predefinedMetricType: MetricType? = null
        override var resourceLabel: String? = null

        constructor(x: PredefinedMetricSpecification) : this() {
            this.predefinedMetricType = x.predefinedMetricType
            this.resourceLabel = x.resourceLabel
        }

        override fun build(): PredefinedMetricSpecification = PredefinedMetricSpecification(this)
        override fun predefinedMetricType(predefinedMetricType: MetricType): FluentBuilder = apply { this.predefinedMetricType = predefinedMetricType }
        override fun resourceLabel(resourceLabel: String): FluentBuilder = apply { this.resourceLabel = resourceLabel }
    }
}
