// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationautoscaling.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents a scaling activity.
 */
class ScalingActivity private constructor(builder: BuilderImpl) {
    /**
     * The unique identifier of the scaling activity.
     */
    val activityId: String? = builder.activityId
    /**
     * A simple description of what caused the scaling activity to happen.
     */
    val cause: String? = builder.cause
    /**
     * A simple description of what action the scaling activity intends to accomplish.
     */
    val description: String? = builder.description
    /**
     * The details about the scaling activity.
     */
    val details: String? = builder.details
    /**
     * The Unix timestamp for when the scaling activity ended.
     */
    val endTime: Instant? = builder.endTime
    /**
     * The identifier of the resource associated with the scaling activity.
     * This string consists of the resource type and unique identifier.
     * ECS service - The resource type is service and the unique identifier is the cluster name
     * and service name. Example: service/default/sample-webapp.
     * Spot Fleet - The resource type is spot-fleet-request and the unique identifier is the
     * Spot Fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
     * EMR cluster - The resource type is instancegroup and the unique identifier is the cluster ID and instance group ID.
     * Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.
     * AppStream 2.0 fleet - The resource type is fleet and the unique identifier is the fleet name.
     * Example: fleet/sample-fleet.
     * DynamoDB table - The resource type is table and the unique identifier is the table name.
     * Example: table/my-table.
     * DynamoDB global secondary index - The resource type is index and the unique identifier is the index name.
     * Example: table/my-table/index/my-table-index.
     * Aurora DB cluster - The resource type is cluster and the unique identifier is the cluster name.
     * Example: cluster:my-db-cluster.
     * SageMaker endpoint variant - The resource type is variant and the unique identifier is the resource ID.
     * Example: endpoint/my-end-point/variant/KMeansClustering.
     * Custom resources are not supported with a resource type. This parameter must specify the OutputValue from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information
     * is available in our <a href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub
     * repository.
     * Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE.
     * Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE.
     * Lambda provisioned concurrency - The resource type is function and the unique identifier is the function name with a function version or alias name suffix that is not $LATEST.
     * Example: function:my-function:prod or function:my-function:1.
     * Amazon Keyspaces table - The resource type is table and the unique identifier is the table name.
     * Example: keyspace/mykeyspace/table/mytable.
     * Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN.
     * Example: arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5.
     * Amazon ElastiCache replication group - The resource type is replication-group and the unique identifier is the replication group name.
     * Example: replication-group/mycluster.
     * Neptune cluster - The resource type is cluster and the unique identifier is the cluster name. Example: cluster:mycluster.
     */
    val resourceId: String? = builder.resourceId
    /**
     * The scalable dimension. This string consists of the service namespace, resource type, and scaling property.
     * ecs:service:DesiredCount - The desired task count of an ECS service.
     * elasticmapreduce:instancegroup:InstanceCount - The instance count of an EMR Instance Group.
     * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot Fleet.
     * appstream:fleet:DesiredCapacity - The desired capacity of an AppStream 2.0 fleet.
     * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for a DynamoDB table.
     * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for a DynamoDB table.
     * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for a DynamoDB global secondary index.
     * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for a DynamoDB global secondary index.
     * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
     * sagemaker:variant:DesiredInstanceCount - The number of EC2 instances for an SageMaker model endpoint variant.
     * custom-resource:ResourceType:Property - The scalable dimension for a custom resource provided by your own application or service.
     * comprehend:document-classifier-endpoint:DesiredInferenceUnits - The number of inference units for an Amazon Comprehend document classification endpoint.
     * comprehend:entity-recognizer-endpoint:DesiredInferenceUnits - The number of inference units for an Amazon Comprehend entity recognizer endpoint.
     * lambda:function:ProvisionedConcurrency - The provisioned concurrency for a Lambda function.
     * cassandra:table:ReadCapacityUnits - The provisioned read capacity for an Amazon Keyspaces table.
     * cassandra:table:WriteCapacityUnits - The provisioned write capacity for an Amazon Keyspaces table.
     * kafka:broker-storage:VolumeSize - The provisioned volume size (in GiB) for brokers in an Amazon MSK cluster.
     * elasticache:replication-group:NodeGroups - The number of node groups for an Amazon ElastiCache replication group.
     * elasticache:replication-group:Replicas - The number of replicas per node group for an Amazon ElastiCache replication group.
     * neptune:cluster:ReadReplicaCount - The count of read replicas in an Amazon Neptune DB cluster.
     */
    val scalableDimension: ScalableDimension? = builder.scalableDimension
    /**
     * The namespace of the Amazon Web Services service that provides the resource, or a
     * custom-resource.
     */
    val serviceNamespace: ServiceNamespace? = builder.serviceNamespace
    /**
     * The Unix timestamp for when the scaling activity began.
     */
    val startTime: Instant? = builder.startTime
    /**
     * Indicates the status of the scaling activity.
     */
    val statusCode: ScalingActivityStatusCode? = builder.statusCode
    /**
     * A simple message about the current status of the scaling activity.
     */
    val statusMessage: String? = builder.statusMessage

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ScalingActivity = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ScalingActivity(")
        append("activityId=$activityId,")
        append("cause=$cause,")
        append("description=$description,")
        append("details=$details,")
        append("endTime=$endTime,")
        append("resourceId=$resourceId,")
        append("scalableDimension=$scalableDimension,")
        append("serviceNamespace=$serviceNamespace,")
        append("startTime=$startTime,")
        append("statusCode=$statusCode,")
        append("statusMessage=$statusMessage)")
    }

    override fun hashCode(): kotlin.Int {
        var result = activityId?.hashCode() ?: 0
        result = 31 * result + (cause?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (details?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (scalableDimension?.hashCode() ?: 0)
        result = 31 * result + (serviceNamespace?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (statusCode?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ScalingActivity

        if (activityId != other.activityId) return false
        if (cause != other.cause) return false
        if (description != other.description) return false
        if (details != other.details) return false
        if (endTime != other.endTime) return false
        if (resourceId != other.resourceId) return false
        if (scalableDimension != other.scalableDimension) return false
        if (serviceNamespace != other.serviceNamespace) return false
        if (startTime != other.startTime) return false
        if (statusCode != other.statusCode) return false
        if (statusMessage != other.statusMessage) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ScalingActivity = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ScalingActivity
        /**
         * The unique identifier of the scaling activity.
         */
        fun activityId(activityId: String): FluentBuilder
        /**
         * A simple description of what caused the scaling activity to happen.
         */
        fun cause(cause: String): FluentBuilder
        /**
         * A simple description of what action the scaling activity intends to accomplish.
         */
        fun description(description: String): FluentBuilder
        /**
         * The details about the scaling activity.
         */
        fun details(details: String): FluentBuilder
        /**
         * The Unix timestamp for when the scaling activity ended.
         */
        fun endTime(endTime: Instant): FluentBuilder
        /**
         * The identifier of the resource associated with the scaling activity.
         * This string consists of the resource type and unique identifier.
         * ECS service - The resource type is service and the unique identifier is the cluster name
         * and service name. Example: service/default/sample-webapp.
         * Spot Fleet - The resource type is spot-fleet-request and the unique identifier is the
         * Spot Fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
         * EMR cluster - The resource type is instancegroup and the unique identifier is the cluster ID and instance group ID.
         * Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.
         * AppStream 2.0 fleet - The resource type is fleet and the unique identifier is the fleet name.
         * Example: fleet/sample-fleet.
         * DynamoDB table - The resource type is table and the unique identifier is the table name.
         * Example: table/my-table.
         * DynamoDB global secondary index - The resource type is index and the unique identifier is the index name.
         * Example: table/my-table/index/my-table-index.
         * Aurora DB cluster - The resource type is cluster and the unique identifier is the cluster name.
         * Example: cluster:my-db-cluster.
         * SageMaker endpoint variant - The resource type is variant and the unique identifier is the resource ID.
         * Example: endpoint/my-end-point/variant/KMeansClustering.
         * Custom resources are not supported with a resource type. This parameter must specify the OutputValue from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information
         * is available in our <a href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub
         * repository.
         * Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE.
         * Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE.
         * Lambda provisioned concurrency - The resource type is function and the unique identifier is the function name with a function version or alias name suffix that is not $LATEST.
         * Example: function:my-function:prod or function:my-function:1.
         * Amazon Keyspaces table - The resource type is table and the unique identifier is the table name.
         * Example: keyspace/mykeyspace/table/mytable.
         * Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN.
         * Example: arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5.
         * Amazon ElastiCache replication group - The resource type is replication-group and the unique identifier is the replication group name.
         * Example: replication-group/mycluster.
         * Neptune cluster - The resource type is cluster and the unique identifier is the cluster name. Example: cluster:mycluster.
         */
        fun resourceId(resourceId: String): FluentBuilder
        /**
         * The scalable dimension. This string consists of the service namespace, resource type, and scaling property.
         * ecs:service:DesiredCount - The desired task count of an ECS service.
         * elasticmapreduce:instancegroup:InstanceCount - The instance count of an EMR Instance Group.
         * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot Fleet.
         * appstream:fleet:DesiredCapacity - The desired capacity of an AppStream 2.0 fleet.
         * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for a DynamoDB table.
         * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for a DynamoDB table.
         * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for a DynamoDB global secondary index.
         * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for a DynamoDB global secondary index.
         * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
         * sagemaker:variant:DesiredInstanceCount - The number of EC2 instances for an SageMaker model endpoint variant.
         * custom-resource:ResourceType:Property - The scalable dimension for a custom resource provided by your own application or service.
         * comprehend:document-classifier-endpoint:DesiredInferenceUnits - The number of inference units for an Amazon Comprehend document classification endpoint.
         * comprehend:entity-recognizer-endpoint:DesiredInferenceUnits - The number of inference units for an Amazon Comprehend entity recognizer endpoint.
         * lambda:function:ProvisionedConcurrency - The provisioned concurrency for a Lambda function.
         * cassandra:table:ReadCapacityUnits - The provisioned read capacity for an Amazon Keyspaces table.
         * cassandra:table:WriteCapacityUnits - The provisioned write capacity for an Amazon Keyspaces table.
         * kafka:broker-storage:VolumeSize - The provisioned volume size (in GiB) for brokers in an Amazon MSK cluster.
         * elasticache:replication-group:NodeGroups - The number of node groups for an Amazon ElastiCache replication group.
         * elasticache:replication-group:Replicas - The number of replicas per node group for an Amazon ElastiCache replication group.
         * neptune:cluster:ReadReplicaCount - The count of read replicas in an Amazon Neptune DB cluster.
         */
        fun scalableDimension(scalableDimension: ScalableDimension): FluentBuilder
        /**
         * The namespace of the Amazon Web Services service that provides the resource, or a
         * custom-resource.
         */
        fun serviceNamespace(serviceNamespace: ServiceNamespace): FluentBuilder
        /**
         * The Unix timestamp for when the scaling activity began.
         */
        fun startTime(startTime: Instant): FluentBuilder
        /**
         * Indicates the status of the scaling activity.
         */
        fun statusCode(statusCode: ScalingActivityStatusCode): FluentBuilder
        /**
         * A simple message about the current status of the scaling activity.
         */
        fun statusMessage(statusMessage: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The unique identifier of the scaling activity.
         */
        var activityId: String?
        /**
         * A simple description of what caused the scaling activity to happen.
         */
        var cause: String?
        /**
         * A simple description of what action the scaling activity intends to accomplish.
         */
        var description: String?
        /**
         * The details about the scaling activity.
         */
        var details: String?
        /**
         * The Unix timestamp for when the scaling activity ended.
         */
        var endTime: Instant?
        /**
         * The identifier of the resource associated with the scaling activity.
         * This string consists of the resource type and unique identifier.
         * ECS service - The resource type is service and the unique identifier is the cluster name
         * and service name. Example: service/default/sample-webapp.
         * Spot Fleet - The resource type is spot-fleet-request and the unique identifier is the
         * Spot Fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
         * EMR cluster - The resource type is instancegroup and the unique identifier is the cluster ID and instance group ID.
         * Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.
         * AppStream 2.0 fleet - The resource type is fleet and the unique identifier is the fleet name.
         * Example: fleet/sample-fleet.
         * DynamoDB table - The resource type is table and the unique identifier is the table name.
         * Example: table/my-table.
         * DynamoDB global secondary index - The resource type is index and the unique identifier is the index name.
         * Example: table/my-table/index/my-table-index.
         * Aurora DB cluster - The resource type is cluster and the unique identifier is the cluster name.
         * Example: cluster:my-db-cluster.
         * SageMaker endpoint variant - The resource type is variant and the unique identifier is the resource ID.
         * Example: endpoint/my-end-point/variant/KMeansClustering.
         * Custom resources are not supported with a resource type. This parameter must specify the OutputValue from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information
         * is available in our <a href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub
         * repository.
         * Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE.
         * Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE.
         * Lambda provisioned concurrency - The resource type is function and the unique identifier is the function name with a function version or alias name suffix that is not $LATEST.
         * Example: function:my-function:prod or function:my-function:1.
         * Amazon Keyspaces table - The resource type is table and the unique identifier is the table name.
         * Example: keyspace/mykeyspace/table/mytable.
         * Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN.
         * Example: arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5.
         * Amazon ElastiCache replication group - The resource type is replication-group and the unique identifier is the replication group name.
         * Example: replication-group/mycluster.
         * Neptune cluster - The resource type is cluster and the unique identifier is the cluster name. Example: cluster:mycluster.
         */
        var resourceId: String?
        /**
         * The scalable dimension. This string consists of the service namespace, resource type, and scaling property.
         * ecs:service:DesiredCount - The desired task count of an ECS service.
         * elasticmapreduce:instancegroup:InstanceCount - The instance count of an EMR Instance Group.
         * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot Fleet.
         * appstream:fleet:DesiredCapacity - The desired capacity of an AppStream 2.0 fleet.
         * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for a DynamoDB table.
         * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for a DynamoDB table.
         * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for a DynamoDB global secondary index.
         * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for a DynamoDB global secondary index.
         * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
         * sagemaker:variant:DesiredInstanceCount - The number of EC2 instances for an SageMaker model endpoint variant.
         * custom-resource:ResourceType:Property - The scalable dimension for a custom resource provided by your own application or service.
         * comprehend:document-classifier-endpoint:DesiredInferenceUnits - The number of inference units for an Amazon Comprehend document classification endpoint.
         * comprehend:entity-recognizer-endpoint:DesiredInferenceUnits - The number of inference units for an Amazon Comprehend entity recognizer endpoint.
         * lambda:function:ProvisionedConcurrency - The provisioned concurrency for a Lambda function.
         * cassandra:table:ReadCapacityUnits - The provisioned read capacity for an Amazon Keyspaces table.
         * cassandra:table:WriteCapacityUnits - The provisioned write capacity for an Amazon Keyspaces table.
         * kafka:broker-storage:VolumeSize - The provisioned volume size (in GiB) for brokers in an Amazon MSK cluster.
         * elasticache:replication-group:NodeGroups - The number of node groups for an Amazon ElastiCache replication group.
         * elasticache:replication-group:Replicas - The number of replicas per node group for an Amazon ElastiCache replication group.
         * neptune:cluster:ReadReplicaCount - The count of read replicas in an Amazon Neptune DB cluster.
         */
        var scalableDimension: ScalableDimension?
        /**
         * The namespace of the Amazon Web Services service that provides the resource, or a
         * custom-resource.
         */
        var serviceNamespace: ServiceNamespace?
        /**
         * The Unix timestamp for when the scaling activity began.
         */
        var startTime: Instant?
        /**
         * Indicates the status of the scaling activity.
         */
        var statusCode: ScalingActivityStatusCode?
        /**
         * A simple message about the current status of the scaling activity.
         */
        var statusMessage: String?

        fun build(): ScalingActivity
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var activityId: String? = null
        override var cause: String? = null
        override var description: String? = null
        override var details: String? = null
        override var endTime: Instant? = null
        override var resourceId: String? = null
        override var scalableDimension: ScalableDimension? = null
        override var serviceNamespace: ServiceNamespace? = null
        override var startTime: Instant? = null
        override var statusCode: ScalingActivityStatusCode? = null
        override var statusMessage: String? = null

        constructor(x: ScalingActivity) : this() {
            this.activityId = x.activityId
            this.cause = x.cause
            this.description = x.description
            this.details = x.details
            this.endTime = x.endTime
            this.resourceId = x.resourceId
            this.scalableDimension = x.scalableDimension
            this.serviceNamespace = x.serviceNamespace
            this.startTime = x.startTime
            this.statusCode = x.statusCode
            this.statusMessage = x.statusMessage
        }

        override fun build(): ScalingActivity = ScalingActivity(this)
        override fun activityId(activityId: String): FluentBuilder = apply { this.activityId = activityId }
        override fun cause(cause: String): FluentBuilder = apply { this.cause = cause }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun details(details: String): FluentBuilder = apply { this.details = details }
        override fun endTime(endTime: Instant): FluentBuilder = apply { this.endTime = endTime }
        override fun resourceId(resourceId: String): FluentBuilder = apply { this.resourceId = resourceId }
        override fun scalableDimension(scalableDimension: ScalableDimension): FluentBuilder = apply { this.scalableDimension = scalableDimension }
        override fun serviceNamespace(serviceNamespace: ServiceNamespace): FluentBuilder = apply { this.serviceNamespace = serviceNamespace }
        override fun startTime(startTime: Instant): FluentBuilder = apply { this.startTime = startTime }
        override fun statusCode(statusCode: ScalingActivityStatusCode): FluentBuilder = apply { this.statusCode = statusCode }
        override fun statusMessage(statusMessage: String): FluentBuilder = apply { this.statusMessage = statusMessage }
    }
}
