// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationautoscaling.model



/**
 * Represents a step scaling policy configuration to use with Application Auto Scaling.
 */
class StepScalingPolicyConfiguration private constructor(builder: BuilderImpl) {
    /**
     * Specifies how the ScalingAdjustment value in a <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_StepAdjustment.html">StepAdjustment is interpreted (for example, an absolute number or a
     * percentage). The valid values are ChangeInCapacity,
     * ExactCapacity, and PercentChangeInCapacity.
     * AdjustmentType is required if you are adding a new step scaling policy
     * configuration.
     */
    val adjustmentType: AdjustmentType? = builder.adjustmentType
    /**
     * The amount of time, in seconds, to wait for a previous scaling activity to take effect.
     * With scale-out policies, the intention is to continuously (but not excessively) scale out.
     * After Application Auto Scaling successfully scales out using a step scaling policy, it starts to calculate the
     * cooldown time. The scaling policy won't increase the desired capacity again unless either a
     * larger scale out is triggered or the cooldown period ends. While the cooldown period is in
     * effect, capacity added by the initiating scale-out activity is calculated as part of the
     * desired capacity for the next scale-out activity. For example, when an alarm triggers a step
     * scaling policy to increase the capacity by 2, the scaling activity completes successfully, and
     * a cooldown period starts. If the alarm triggers again during the cooldown period but at a more
     * aggressive step adjustment of 3, the previous increase of 2 is considered part of the current
     * capacity. Therefore, only 1 is added to the capacity.
     * With scale-in policies, the intention is to scale in conservatively to protect your
     * application’s availability, so scale-in activities are blocked until the cooldown period has
     * expired. However, if another alarm triggers a scale-out activity during the cooldown period
     * after a scale-in activity, Application Auto Scaling scales out the target immediately. In this case, the
     * cooldown period for the scale-in activity stops and doesn't complete.
     * Application Auto Scaling provides a default value of 600 for Amazon ElastiCache replication groups
     * and a default value of 300 for the following scalable targets:
     * AppStream 2.0 fleets
     * Aurora DB clusters
     * ECS services
     * EMR clusters
     * Neptune clusters
     * SageMaker endpoint variants
     * Spot Fleets
     * Custom resources
     * For all other scalable targets, the default value is 0:
     * Amazon Comprehend document classification and entity recognizer endpoints
     * DynamoDB tables and global secondary indexes
     * Amazon Keyspaces tables
     * Lambda provisioned concurrency
     * Amazon MSK broker storage
     */
    val cooldown: Int? = builder.cooldown
    /**
     * The aggregation type for the CloudWatch metrics. Valid values are Minimum,
     * Maximum, and Average. If the aggregation type is null, the
     * value is treated as Average.
     */
    val metricAggregationType: MetricAggregationType? = builder.metricAggregationType
    /**
     * The minimum value to scale by when the adjustment type is
     * PercentChangeInCapacity. For example, suppose that you create a step
     * scaling policy to scale out an Amazon ECS service by 25 percent and you specify a
     * MinAdjustmentMagnitude of 2. If the service has 4 tasks and the scaling
     * policy is performed, 25 percent of 4 is 1. However, because you specified a
     * MinAdjustmentMagnitude of 2, Application Auto Scaling scales out the service by 2
     * tasks.
     */
    val minAdjustmentMagnitude: Int? = builder.minAdjustmentMagnitude
    /**
     * A set of adjustments that enable you to scale based on the size of the alarm
     * breach.
     * At least one step adjustment is required if you are adding a new step scaling policy
     * configuration.
     */
    val stepAdjustments: List<StepAdjustment>? = builder.stepAdjustments

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): StepScalingPolicyConfiguration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("StepScalingPolicyConfiguration(")
        append("adjustmentType=$adjustmentType,")
        append("cooldown=$cooldown,")
        append("metricAggregationType=$metricAggregationType,")
        append("minAdjustmentMagnitude=$minAdjustmentMagnitude,")
        append("stepAdjustments=$stepAdjustments)")
    }

    override fun hashCode(): kotlin.Int {
        var result = adjustmentType?.hashCode() ?: 0
        result = 31 * result + (cooldown ?: 0)
        result = 31 * result + (metricAggregationType?.hashCode() ?: 0)
        result = 31 * result + (minAdjustmentMagnitude ?: 0)
        result = 31 * result + (stepAdjustments?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as StepScalingPolicyConfiguration

        if (adjustmentType != other.adjustmentType) return false
        if (cooldown != other.cooldown) return false
        if (metricAggregationType != other.metricAggregationType) return false
        if (minAdjustmentMagnitude != other.minAdjustmentMagnitude) return false
        if (stepAdjustments != other.stepAdjustments) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): StepScalingPolicyConfiguration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): StepScalingPolicyConfiguration
        /**
         * Specifies how the ScalingAdjustment value in a <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_StepAdjustment.html">StepAdjustment is interpreted (for example, an absolute number or a
         * percentage). The valid values are ChangeInCapacity,
         * ExactCapacity, and PercentChangeInCapacity.
         * AdjustmentType is required if you are adding a new step scaling policy
         * configuration.
         */
        fun adjustmentType(adjustmentType: AdjustmentType): FluentBuilder
        /**
         * The amount of time, in seconds, to wait for a previous scaling activity to take effect.
         * With scale-out policies, the intention is to continuously (but not excessively) scale out.
         * After Application Auto Scaling successfully scales out using a step scaling policy, it starts to calculate the
         * cooldown time. The scaling policy won't increase the desired capacity again unless either a
         * larger scale out is triggered or the cooldown period ends. While the cooldown period is in
         * effect, capacity added by the initiating scale-out activity is calculated as part of the
         * desired capacity for the next scale-out activity. For example, when an alarm triggers a step
         * scaling policy to increase the capacity by 2, the scaling activity completes successfully, and
         * a cooldown period starts. If the alarm triggers again during the cooldown period but at a more
         * aggressive step adjustment of 3, the previous increase of 2 is considered part of the current
         * capacity. Therefore, only 1 is added to the capacity.
         * With scale-in policies, the intention is to scale in conservatively to protect your
         * application’s availability, so scale-in activities are blocked until the cooldown period has
         * expired. However, if another alarm triggers a scale-out activity during the cooldown period
         * after a scale-in activity, Application Auto Scaling scales out the target immediately. In this case, the
         * cooldown period for the scale-in activity stops and doesn't complete.
         * Application Auto Scaling provides a default value of 600 for Amazon ElastiCache replication groups
         * and a default value of 300 for the following scalable targets:
         * AppStream 2.0 fleets
         * Aurora DB clusters
         * ECS services
         * EMR clusters
         * Neptune clusters
         * SageMaker endpoint variants
         * Spot Fleets
         * Custom resources
         * For all other scalable targets, the default value is 0:
         * Amazon Comprehend document classification and entity recognizer endpoints
         * DynamoDB tables and global secondary indexes
         * Amazon Keyspaces tables
         * Lambda provisioned concurrency
         * Amazon MSK broker storage
         */
        fun cooldown(cooldown: Int): FluentBuilder
        /**
         * The aggregation type for the CloudWatch metrics. Valid values are Minimum,
         * Maximum, and Average. If the aggregation type is null, the
         * value is treated as Average.
         */
        fun metricAggregationType(metricAggregationType: MetricAggregationType): FluentBuilder
        /**
         * The minimum value to scale by when the adjustment type is
         * PercentChangeInCapacity. For example, suppose that you create a step
         * scaling policy to scale out an Amazon ECS service by 25 percent and you specify a
         * MinAdjustmentMagnitude of 2. If the service has 4 tasks and the scaling
         * policy is performed, 25 percent of 4 is 1. However, because you specified a
         * MinAdjustmentMagnitude of 2, Application Auto Scaling scales out the service by 2
         * tasks.
         */
        fun minAdjustmentMagnitude(minAdjustmentMagnitude: Int): FluentBuilder
        /**
         * A set of adjustments that enable you to scale based on the size of the alarm
         * breach.
         * At least one step adjustment is required if you are adding a new step scaling policy
         * configuration.
         */
        fun stepAdjustments(stepAdjustments: List<StepAdjustment>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Specifies how the ScalingAdjustment value in a <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_StepAdjustment.html">StepAdjustment is interpreted (for example, an absolute number or a
         * percentage). The valid values are ChangeInCapacity,
         * ExactCapacity, and PercentChangeInCapacity.
         * AdjustmentType is required if you are adding a new step scaling policy
         * configuration.
         */
        var adjustmentType: AdjustmentType?
        /**
         * The amount of time, in seconds, to wait for a previous scaling activity to take effect.
         * With scale-out policies, the intention is to continuously (but not excessively) scale out.
         * After Application Auto Scaling successfully scales out using a step scaling policy, it starts to calculate the
         * cooldown time. The scaling policy won't increase the desired capacity again unless either a
         * larger scale out is triggered or the cooldown period ends. While the cooldown period is in
         * effect, capacity added by the initiating scale-out activity is calculated as part of the
         * desired capacity for the next scale-out activity. For example, when an alarm triggers a step
         * scaling policy to increase the capacity by 2, the scaling activity completes successfully, and
         * a cooldown period starts. If the alarm triggers again during the cooldown period but at a more
         * aggressive step adjustment of 3, the previous increase of 2 is considered part of the current
         * capacity. Therefore, only 1 is added to the capacity.
         * With scale-in policies, the intention is to scale in conservatively to protect your
         * application’s availability, so scale-in activities are blocked until the cooldown period has
         * expired. However, if another alarm triggers a scale-out activity during the cooldown period
         * after a scale-in activity, Application Auto Scaling scales out the target immediately. In this case, the
         * cooldown period for the scale-in activity stops and doesn't complete.
         * Application Auto Scaling provides a default value of 600 for Amazon ElastiCache replication groups
         * and a default value of 300 for the following scalable targets:
         * AppStream 2.0 fleets
         * Aurora DB clusters
         * ECS services
         * EMR clusters
         * Neptune clusters
         * SageMaker endpoint variants
         * Spot Fleets
         * Custom resources
         * For all other scalable targets, the default value is 0:
         * Amazon Comprehend document classification and entity recognizer endpoints
         * DynamoDB tables and global secondary indexes
         * Amazon Keyspaces tables
         * Lambda provisioned concurrency
         * Amazon MSK broker storage
         */
        var cooldown: Int?
        /**
         * The aggregation type for the CloudWatch metrics. Valid values are Minimum,
         * Maximum, and Average. If the aggregation type is null, the
         * value is treated as Average.
         */
        var metricAggregationType: MetricAggregationType?
        /**
         * The minimum value to scale by when the adjustment type is
         * PercentChangeInCapacity. For example, suppose that you create a step
         * scaling policy to scale out an Amazon ECS service by 25 percent and you specify a
         * MinAdjustmentMagnitude of 2. If the service has 4 tasks and the scaling
         * policy is performed, 25 percent of 4 is 1. However, because you specified a
         * MinAdjustmentMagnitude of 2, Application Auto Scaling scales out the service by 2
         * tasks.
         */
        var minAdjustmentMagnitude: Int?
        /**
         * A set of adjustments that enable you to scale based on the size of the alarm
         * breach.
         * At least one step adjustment is required if you are adding a new step scaling policy
         * configuration.
         */
        var stepAdjustments: List<StepAdjustment>?

        fun build(): StepScalingPolicyConfiguration
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var adjustmentType: AdjustmentType? = null
        override var cooldown: Int? = null
        override var metricAggregationType: MetricAggregationType? = null
        override var minAdjustmentMagnitude: Int? = null
        override var stepAdjustments: List<StepAdjustment>? = null

        constructor(x: StepScalingPolicyConfiguration) : this() {
            this.adjustmentType = x.adjustmentType
            this.cooldown = x.cooldown
            this.metricAggregationType = x.metricAggregationType
            this.minAdjustmentMagnitude = x.minAdjustmentMagnitude
            this.stepAdjustments = x.stepAdjustments
        }

        override fun build(): StepScalingPolicyConfiguration = StepScalingPolicyConfiguration(this)
        override fun adjustmentType(adjustmentType: AdjustmentType): FluentBuilder = apply { this.adjustmentType = adjustmentType }
        override fun cooldown(cooldown: Int): FluentBuilder = apply { this.cooldown = cooldown }
        override fun metricAggregationType(metricAggregationType: MetricAggregationType): FluentBuilder = apply { this.metricAggregationType = metricAggregationType }
        override fun minAdjustmentMagnitude(minAdjustmentMagnitude: Int): FluentBuilder = apply { this.minAdjustmentMagnitude = minAdjustmentMagnitude }
        override fun stepAdjustments(stepAdjustments: List<StepAdjustment>): FluentBuilder = apply { this.stepAdjustments = stepAdjustments }
    }
}
