// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationautoscaling.model



/**
 * Represents a target tracking scaling policy configuration to use with Application Auto Scaling.
 */
class TargetTrackingScalingPolicyConfiguration private constructor(builder: BuilderImpl) {
    /**
     * A customized metric. You can specify either a predefined metric or a customized
     * metric.
     */
    val customizedMetricSpecification: CustomizedMetricSpecification? = builder.customizedMetricSpecification
    /**
     * Indicates whether scale in by the target tracking scaling policy is disabled. If the
     * value is true, scale in is disabled and the target tracking scaling policy
     * won't remove capacity from the scalable target. Otherwise, scale in is enabled and the
     * target tracking scaling policy can remove capacity from the scalable target. The default
     * value is false.
     */
    val disableScaleIn: Boolean? = builder.disableScaleIn
    /**
     * A predefined metric. You can specify either a predefined metric or a customized
     * metric.
     */
    val predefinedMetricSpecification: PredefinedMetricSpecification? = builder.predefinedMetricSpecification
    /**
     * The amount of time, in seconds, after a scale-in activity completes before another
     * scale-in activity can start.
     * With the scale-in cooldown period, the intention is to scale in
     * conservatively to protect your application’s availability, so scale-in activities are blocked
     * until the cooldown period has expired. However, if another alarm triggers a scale-out activity
     * during the scale-in cooldown period, Application Auto Scaling scales out the target immediately. In this case,
     * the scale-in cooldown period stops and doesn't complete.
     * Application Auto Scaling provides a default value of 600 for Amazon ElastiCache replication groups
     * and a default value of 300 for the following scalable targets:
     * AppStream 2.0 fleets
     * Aurora DB clusters
     * ECS services
     * EMR clusters
     * Neptune clusters
     * SageMaker endpoint variants
     * Spot Fleets
     * Custom resources
     * For all other scalable targets, the default value is 0:
     * Amazon Comprehend document classification and entity recognizer endpoints
     * DynamoDB tables and global secondary indexes
     * Amazon Keyspaces tables
     * Lambda provisioned concurrency
     * Amazon MSK broker storage
     */
    val scaleInCooldown: Int? = builder.scaleInCooldown
    /**
     * The amount of time, in seconds, to wait for a previous scale-out activity to take
     * effect.
     * With the scale-out cooldown period, the intention is to continuously
     * (but not excessively) scale out. After Application Auto Scaling successfully scales out using a target
     * tracking scaling policy, it starts to calculate the cooldown time. The scaling policy won't
     * increase the desired capacity again unless either a larger scale out is triggered or the
     * cooldown period ends. While the cooldown period is in effect, the capacity added by the
     * initiating scale-out activity is calculated as part of the desired capacity for the next
     * scale-out activity.
     * Application Auto Scaling provides a default value of 600 for Amazon ElastiCache replication groups
     * and a default value of 300 for the following scalable targets:
     * AppStream 2.0 fleets
     * Aurora DB clusters
     * ECS services
     * EMR clusters
     * Neptune clusters
     * SageMaker endpoint variants
     * Spot Fleets
     * Custom resources
     * For all other scalable targets, the default value is 0:
     * Amazon Comprehend document classification and entity recognizer endpoints
     * DynamoDB tables and global secondary indexes
     * Amazon Keyspaces tables
     * Lambda provisioned concurrency
     * Amazon MSK broker storage
     */
    val scaleOutCooldown: Int? = builder.scaleOutCooldown
    /**
     * The target value for the metric. Although this property accepts numbers of type Double,
     * it won't accept values that are either too small or too large. Values must be in the range
     * of -2^360 to 2^360. The value must be a valid number based on the choice of metric. For
     * example, if the metric is CPU utilization, then the target value is a percent value that
     * represents how much of the CPU can be used before scaling out.
     */
    val targetValue: Double? = builder.targetValue

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): TargetTrackingScalingPolicyConfiguration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("TargetTrackingScalingPolicyConfiguration(")
        append("customizedMetricSpecification=$customizedMetricSpecification,")
        append("disableScaleIn=$disableScaleIn,")
        append("predefinedMetricSpecification=$predefinedMetricSpecification,")
        append("scaleInCooldown=$scaleInCooldown,")
        append("scaleOutCooldown=$scaleOutCooldown,")
        append("targetValue=$targetValue)")
    }

    override fun hashCode(): kotlin.Int {
        var result = customizedMetricSpecification?.hashCode() ?: 0
        result = 31 * result + (disableScaleIn?.hashCode() ?: 0)
        result = 31 * result + (predefinedMetricSpecification?.hashCode() ?: 0)
        result = 31 * result + (scaleInCooldown ?: 0)
        result = 31 * result + (scaleOutCooldown ?: 0)
        result = 31 * result + (targetValue?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as TargetTrackingScalingPolicyConfiguration

        if (customizedMetricSpecification != other.customizedMetricSpecification) return false
        if (disableScaleIn != other.disableScaleIn) return false
        if (predefinedMetricSpecification != other.predefinedMetricSpecification) return false
        if (scaleInCooldown != other.scaleInCooldown) return false
        if (scaleOutCooldown != other.scaleOutCooldown) return false
        if (targetValue != other.targetValue) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): TargetTrackingScalingPolicyConfiguration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): TargetTrackingScalingPolicyConfiguration
        /**
         * A customized metric. You can specify either a predefined metric or a customized
         * metric.
         */
        fun customizedMetricSpecification(customizedMetricSpecification: CustomizedMetricSpecification): FluentBuilder
        /**
         * Indicates whether scale in by the target tracking scaling policy is disabled. If the
         * value is true, scale in is disabled and the target tracking scaling policy
         * won't remove capacity from the scalable target. Otherwise, scale in is enabled and the
         * target tracking scaling policy can remove capacity from the scalable target. The default
         * value is false.
         */
        fun disableScaleIn(disableScaleIn: Boolean): FluentBuilder
        /**
         * A predefined metric. You can specify either a predefined metric or a customized
         * metric.
         */
        fun predefinedMetricSpecification(predefinedMetricSpecification: PredefinedMetricSpecification): FluentBuilder
        /**
         * The amount of time, in seconds, after a scale-in activity completes before another
         * scale-in activity can start.
         * With the scale-in cooldown period, the intention is to scale in
         * conservatively to protect your application’s availability, so scale-in activities are blocked
         * until the cooldown period has expired. However, if another alarm triggers a scale-out activity
         * during the scale-in cooldown period, Application Auto Scaling scales out the target immediately. In this case,
         * the scale-in cooldown period stops and doesn't complete.
         * Application Auto Scaling provides a default value of 600 for Amazon ElastiCache replication groups
         * and a default value of 300 for the following scalable targets:
         * AppStream 2.0 fleets
         * Aurora DB clusters
         * ECS services
         * EMR clusters
         * Neptune clusters
         * SageMaker endpoint variants
         * Spot Fleets
         * Custom resources
         * For all other scalable targets, the default value is 0:
         * Amazon Comprehend document classification and entity recognizer endpoints
         * DynamoDB tables and global secondary indexes
         * Amazon Keyspaces tables
         * Lambda provisioned concurrency
         * Amazon MSK broker storage
         */
        fun scaleInCooldown(scaleInCooldown: Int): FluentBuilder
        /**
         * The amount of time, in seconds, to wait for a previous scale-out activity to take
         * effect.
         * With the scale-out cooldown period, the intention is to continuously
         * (but not excessively) scale out. After Application Auto Scaling successfully scales out using a target
         * tracking scaling policy, it starts to calculate the cooldown time. The scaling policy won't
         * increase the desired capacity again unless either a larger scale out is triggered or the
         * cooldown period ends. While the cooldown period is in effect, the capacity added by the
         * initiating scale-out activity is calculated as part of the desired capacity for the next
         * scale-out activity.
         * Application Auto Scaling provides a default value of 600 for Amazon ElastiCache replication groups
         * and a default value of 300 for the following scalable targets:
         * AppStream 2.0 fleets
         * Aurora DB clusters
         * ECS services
         * EMR clusters
         * Neptune clusters
         * SageMaker endpoint variants
         * Spot Fleets
         * Custom resources
         * For all other scalable targets, the default value is 0:
         * Amazon Comprehend document classification and entity recognizer endpoints
         * DynamoDB tables and global secondary indexes
         * Amazon Keyspaces tables
         * Lambda provisioned concurrency
         * Amazon MSK broker storage
         */
        fun scaleOutCooldown(scaleOutCooldown: Int): FluentBuilder
        /**
         * The target value for the metric. Although this property accepts numbers of type Double,
         * it won't accept values that are either too small or too large. Values must be in the range
         * of -2^360 to 2^360. The value must be a valid number based on the choice of metric. For
         * example, if the metric is CPU utilization, then the target value is a percent value that
         * represents how much of the CPU can be used before scaling out.
         */
        fun targetValue(targetValue: Double): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A customized metric. You can specify either a predefined metric or a customized
         * metric.
         */
        var customizedMetricSpecification: CustomizedMetricSpecification?
        /**
         * Indicates whether scale in by the target tracking scaling policy is disabled. If the
         * value is true, scale in is disabled and the target tracking scaling policy
         * won't remove capacity from the scalable target. Otherwise, scale in is enabled and the
         * target tracking scaling policy can remove capacity from the scalable target. The default
         * value is false.
         */
        var disableScaleIn: Boolean?
        /**
         * A predefined metric. You can specify either a predefined metric or a customized
         * metric.
         */
        var predefinedMetricSpecification: PredefinedMetricSpecification?
        /**
         * The amount of time, in seconds, after a scale-in activity completes before another
         * scale-in activity can start.
         * With the scale-in cooldown period, the intention is to scale in
         * conservatively to protect your application’s availability, so scale-in activities are blocked
         * until the cooldown period has expired. However, if another alarm triggers a scale-out activity
         * during the scale-in cooldown period, Application Auto Scaling scales out the target immediately. In this case,
         * the scale-in cooldown period stops and doesn't complete.
         * Application Auto Scaling provides a default value of 600 for Amazon ElastiCache replication groups
         * and a default value of 300 for the following scalable targets:
         * AppStream 2.0 fleets
         * Aurora DB clusters
         * ECS services
         * EMR clusters
         * Neptune clusters
         * SageMaker endpoint variants
         * Spot Fleets
         * Custom resources
         * For all other scalable targets, the default value is 0:
         * Amazon Comprehend document classification and entity recognizer endpoints
         * DynamoDB tables and global secondary indexes
         * Amazon Keyspaces tables
         * Lambda provisioned concurrency
         * Amazon MSK broker storage
         */
        var scaleInCooldown: Int?
        /**
         * The amount of time, in seconds, to wait for a previous scale-out activity to take
         * effect.
         * With the scale-out cooldown period, the intention is to continuously
         * (but not excessively) scale out. After Application Auto Scaling successfully scales out using a target
         * tracking scaling policy, it starts to calculate the cooldown time. The scaling policy won't
         * increase the desired capacity again unless either a larger scale out is triggered or the
         * cooldown period ends. While the cooldown period is in effect, the capacity added by the
         * initiating scale-out activity is calculated as part of the desired capacity for the next
         * scale-out activity.
         * Application Auto Scaling provides a default value of 600 for Amazon ElastiCache replication groups
         * and a default value of 300 for the following scalable targets:
         * AppStream 2.0 fleets
         * Aurora DB clusters
         * ECS services
         * EMR clusters
         * Neptune clusters
         * SageMaker endpoint variants
         * Spot Fleets
         * Custom resources
         * For all other scalable targets, the default value is 0:
         * Amazon Comprehend document classification and entity recognizer endpoints
         * DynamoDB tables and global secondary indexes
         * Amazon Keyspaces tables
         * Lambda provisioned concurrency
         * Amazon MSK broker storage
         */
        var scaleOutCooldown: Int?
        /**
         * The target value for the metric. Although this property accepts numbers of type Double,
         * it won't accept values that are either too small or too large. Values must be in the range
         * of -2^360 to 2^360. The value must be a valid number based on the choice of metric. For
         * example, if the metric is CPU utilization, then the target value is a percent value that
         * represents how much of the CPU can be used before scaling out.
         */
        var targetValue: Double?

        fun build(): TargetTrackingScalingPolicyConfiguration
        /**
         * construct an [aws.sdk.kotlin.services.applicationautoscaling.model.CustomizedMetricSpecification] inside the given [block]
         */
        fun customizedMetricSpecification(block: CustomizedMetricSpecification.DslBuilder.() -> kotlin.Unit) {
            this.customizedMetricSpecification = CustomizedMetricSpecification.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.applicationautoscaling.model.PredefinedMetricSpecification] inside the given [block]
         */
        fun predefinedMetricSpecification(block: PredefinedMetricSpecification.DslBuilder.() -> kotlin.Unit) {
            this.predefinedMetricSpecification = PredefinedMetricSpecification.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var customizedMetricSpecification: CustomizedMetricSpecification? = null
        override var disableScaleIn: Boolean? = null
        override var predefinedMetricSpecification: PredefinedMetricSpecification? = null
        override var scaleInCooldown: Int? = null
        override var scaleOutCooldown: Int? = null
        override var targetValue: Double? = null

        constructor(x: TargetTrackingScalingPolicyConfiguration) : this() {
            this.customizedMetricSpecification = x.customizedMetricSpecification
            this.disableScaleIn = x.disableScaleIn
            this.predefinedMetricSpecification = x.predefinedMetricSpecification
            this.scaleInCooldown = x.scaleInCooldown
            this.scaleOutCooldown = x.scaleOutCooldown
            this.targetValue = x.targetValue
        }

        override fun build(): TargetTrackingScalingPolicyConfiguration = TargetTrackingScalingPolicyConfiguration(this)
        override fun customizedMetricSpecification(customizedMetricSpecification: CustomizedMetricSpecification): FluentBuilder = apply { this.customizedMetricSpecification = customizedMetricSpecification }
        override fun disableScaleIn(disableScaleIn: Boolean): FluentBuilder = apply { this.disableScaleIn = disableScaleIn }
        override fun predefinedMetricSpecification(predefinedMetricSpecification: PredefinedMetricSpecification): FluentBuilder = apply { this.predefinedMetricSpecification = predefinedMetricSpecification }
        override fun scaleInCooldown(scaleInCooldown: Int): FluentBuilder = apply { this.scaleInCooldown = scaleInCooldown }
        override fun scaleOutCooldown(scaleOutCooldown: Int): FluentBuilder = apply { this.scaleOutCooldown = scaleOutCooldown }
        override fun targetValue(targetValue: Double): FluentBuilder = apply { this.targetValue = targetValue }
    }
}
