// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationdiscoveryservice.model



/**
 * Information about agents or connectors associated with the user’s Amazon Web Services account. Information includes agent or connector IDs, IP addresses, media access control (MAC) addresses, agent or connector health, hostname where the agent or connector resides, and agent version for each agent.
 */
class AgentInfo private constructor(builder: Builder) {
    /**
     * The agent or connector ID.
     */
    val agentId: kotlin.String? = builder.agentId
    /**
     * Network details about the host where the agent or connector resides.
     */
    val agentNetworkInfoList: List<AgentNetworkInfo>? = builder.agentNetworkInfoList
    /**
     * Type of agent.
     */
    val agentType: kotlin.String? = builder.agentType
    /**
     * Status of the collection process for an agent or connector.
     */
    val collectionStatus: kotlin.String? = builder.collectionStatus
    /**
     * The ID of the connector.
     */
    val connectorId: kotlin.String? = builder.connectorId
    /**
     * The health of the agent or connector.
     */
    val health: aws.sdk.kotlin.services.applicationdiscoveryservice.model.AgentStatus? = builder.health
    /**
     * The name of the host where the agent or connector resides. The host can be a server or virtual machine.
     */
    val hostName: kotlin.String? = builder.hostName
    /**
     * Time since agent or connector health was reported.
     */
    val lastHealthPingTime: kotlin.String? = builder.lastHealthPingTime
    /**
     * Agent's first registration timestamp in UTC.
     */
    val registeredTime: kotlin.String? = builder.registeredTime
    /**
     * The agent or connector version.
     */
    val version: kotlin.String? = builder.version

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.applicationdiscoveryservice.model.AgentInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AgentInfo(")
        append("agentId=$agentId,")
        append("agentNetworkInfoList=$agentNetworkInfoList,")
        append("agentType=$agentType,")
        append("collectionStatus=$collectionStatus,")
        append("connectorId=$connectorId,")
        append("health=$health,")
        append("hostName=$hostName,")
        append("lastHealthPingTime=$lastHealthPingTime,")
        append("registeredTime=$registeredTime,")
        append("version=$version)")
    }

    override fun hashCode(): kotlin.Int {
        var result = agentId?.hashCode() ?: 0
        result = 31 * result + (agentNetworkInfoList?.hashCode() ?: 0)
        result = 31 * result + (agentType?.hashCode() ?: 0)
        result = 31 * result + (collectionStatus?.hashCode() ?: 0)
        result = 31 * result + (connectorId?.hashCode() ?: 0)
        result = 31 * result + (health?.hashCode() ?: 0)
        result = 31 * result + (hostName?.hashCode() ?: 0)
        result = 31 * result + (lastHealthPingTime?.hashCode() ?: 0)
        result = 31 * result + (registeredTime?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AgentInfo

        if (agentId != other.agentId) return false
        if (agentNetworkInfoList != other.agentNetworkInfoList) return false
        if (agentType != other.agentType) return false
        if (collectionStatus != other.collectionStatus) return false
        if (connectorId != other.connectorId) return false
        if (health != other.health) return false
        if (hostName != other.hostName) return false
        if (lastHealthPingTime != other.lastHealthPingTime) return false
        if (registeredTime != other.registeredTime) return false
        if (version != other.version) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.applicationdiscoveryservice.model.AgentInfo = Builder(this).apply(block).build()

    class Builder {
        /**
         * The agent or connector ID.
         */
        var agentId: kotlin.String? = null
        /**
         * Network details about the host where the agent or connector resides.
         */
        var agentNetworkInfoList: List<AgentNetworkInfo>? = null
        /**
         * Type of agent.
         */
        var agentType: kotlin.String? = null
        /**
         * Status of the collection process for an agent or connector.
         */
        var collectionStatus: kotlin.String? = null
        /**
         * The ID of the connector.
         */
        var connectorId: kotlin.String? = null
        /**
         * The health of the agent or connector.
         */
        var health: aws.sdk.kotlin.services.applicationdiscoveryservice.model.AgentStatus? = null
        /**
         * The name of the host where the agent or connector resides. The host can be a server or virtual machine.
         */
        var hostName: kotlin.String? = null
        /**
         * Time since agent or connector health was reported.
         */
        var lastHealthPingTime: kotlin.String? = null
        /**
         * Agent's first registration timestamp in UTC.
         */
        var registeredTime: kotlin.String? = null
        /**
         * The agent or connector version.
         */
        var version: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.applicationdiscoveryservice.model.AgentInfo) : this() {
            this.agentId = x.agentId
            this.agentNetworkInfoList = x.agentNetworkInfoList
            this.agentType = x.agentType
            this.collectionStatus = x.collectionStatus
            this.connectorId = x.connectorId
            this.health = x.health
            this.hostName = x.hostName
            this.lastHealthPingTime = x.lastHealthPingTime
            this.registeredTime = x.registeredTime
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.applicationdiscoveryservice.model.AgentInfo = AgentInfo(this)
    }
}
