// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationdiscoveryservice.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information regarding the export status of discovered data. The value is an array of objects.
 */
class ExportInfo private constructor(builder: Builder) {
    /**
     * A URL for an Amazon S3 bucket where you can review the exported data. The URL is displayed only if the export succeeded.
     */
    val configurationsDownloadUrl: kotlin.String? = builder.configurationsDownloadUrl
    /**
     * A unique identifier used to query an export.
     */
    val exportId: kotlin.String? = builder.exportId
    /**
     * The time that the data export was initiated.
     */
    val exportRequestTime: aws.smithy.kotlin.runtime.time.Instant? = builder.exportRequestTime
    /**
     * The status of the data export job.
     */
    val exportStatus: aws.sdk.kotlin.services.applicationdiscoveryservice.model.ExportStatus? = builder.exportStatus
    /**
     * If true, the export of agent information exceeded the size limit for a single export and the exported data is incomplete for the requested time range. To address this, select a smaller time range for the export by using `startDate` and `endDate`.
     */
    val isTruncated: kotlin.Boolean = builder.isTruncated
    /**
     * The `endTime` used in the `StartExportTask` request. If no `endTime` was requested, this result does not appear in `ExportInfo`.
     */
    val requestedEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.requestedEndTime
    /**
     * The value of `startTime` parameter in the `StartExportTask` request. If no `startTime` was requested, this result does not appear in `ExportInfo`.
     */
    val requestedStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.requestedStartTime
    /**
     * A status message provided for API callers.
     */
    val statusMessage: kotlin.String? = builder.statusMessage

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.applicationdiscoveryservice.model.ExportInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExportInfo(")
        append("configurationsDownloadUrl=$configurationsDownloadUrl,")
        append("exportId=$exportId,")
        append("exportRequestTime=$exportRequestTime,")
        append("exportStatus=$exportStatus,")
        append("isTruncated=$isTruncated,")
        append("requestedEndTime=$requestedEndTime,")
        append("requestedStartTime=$requestedStartTime,")
        append("statusMessage=$statusMessage)")
    }

    override fun hashCode(): kotlin.Int {
        var result = configurationsDownloadUrl?.hashCode() ?: 0
        result = 31 * result + (exportId?.hashCode() ?: 0)
        result = 31 * result + (exportRequestTime?.hashCode() ?: 0)
        result = 31 * result + (exportStatus?.hashCode() ?: 0)
        result = 31 * result + (isTruncated.hashCode())
        result = 31 * result + (requestedEndTime?.hashCode() ?: 0)
        result = 31 * result + (requestedStartTime?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExportInfo

        if (configurationsDownloadUrl != other.configurationsDownloadUrl) return false
        if (exportId != other.exportId) return false
        if (exportRequestTime != other.exportRequestTime) return false
        if (exportStatus != other.exportStatus) return false
        if (isTruncated != other.isTruncated) return false
        if (requestedEndTime != other.requestedEndTime) return false
        if (requestedStartTime != other.requestedStartTime) return false
        if (statusMessage != other.statusMessage) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.applicationdiscoveryservice.model.ExportInfo = Builder(this).apply(block).build()

    class Builder {
        /**
         * A URL for an Amazon S3 bucket where you can review the exported data. The URL is displayed only if the export succeeded.
         */
        var configurationsDownloadUrl: kotlin.String? = null
        /**
         * A unique identifier used to query an export.
         */
        var exportId: kotlin.String? = null
        /**
         * The time that the data export was initiated.
         */
        var exportRequestTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the data export job.
         */
        var exportStatus: aws.sdk.kotlin.services.applicationdiscoveryservice.model.ExportStatus? = null
        /**
         * If true, the export of agent information exceeded the size limit for a single export and the exported data is incomplete for the requested time range. To address this, select a smaller time range for the export by using `startDate` and `endDate`.
         */
        var isTruncated: kotlin.Boolean = false
        /**
         * The `endTime` used in the `StartExportTask` request. If no `endTime` was requested, this result does not appear in `ExportInfo`.
         */
        var requestedEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The value of `startTime` parameter in the `StartExportTask` request. If no `startTime` was requested, this result does not appear in `ExportInfo`.
         */
        var requestedStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A status message provided for API callers.
         */
        var statusMessage: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.applicationdiscoveryservice.model.ExportInfo) : this() {
            this.configurationsDownloadUrl = x.configurationsDownloadUrl
            this.exportId = x.exportId
            this.exportRequestTime = x.exportRequestTime
            this.exportStatus = x.exportStatus
            this.isTruncated = x.isTruncated
            this.requestedEndTime = x.requestedEndTime
            this.requestedStartTime = x.requestedStartTime
            this.statusMessage = x.statusMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.applicationdiscoveryservice.model.ExportInfo = ExportInfo(this)
    }
}
