// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationdiscoveryservice.model



/**
 * Indicates that the exported data must include EC2 instance type matches for on-premises servers that are discovered through Amazon Web Services Application Discovery Service.
 */
public class Ec2RecommendationsExportPreferences private constructor(builder: Builder) {
    /**
     * The recommended EC2 instance type that matches the CPU usage metric of server performance data.
     */
    public val cpuPerformanceMetricBasis: aws.sdk.kotlin.services.applicationdiscoveryservice.model.UsageMetricBasis? = builder.cpuPerformanceMetricBasis
    /**
     * If set to true, the export [preferences](https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartExportTask.html#API_StartExportTask_RequestSyntax) is set to `Ec2RecommendationsExportPreferences`.
     */
    public val enabled: kotlin.Boolean = builder.enabled
    /**
     * An array of instance types to exclude from recommendations.
     */
    public val excludedInstanceTypes: List<String>? = builder.excludedInstanceTypes
    /**
     * The target Amazon Web Services Region for the recommendations. You can use any of the Region codes available for the chosen service, as listed in [Amazon Web Services service endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html) in the *Amazon Web Services General Reference*.
     */
    public val preferredRegion: kotlin.String? = builder.preferredRegion
    /**
     * The recommended EC2 instance type that matches the Memory usage metric of server performance data.
     */
    public val ramPerformanceMetricBasis: aws.sdk.kotlin.services.applicationdiscoveryservice.model.UsageMetricBasis? = builder.ramPerformanceMetricBasis
    /**
     * The contract type for a reserved instance. If blank, we assume an On-Demand instance is preferred.
     */
    public val reservedInstanceOptions: aws.sdk.kotlin.services.applicationdiscoveryservice.model.ReservedInstanceOptions? = builder.reservedInstanceOptions
    /**
     * The target tenancy to use for your recommended EC2 instances.
     */
    public val tenancy: aws.sdk.kotlin.services.applicationdiscoveryservice.model.Tenancy? = builder.tenancy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.applicationdiscoveryservice.model.Ec2RecommendationsExportPreferences = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Ec2RecommendationsExportPreferences(")
        append("cpuPerformanceMetricBasis=$cpuPerformanceMetricBasis,")
        append("enabled=$enabled,")
        append("excludedInstanceTypes=$excludedInstanceTypes,")
        append("preferredRegion=$preferredRegion,")
        append("ramPerformanceMetricBasis=$ramPerformanceMetricBasis,")
        append("reservedInstanceOptions=$reservedInstanceOptions,")
        append("tenancy=$tenancy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cpuPerformanceMetricBasis?.hashCode() ?: 0
        result = 31 * result + (enabled.hashCode())
        result = 31 * result + (excludedInstanceTypes?.hashCode() ?: 0)
        result = 31 * result + (preferredRegion?.hashCode() ?: 0)
        result = 31 * result + (ramPerformanceMetricBasis?.hashCode() ?: 0)
        result = 31 * result + (reservedInstanceOptions?.hashCode() ?: 0)
        result = 31 * result + (tenancy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Ec2RecommendationsExportPreferences

        if (cpuPerformanceMetricBasis != other.cpuPerformanceMetricBasis) return false
        if (enabled != other.enabled) return false
        if (excludedInstanceTypes != other.excludedInstanceTypes) return false
        if (preferredRegion != other.preferredRegion) return false
        if (ramPerformanceMetricBasis != other.ramPerformanceMetricBasis) return false
        if (reservedInstanceOptions != other.reservedInstanceOptions) return false
        if (tenancy != other.tenancy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.applicationdiscoveryservice.model.Ec2RecommendationsExportPreferences = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The recommended EC2 instance type that matches the CPU usage metric of server performance data.
         */
        public var cpuPerformanceMetricBasis: aws.sdk.kotlin.services.applicationdiscoveryservice.model.UsageMetricBasis? = null
        /**
         * If set to true, the export [preferences](https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartExportTask.html#API_StartExportTask_RequestSyntax) is set to `Ec2RecommendationsExportPreferences`.
         */
        public var enabled: kotlin.Boolean = false
        /**
         * An array of instance types to exclude from recommendations.
         */
        public var excludedInstanceTypes: List<String>? = null
        /**
         * The target Amazon Web Services Region for the recommendations. You can use any of the Region codes available for the chosen service, as listed in [Amazon Web Services service endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html) in the *Amazon Web Services General Reference*.
         */
        public var preferredRegion: kotlin.String? = null
        /**
         * The recommended EC2 instance type that matches the Memory usage metric of server performance data.
         */
        public var ramPerformanceMetricBasis: aws.sdk.kotlin.services.applicationdiscoveryservice.model.UsageMetricBasis? = null
        /**
         * The contract type for a reserved instance. If blank, we assume an On-Demand instance is preferred.
         */
        public var reservedInstanceOptions: aws.sdk.kotlin.services.applicationdiscoveryservice.model.ReservedInstanceOptions? = null
        /**
         * The target tenancy to use for your recommended EC2 instances.
         */
        public var tenancy: aws.sdk.kotlin.services.applicationdiscoveryservice.model.Tenancy? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.applicationdiscoveryservice.model.Ec2RecommendationsExportPreferences) : this() {
            this.cpuPerformanceMetricBasis = x.cpuPerformanceMetricBasis
            this.enabled = x.enabled
            this.excludedInstanceTypes = x.excludedInstanceTypes
            this.preferredRegion = x.preferredRegion
            this.ramPerformanceMetricBasis = x.ramPerformanceMetricBasis
            this.reservedInstanceOptions = x.reservedInstanceOptions
            this.tenancy = x.tenancy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.applicationdiscoveryservice.model.Ec2RecommendationsExportPreferences = Ec2RecommendationsExportPreferences(this)

        /**
         * construct an [aws.sdk.kotlin.services.applicationdiscoveryservice.model.UsageMetricBasis] inside the given [block]
         */
        public fun cpuPerformanceMetricBasis(block: aws.sdk.kotlin.services.applicationdiscoveryservice.model.UsageMetricBasis.Builder.() -> kotlin.Unit) {
            this.cpuPerformanceMetricBasis = aws.sdk.kotlin.services.applicationdiscoveryservice.model.UsageMetricBasis.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.applicationdiscoveryservice.model.UsageMetricBasis] inside the given [block]
         */
        public fun ramPerformanceMetricBasis(block: aws.sdk.kotlin.services.applicationdiscoveryservice.model.UsageMetricBasis.Builder.() -> kotlin.Unit) {
            this.ramPerformanceMetricBasis = aws.sdk.kotlin.services.applicationdiscoveryservice.model.UsageMetricBasis.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.applicationdiscoveryservice.model.ReservedInstanceOptions] inside the given [block]
         */
        public fun reservedInstanceOptions(block: aws.sdk.kotlin.services.applicationdiscoveryservice.model.ReservedInstanceOptions.Builder.() -> kotlin.Unit) {
            this.reservedInstanceOptions = aws.sdk.kotlin.services.applicationdiscoveryservice.model.ReservedInstanceOptions.invoke(block)
        }
    }
}
