// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationdiscoveryservice.transform

import aws.sdk.kotlin.services.applicationdiscoveryservice.model.ApplicationDiscoveryException
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.CustomerAgentInfo
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.CustomerAgentlessCollectorInfo
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.CustomerConnectorInfo
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.CustomerMeCollectorInfo
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.GetDiscoverySummaryResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetDiscoverySummaryOperationDeserializer: HttpDeserialize<GetDiscoverySummaryResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetDiscoverySummaryResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetDiscoverySummaryError(context, call)
        }
        val builder = GetDiscoverySummaryResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetDiscoverySummaryOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetDiscoverySummaryError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ApplicationDiscoveryException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AuthorizationErrorException" -> AuthorizationErrorExceptionDeserializer().deserialize(context, wrappedCall)
        "HomeRegionNotSetException" -> HomeRegionNotSetExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall)
        "ServerInternalErrorException" -> ServerInternalErrorExceptionDeserializer().deserialize(context, wrappedCall)
        else -> ApplicationDiscoveryException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetDiscoverySummaryOperationBody(builder: GetDiscoverySummaryResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AGENTSUMMARY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("agentSummary"))
    val AGENTLESSCOLLECTORSUMMARY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("agentlessCollectorSummary"))
    val APPLICATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("applications"))
    val CONNECTORSUMMARY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("connectorSummary"))
    val MECOLLECTORSUMMARY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("meCollectorSummary"))
    val SERVERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("servers"))
    val SERVERSMAPPEDTOAPPLICATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("serversMappedToApplications"))
    val SERVERSMAPPEDTOTAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("serversMappedtoTags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AGENTSUMMARY_DESCRIPTOR)
        field(AGENTLESSCOLLECTORSUMMARY_DESCRIPTOR)
        field(APPLICATIONS_DESCRIPTOR)
        field(CONNECTORSUMMARY_DESCRIPTOR)
        field(MECOLLECTORSUMMARY_DESCRIPTOR)
        field(SERVERS_DESCRIPTOR)
        field(SERVERSMAPPEDTOAPPLICATIONS_DESCRIPTOR)
        field(SERVERSMAPPEDTOTAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AGENTSUMMARY_DESCRIPTOR.index -> builder.agentSummary = deserializeCustomerAgentInfoDocument(deserializer)
                AGENTLESSCOLLECTORSUMMARY_DESCRIPTOR.index -> builder.agentlessCollectorSummary = deserializeCustomerAgentlessCollectorInfoDocument(deserializer)
                APPLICATIONS_DESCRIPTOR.index -> builder.applications = deserializeLong()
                CONNECTORSUMMARY_DESCRIPTOR.index -> builder.connectorSummary = deserializeCustomerConnectorInfoDocument(deserializer)
                MECOLLECTORSUMMARY_DESCRIPTOR.index -> builder.meCollectorSummary = deserializeCustomerMeCollectorInfoDocument(deserializer)
                SERVERS_DESCRIPTOR.index -> builder.servers = deserializeLong()
                SERVERSMAPPEDTOAPPLICATIONS_DESCRIPTOR.index -> builder.serversMappedToApplications = deserializeLong()
                SERVERSMAPPEDTOTAGS_DESCRIPTOR.index -> builder.serversMappedtoTags = deserializeLong()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
