// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationdiscoveryservice.model



/**
 * An object representing the agent or data collector to be deleted along with the optional configurations for error handling.
 */
public class DeleteAgent private constructor(builder: Builder) {
    /**
     * The ID of the agent or data collector to delete.
     */
    public val agentId: kotlin.String = requireNotNull(builder.agentId) { "A non-null value must be provided for agentId" }
    /**
     * Optional flag used to force delete an agent or data collector. It is needed to delete any agent in HEALTHY/UNHEALTHY/RUNNING status. Note that deleting an agent that is actively reporting health causes it to be re-registered with a different agent ID after data collector re-connects with Amazon Web Services.
     */
    public val force: kotlin.Boolean = builder.force

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.applicationdiscoveryservice.model.DeleteAgent = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteAgent(")
        append("agentId=$agentId,")
        append("force=$force")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = agentId.hashCode()
        result = 31 * result + (force.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteAgent

        if (agentId != other.agentId) return false
        if (force != other.force) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.applicationdiscoveryservice.model.DeleteAgent = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the agent or data collector to delete.
         */
        public var agentId: kotlin.String? = null
        /**
         * Optional flag used to force delete an agent or data collector. It is needed to delete any agent in HEALTHY/UNHEALTHY/RUNNING status. Note that deleting an agent that is actively reporting health causes it to be re-registered with a different agent ID after data collector re-connects with Amazon Web Services.
         */
        public var force: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.applicationdiscoveryservice.model.DeleteAgent) : this() {
            this.agentId = x.agentId
            this.force = x.force
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.applicationdiscoveryservice.model.DeleteAgent = DeleteAgent(this)

        internal fun correctErrors(): Builder {
            if (agentId == null) agentId = ""
            return this
        }
    }
}
