// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationdiscoveryservice

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.applicationdiscoveryservice.auth.ApplicationDiscoveryAuthSchemeProvider
import aws.sdk.kotlin.services.applicationdiscoveryservice.auth.DefaultApplicationDiscoveryAuthSchemeProvider
import aws.sdk.kotlin.services.applicationdiscoveryservice.endpoints.ApplicationDiscoveryEndpointParameters
import aws.sdk.kotlin.services.applicationdiscoveryservice.endpoints.ApplicationDiscoveryEndpointProvider
import aws.sdk.kotlin.services.applicationdiscoveryservice.endpoints.DefaultApplicationDiscoveryEndpointProvider
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.AssociateConfigurationItemsToApplicationRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.AssociateConfigurationItemsToApplicationResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.BatchDeleteAgentsRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.BatchDeleteAgentsResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.BatchDeleteImportDataRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.BatchDeleteImportDataResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.CreateApplicationRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.CreateApplicationResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.CreateTagsRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.CreateTagsResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DeleteApplicationsRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DeleteApplicationsResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DeleteTagsRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DeleteTagsResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeAgentsRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeAgentsResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeBatchDeleteConfigurationTaskRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeBatchDeleteConfigurationTaskResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeConfigurationsRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeConfigurationsResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeContinuousExportsRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeContinuousExportsResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeExportConfigurationsRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeExportConfigurationsResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeExportTasksRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeExportTasksResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeImportTasksRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeImportTasksResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeTagsRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeTagsResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DisassociateConfigurationItemsFromApplicationRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DisassociateConfigurationItemsFromApplicationResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.ExportConfigurationsRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.ExportConfigurationsResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.GetDiscoverySummaryRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.GetDiscoverySummaryResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.ListConfigurationsRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.ListConfigurationsResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.ListServerNeighborsRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.ListServerNeighborsResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.StartBatchDeleteConfigurationTaskRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.StartBatchDeleteConfigurationTaskResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.StartContinuousExportRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.StartContinuousExportResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.StartDataCollectionByAgentIdsRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.StartDataCollectionByAgentIdsResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.StartExportTaskRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.StartExportTaskResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.StartImportTaskRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.StartImportTaskResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.StopContinuousExportRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.StopContinuousExportResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.StopDataCollectionByAgentIdsRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.StopDataCollectionByAgentIdsResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.UpdateApplicationRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.UpdateApplicationResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Application Discovery Service"
public const val SdkVersion: String = "0.34.8-beta"

/**
 * # Amazon Web Services Application Discovery Service
 * Amazon Web Services Application Discovery Service (Application Discovery Service) helps you plan application migration projects. It automatically identifies servers, virtual machines (VMs), and network dependencies in your on-premises data centers. For more information, see the [Amazon Web Services Application Discovery Service FAQ](http://aws.amazon.com/application-discovery/faqs/).
 *
 * Application Discovery Service offers three ways of performing discovery and collecting data about your on-premises servers:
 * + **Agentless discovery** using Amazon Web Services Application Discovery Service Agentless Collector (Agentless Collector), which doesn't require you to install an agent on each host.
 *    + Agentless Collector gathers server information regardless of the operating systems, which minimizes the time required for initial on-premises infrastructure assessment.
 *    + Agentless Collector doesn't collect information about network dependencies, only agent-based discovery collects that information.
 *
 * + **Agent-based discovery** using the Amazon Web Services Application Discovery Agent (Application Discovery Agent) collects a richer set of data than agentless discovery, which you install on one or more hosts in your data center.
 *    +  The agent captures infrastructure and application information, including an inventory of running processes, system performance information, resource utilization, and network dependencies.
 *    + The information collected by agents is secured at rest and in transit to the Application Discovery Service database in the Amazon Web Services cloud. For more information, see [Amazon Web Services Application Discovery Agent](https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-agent.html).
 *
 * + **Amazon Web Services Partner Network (APN) solutions** integrate with Application Discovery Service, enabling you to import details of your on-premises environment directly into Amazon Web Services Migration Hub (Migration Hub) without using Agentless Collector or Application Discovery Agent.
 *    + Third-party application discovery tools can query Amazon Web Services Application Discovery Service, and they can write to the Application Discovery Service database using the public API.
 *    + In this way, you can import data into Migration Hub and view it, so that you can associate applications with servers and track migrations.
 *
 * **Working With This Guide**
 *
 * This API reference provides descriptions, syntax, and usage examples for each of the actions and data types for Application Discovery Service. The topic for each action shows the API request parameters and the response. Alternatively, you can use one of the Amazon Web Services SDKs to access an API that is tailored to the programming language or platform that you're using. For more information, see [Amazon Web Services SDKs](http://aws.amazon.com/tools/#SDKs).
 *
 * + Remember that you must set your Migration Hub home Region before you call any of these APIs.
 * + You must make API calls for write actions (create, notify, associate, disassociate, import, or put) while in your home Region, or a `HomeRegionNotSetException` error is returned.
 * + API calls for read actions (list, describe, stop, and delete) are permitted outside of your home Region.
 * + Although it is unlikely, the Migration Hub home Region could change. If you call APIs outside the home Region, an `InvalidInputException` is returned.
 * + You must call `GetHomeRegion` to obtain the latest Migration Hub home Region.
 * This guide is intended for use with the [Amazon Web Services Application Discovery Service User Guide](https://docs.aws.amazon.com/application-discovery/latest/userguide/).
 *
 * All data is handled according to the [Amazon Web Services Privacy Policy](https://aws.amazon.com/privacy/). You can operate Application Discovery Service offline to inspect collected data before it is shared with the service.
 */
public interface ApplicationDiscoveryClient : SdkClient {
    /**
     * ApplicationDiscoveryClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, ApplicationDiscoveryClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>) {
            builder.config.interceptors.add(0, ClockSkewInterceptor())
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "ApplicationDiscovery",
                "APPLICATION_DISCOVERY_SERVICE",
                "application_discovery_service",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, ApplicationDiscoveryClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): ApplicationDiscoveryClient = DefaultApplicationDiscoveryClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: ApplicationDiscoveryEndpointProvider = builder.endpointProvider ?: DefaultApplicationDiscoveryEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsDefaultRetryPolicy
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: ApplicationDiscoveryAuthSchemeProvider = builder.authSchemeProvider ?: DefaultApplicationDiscoveryAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Application Discovery Service"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: ApplicationDiscoveryEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: ApplicationDiscoveryAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Associates one or more configuration items with an application.
     */
    public suspend fun associateConfigurationItemsToApplication(input: AssociateConfigurationItemsToApplicationRequest): AssociateConfigurationItemsToApplicationResponse

    /**
     * Deletes one or more agents or collectors as specified by ID. Deleting an agent or collector does not delete the previously discovered data. To delete the data collected, use `StartBatchDeleteConfigurationTask`.
     */
    public suspend fun batchDeleteAgents(input: BatchDeleteAgentsRequest): BatchDeleteAgentsResponse

    /**
     * Deletes one or more import tasks, each identified by their import ID. Each import task has a number of records that can identify servers or applications.
     *
     * Amazon Web Services Application Discovery Service has built-in matching logic that will identify when discovered servers match existing entries that you've previously discovered, the information for the already-existing discovered server is updated. When you delete an import task that contains records that were used to match, the information in those matched records that comes from the deleted records will also be deleted.
     */
    public suspend fun batchDeleteImportData(input: BatchDeleteImportDataRequest): BatchDeleteImportDataResponse

    /**
     * Creates an application with the given name and description.
     */
    public suspend fun createApplication(input: CreateApplicationRequest): CreateApplicationResponse

    /**
     * Creates one or more tags for configuration items. Tags are metadata that help you categorize IT assets. This API accepts a list of multiple configuration items.
     *
     * Do not store sensitive information (like personal data) in tags.
     */
    public suspend fun createTags(input: CreateTagsRequest): CreateTagsResponse

    /**
     * Deletes a list of applications and their associations with configuration items.
     */
    public suspend fun deleteApplications(input: DeleteApplicationsRequest): DeleteApplicationsResponse

    /**
     * Deletes the association between configuration items and one or more tags. This API accepts a list of multiple configuration items.
     */
    public suspend fun deleteTags(input: DeleteTagsRequest): DeleteTagsResponse

    /**
     * Lists agents or collectors as specified by ID or other filters. All agents/collectors associated with your user can be listed if you call `DescribeAgents` as is without passing any parameters.
     */
    public suspend fun describeAgents(input: DescribeAgentsRequest = DescribeAgentsRequest { }): DescribeAgentsResponse

    /**
     * Takes a unique deletion task identifier as input and returns metadata about a configuration deletion task.
     */
    public suspend fun describeBatchDeleteConfigurationTask(input: DescribeBatchDeleteConfigurationTaskRequest): DescribeBatchDeleteConfigurationTaskResponse

    /**
     * Retrieves attributes for a list of configuration item IDs.
     *
     * All of the supplied IDs must be for the same asset type from one of the following:
     * + server
     * + application
     * + process
     * + connection
     * Output fields are specific to the asset type specified. For example, the output for a *server* configuration item includes a list of attributes about the server, such as host name, operating system, number of network cards, etc.
     *
     * For a complete list of outputs for each asset type, see [Using the DescribeConfigurations Action](https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#DescribeConfigurations) in the *Amazon Web Services Application Discovery Service User Guide*.
     */
    public suspend fun describeConfigurations(input: DescribeConfigurationsRequest): DescribeConfigurationsResponse

    /**
     * Lists exports as specified by ID. All continuous exports associated with your user can be listed if you call `DescribeContinuousExports` as is without passing any parameters.
     */
    public suspend fun describeContinuousExports(input: DescribeContinuousExportsRequest = DescribeContinuousExportsRequest { }): DescribeContinuousExportsResponse

    /**
     * `DescribeExportConfigurations` is deprecated. Use [DescribeExportTasks](https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeExportTasks.html), instead.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun describeExportConfigurations(input: DescribeExportConfigurationsRequest = DescribeExportConfigurationsRequest { }): DescribeExportConfigurationsResponse

    /**
     * Retrieve status of one or more export tasks. You can retrieve the status of up to 100 export tasks.
     */
    public suspend fun describeExportTasks(input: DescribeExportTasksRequest = DescribeExportTasksRequest { }): DescribeExportTasksResponse

    /**
     * Returns an array of import tasks for your account, including status information, times, IDs, the Amazon S3 Object URL for the import file, and more.
     */
    public suspend fun describeImportTasks(input: DescribeImportTasksRequest = DescribeImportTasksRequest { }): DescribeImportTasksResponse

    /**
     * Retrieves a list of configuration items that have tags as specified by the key-value pairs, name and value, passed to the optional parameter `filters`.
     *
     * There are three valid tag filter names:
     * + tagKey
     * + tagValue
     * + configurationId
     *
     * Also, all configuration items associated with your user that have tags can be listed if you call `DescribeTags` as is without passing any parameters.
     */
    public suspend fun describeTags(input: DescribeTagsRequest = DescribeTagsRequest { }): DescribeTagsResponse

    /**
     * Disassociates one or more configuration items from an application.
     */
    public suspend fun disassociateConfigurationItemsFromApplication(input: DisassociateConfigurationItemsFromApplicationRequest): DisassociateConfigurationItemsFromApplicationResponse

    /**
     * Deprecated. Use `StartExportTask` instead.
     *
     * Exports all discovered configuration data to an Amazon S3 bucket or an application that enables you to view and evaluate the data. Data includes tags and tag associations, processes, connections, servers, and system performance. This API returns an export ID that you can query using the *DescribeExportConfigurations* API. The system imposes a limit of two configuration exports in six hours.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun exportConfigurations(input: ExportConfigurationsRequest = ExportConfigurationsRequest { }): ExportConfigurationsResponse

    /**
     * Retrieves a short summary of discovered assets.
     *
     * This API operation takes no request parameters and is called as is at the command prompt as shown in the example.
     */
    public suspend fun getDiscoverySummary(input: GetDiscoverySummaryRequest = GetDiscoverySummaryRequest { }): GetDiscoverySummaryResponse

    /**
     * Retrieves a list of configuration items as specified by the value passed to the required parameter `configurationType`. Optional filtering may be applied to refine search results.
     */
    public suspend fun listConfigurations(input: ListConfigurationsRequest): ListConfigurationsResponse

    /**
     * Retrieves a list of servers that are one network hop away from a specified server.
     */
    public suspend fun listServerNeighbors(input: ListServerNeighborsRequest): ListServerNeighborsResponse

    /**
     * Takes a list of configurationId as input and starts an asynchronous deletion task to remove the configurationItems. Returns a unique deletion task identifier.
     */
    public suspend fun startBatchDeleteConfigurationTask(input: StartBatchDeleteConfigurationTaskRequest): StartBatchDeleteConfigurationTaskResponse

    /**
     * Start the continuous flow of agent's discovered data into Amazon Athena.
     */
    public suspend fun startContinuousExport(input: StartContinuousExportRequest = StartContinuousExportRequest { }): StartContinuousExportResponse

    /**
     * Instructs the specified agents to start collecting data.
     */
    public suspend fun startDataCollectionByAgentIds(input: StartDataCollectionByAgentIdsRequest): StartDataCollectionByAgentIdsResponse

    /**
     * Begins the export of a discovered data report to an Amazon S3 bucket managed by Amazon Web Services.
     *
     * Exports might provide an estimate of fees and savings based on certain information that you provide. Fee estimates do not include any taxes that might apply. Your actual fees and savings depend on a variety of factors, including your actual usage of Amazon Web Services services, which might vary from the estimates provided in this report.
     *
     * If you do not specify `preferences` or `agentIds` in the filter, a summary of all servers, applications, tags, and performance is generated. This data is an aggregation of all server data collected through on-premises tooling, file import, application grouping and applying tags.
     *
     * If you specify `agentIds` in a filter, the task exports up to 72 hours of detailed data collected by the identified Application Discovery Agent, including network, process, and performance details. A time range for exported agent data may be set by using `startTime` and `endTime`. Export of detailed agent data is limited to five concurrently running exports. Export of detailed agent data is limited to two exports per day.
     *
     * If you enable `ec2RecommendationsPreferences` in `preferences` , an Amazon EC2 instance matching the characteristics of each server in Application Discovery Service is generated. Changing the attributes of the `ec2RecommendationsPreferences` changes the criteria of the recommendation.
     */
    public suspend fun startExportTask(input: StartExportTaskRequest = StartExportTaskRequest { }): StartExportTaskResponse

    /**
     * Starts an import task, which allows you to import details of your on-premises environment directly into Amazon Web Services Migration Hub without having to use the Amazon Web Services Application Discovery Service (Application Discovery Service) tools such as the Amazon Web Services Application Discovery Service Agentless Collector or Application Discovery Agent. This gives you the option to perform migration assessment and planning directly from your imported data, including the ability to group your devices as applications and track their migration status.
     *
     * To start an import request, do this:
     * + Download the specially formatted comma separated value (CSV) import template, which you can find here: [https://s3.us-west-2.amazonaws.com/templates-7cffcf56-bd96-4b1c-b45b-a5b42f282e46/import_template.csv](https://s3.us-west-2.amazonaws.com/templates-7cffcf56-bd96-4b1c-b45b-a5b42f282e46/import_template.csv).
     * + Fill out the template with your server and application data.
     * + Upload your import file to an Amazon S3 bucket, and make a note of it's Object URL. Your import file must be in the CSV format.
     * + Use the console or the `StartImportTask` command with the Amazon Web Services CLI or one of the Amazon Web Services SDKs to import the records from your file.
     *
     * For more information, including step-by-step procedures, see [Migration Hub Import](https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-import.html) in the *Amazon Web Services Application Discovery Service User Guide*.
     *
     * There are limits to the number of import tasks you can create (and delete) in an Amazon Web Services account. For more information, see [Amazon Web Services Application Discovery Service Limits](https://docs.aws.amazon.com/application-discovery/latest/userguide/ads_service_limits.html) in the *Amazon Web Services Application Discovery Service User Guide*.
     */
    public suspend fun startImportTask(input: StartImportTaskRequest): StartImportTaskResponse

    /**
     * Stop the continuous flow of agent's discovered data into Amazon Athena.
     */
    public suspend fun stopContinuousExport(input: StopContinuousExportRequest): StopContinuousExportResponse

    /**
     * Instructs the specified agents to stop collecting data.
     */
    public suspend fun stopDataCollectionByAgentIds(input: StopDataCollectionByAgentIdsRequest): StopDataCollectionByAgentIdsResponse

    /**
     * Updates metadata about an application.
     */
    public suspend fun updateApplication(input: UpdateApplicationRequest): UpdateApplicationResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun ApplicationDiscoveryClient.withConfig(block: ApplicationDiscoveryClient.Config.Builder.() -> Unit): ApplicationDiscoveryClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultApplicationDiscoveryClient(newConfig)
}

/**
 * Associates one or more configuration items with an application.
 */
public suspend inline fun ApplicationDiscoveryClient.associateConfigurationItemsToApplication(crossinline block: AssociateConfigurationItemsToApplicationRequest.Builder.() -> Unit): AssociateConfigurationItemsToApplicationResponse = associateConfigurationItemsToApplication(AssociateConfigurationItemsToApplicationRequest.Builder().apply(block).build())

/**
 * Deletes one or more agents or collectors as specified by ID. Deleting an agent or collector does not delete the previously discovered data. To delete the data collected, use `StartBatchDeleteConfigurationTask`.
 */
public suspend inline fun ApplicationDiscoveryClient.batchDeleteAgents(crossinline block: BatchDeleteAgentsRequest.Builder.() -> Unit): BatchDeleteAgentsResponse = batchDeleteAgents(BatchDeleteAgentsRequest.Builder().apply(block).build())

/**
 * Deletes one or more import tasks, each identified by their import ID. Each import task has a number of records that can identify servers or applications.
 *
 * Amazon Web Services Application Discovery Service has built-in matching logic that will identify when discovered servers match existing entries that you've previously discovered, the information for the already-existing discovered server is updated. When you delete an import task that contains records that were used to match, the information in those matched records that comes from the deleted records will also be deleted.
 */
public suspend inline fun ApplicationDiscoveryClient.batchDeleteImportData(crossinline block: BatchDeleteImportDataRequest.Builder.() -> Unit): BatchDeleteImportDataResponse = batchDeleteImportData(BatchDeleteImportDataRequest.Builder().apply(block).build())

/**
 * Creates an application with the given name and description.
 */
public suspend inline fun ApplicationDiscoveryClient.createApplication(crossinline block: CreateApplicationRequest.Builder.() -> Unit): CreateApplicationResponse = createApplication(CreateApplicationRequest.Builder().apply(block).build())

/**
 * Creates one or more tags for configuration items. Tags are metadata that help you categorize IT assets. This API accepts a list of multiple configuration items.
 *
 * Do not store sensitive information (like personal data) in tags.
 */
public suspend inline fun ApplicationDiscoveryClient.createTags(crossinline block: CreateTagsRequest.Builder.() -> Unit): CreateTagsResponse = createTags(CreateTagsRequest.Builder().apply(block).build())

/**
 * Deletes a list of applications and their associations with configuration items.
 */
public suspend inline fun ApplicationDiscoveryClient.deleteApplications(crossinline block: DeleteApplicationsRequest.Builder.() -> Unit): DeleteApplicationsResponse = deleteApplications(DeleteApplicationsRequest.Builder().apply(block).build())

/**
 * Deletes the association between configuration items and one or more tags. This API accepts a list of multiple configuration items.
 */
public suspend inline fun ApplicationDiscoveryClient.deleteTags(crossinline block: DeleteTagsRequest.Builder.() -> Unit): DeleteTagsResponse = deleteTags(DeleteTagsRequest.Builder().apply(block).build())

/**
 * Lists agents or collectors as specified by ID or other filters. All agents/collectors associated with your user can be listed if you call `DescribeAgents` as is without passing any parameters.
 */
public suspend inline fun ApplicationDiscoveryClient.describeAgents(crossinline block: DescribeAgentsRequest.Builder.() -> Unit): DescribeAgentsResponse = describeAgents(DescribeAgentsRequest.Builder().apply(block).build())

/**
 * Takes a unique deletion task identifier as input and returns metadata about a configuration deletion task.
 */
public suspend inline fun ApplicationDiscoveryClient.describeBatchDeleteConfigurationTask(crossinline block: DescribeBatchDeleteConfigurationTaskRequest.Builder.() -> Unit): DescribeBatchDeleteConfigurationTaskResponse = describeBatchDeleteConfigurationTask(DescribeBatchDeleteConfigurationTaskRequest.Builder().apply(block).build())

/**
 * Retrieves attributes for a list of configuration item IDs.
 *
 * All of the supplied IDs must be for the same asset type from one of the following:
 * + server
 * + application
 * + process
 * + connection
 * Output fields are specific to the asset type specified. For example, the output for a *server* configuration item includes a list of attributes about the server, such as host name, operating system, number of network cards, etc.
 *
 * For a complete list of outputs for each asset type, see [Using the DescribeConfigurations Action](https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#DescribeConfigurations) in the *Amazon Web Services Application Discovery Service User Guide*.
 */
public suspend inline fun ApplicationDiscoveryClient.describeConfigurations(crossinline block: DescribeConfigurationsRequest.Builder.() -> Unit): DescribeConfigurationsResponse = describeConfigurations(DescribeConfigurationsRequest.Builder().apply(block).build())

/**
 * Lists exports as specified by ID. All continuous exports associated with your user can be listed if you call `DescribeContinuousExports` as is without passing any parameters.
 */
public suspend inline fun ApplicationDiscoveryClient.describeContinuousExports(crossinline block: DescribeContinuousExportsRequest.Builder.() -> Unit): DescribeContinuousExportsResponse = describeContinuousExports(DescribeContinuousExportsRequest.Builder().apply(block).build())

/**
 * `DescribeExportConfigurations` is deprecated. Use [DescribeExportTasks](https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeExportTasks.html), instead.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun ApplicationDiscoveryClient.describeExportConfigurations(crossinline block: DescribeExportConfigurationsRequest.Builder.() -> Unit): DescribeExportConfigurationsResponse = describeExportConfigurations(DescribeExportConfigurationsRequest.Builder().apply(block).build())

/**
 * Retrieve status of one or more export tasks. You can retrieve the status of up to 100 export tasks.
 */
public suspend inline fun ApplicationDiscoveryClient.describeExportTasks(crossinline block: DescribeExportTasksRequest.Builder.() -> Unit): DescribeExportTasksResponse = describeExportTasks(DescribeExportTasksRequest.Builder().apply(block).build())

/**
 * Returns an array of import tasks for your account, including status information, times, IDs, the Amazon S3 Object URL for the import file, and more.
 */
public suspend inline fun ApplicationDiscoveryClient.describeImportTasks(crossinline block: DescribeImportTasksRequest.Builder.() -> Unit): DescribeImportTasksResponse = describeImportTasks(DescribeImportTasksRequest.Builder().apply(block).build())

/**
 * Retrieves a list of configuration items that have tags as specified by the key-value pairs, name and value, passed to the optional parameter `filters`.
 *
 * There are three valid tag filter names:
 * + tagKey
 * + tagValue
 * + configurationId
 *
 * Also, all configuration items associated with your user that have tags can be listed if you call `DescribeTags` as is without passing any parameters.
 */
public suspend inline fun ApplicationDiscoveryClient.describeTags(crossinline block: DescribeTagsRequest.Builder.() -> Unit): DescribeTagsResponse = describeTags(DescribeTagsRequest.Builder().apply(block).build())

/**
 * Disassociates one or more configuration items from an application.
 */
public suspend inline fun ApplicationDiscoveryClient.disassociateConfigurationItemsFromApplication(crossinline block: DisassociateConfigurationItemsFromApplicationRequest.Builder.() -> Unit): DisassociateConfigurationItemsFromApplicationResponse = disassociateConfigurationItemsFromApplication(DisassociateConfigurationItemsFromApplicationRequest.Builder().apply(block).build())

/**
 * Deprecated. Use `StartExportTask` instead.
 *
 * Exports all discovered configuration data to an Amazon S3 bucket or an application that enables you to view and evaluate the data. Data includes tags and tag associations, processes, connections, servers, and system performance. This API returns an export ID that you can query using the *DescribeExportConfigurations* API. The system imposes a limit of two configuration exports in six hours.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun ApplicationDiscoveryClient.exportConfigurations(crossinline block: ExportConfigurationsRequest.Builder.() -> Unit): ExportConfigurationsResponse = exportConfigurations(ExportConfigurationsRequest.Builder().apply(block).build())

/**
 * Retrieves a short summary of discovered assets.
 *
 * This API operation takes no request parameters and is called as is at the command prompt as shown in the example.
 */
public suspend inline fun ApplicationDiscoveryClient.getDiscoverySummary(crossinline block: GetDiscoverySummaryRequest.Builder.() -> Unit): GetDiscoverySummaryResponse = getDiscoverySummary(GetDiscoverySummaryRequest.Builder().apply(block).build())

/**
 * Retrieves a list of configuration items as specified by the value passed to the required parameter `configurationType`. Optional filtering may be applied to refine search results.
 */
public suspend inline fun ApplicationDiscoveryClient.listConfigurations(crossinline block: ListConfigurationsRequest.Builder.() -> Unit): ListConfigurationsResponse = listConfigurations(ListConfigurationsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of servers that are one network hop away from a specified server.
 */
public suspend inline fun ApplicationDiscoveryClient.listServerNeighbors(crossinline block: ListServerNeighborsRequest.Builder.() -> Unit): ListServerNeighborsResponse = listServerNeighbors(ListServerNeighborsRequest.Builder().apply(block).build())

/**
 * Takes a list of configurationId as input and starts an asynchronous deletion task to remove the configurationItems. Returns a unique deletion task identifier.
 */
public suspend inline fun ApplicationDiscoveryClient.startBatchDeleteConfigurationTask(crossinline block: StartBatchDeleteConfigurationTaskRequest.Builder.() -> Unit): StartBatchDeleteConfigurationTaskResponse = startBatchDeleteConfigurationTask(StartBatchDeleteConfigurationTaskRequest.Builder().apply(block).build())

/**
 * Start the continuous flow of agent's discovered data into Amazon Athena.
 */
public suspend inline fun ApplicationDiscoveryClient.startContinuousExport(crossinline block: StartContinuousExportRequest.Builder.() -> Unit): StartContinuousExportResponse = startContinuousExport(StartContinuousExportRequest.Builder().apply(block).build())

/**
 * Instructs the specified agents to start collecting data.
 */
public suspend inline fun ApplicationDiscoveryClient.startDataCollectionByAgentIds(crossinline block: StartDataCollectionByAgentIdsRequest.Builder.() -> Unit): StartDataCollectionByAgentIdsResponse = startDataCollectionByAgentIds(StartDataCollectionByAgentIdsRequest.Builder().apply(block).build())

/**
 * Begins the export of a discovered data report to an Amazon S3 bucket managed by Amazon Web Services.
 *
 * Exports might provide an estimate of fees and savings based on certain information that you provide. Fee estimates do not include any taxes that might apply. Your actual fees and savings depend on a variety of factors, including your actual usage of Amazon Web Services services, which might vary from the estimates provided in this report.
 *
 * If you do not specify `preferences` or `agentIds` in the filter, a summary of all servers, applications, tags, and performance is generated. This data is an aggregation of all server data collected through on-premises tooling, file import, application grouping and applying tags.
 *
 * If you specify `agentIds` in a filter, the task exports up to 72 hours of detailed data collected by the identified Application Discovery Agent, including network, process, and performance details. A time range for exported agent data may be set by using `startTime` and `endTime`. Export of detailed agent data is limited to five concurrently running exports. Export of detailed agent data is limited to two exports per day.
 *
 * If you enable `ec2RecommendationsPreferences` in `preferences` , an Amazon EC2 instance matching the characteristics of each server in Application Discovery Service is generated. Changing the attributes of the `ec2RecommendationsPreferences` changes the criteria of the recommendation.
 */
public suspend inline fun ApplicationDiscoveryClient.startExportTask(crossinline block: StartExportTaskRequest.Builder.() -> Unit): StartExportTaskResponse = startExportTask(StartExportTaskRequest.Builder().apply(block).build())

/**
 * Starts an import task, which allows you to import details of your on-premises environment directly into Amazon Web Services Migration Hub without having to use the Amazon Web Services Application Discovery Service (Application Discovery Service) tools such as the Amazon Web Services Application Discovery Service Agentless Collector or Application Discovery Agent. This gives you the option to perform migration assessment and planning directly from your imported data, including the ability to group your devices as applications and track their migration status.
 *
 * To start an import request, do this:
 * + Download the specially formatted comma separated value (CSV) import template, which you can find here: [https://s3.us-west-2.amazonaws.com/templates-7cffcf56-bd96-4b1c-b45b-a5b42f282e46/import_template.csv](https://s3.us-west-2.amazonaws.com/templates-7cffcf56-bd96-4b1c-b45b-a5b42f282e46/import_template.csv).
 * + Fill out the template with your server and application data.
 * + Upload your import file to an Amazon S3 bucket, and make a note of it's Object URL. Your import file must be in the CSV format.
 * + Use the console or the `StartImportTask` command with the Amazon Web Services CLI or one of the Amazon Web Services SDKs to import the records from your file.
 *
 * For more information, including step-by-step procedures, see [Migration Hub Import](https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-import.html) in the *Amazon Web Services Application Discovery Service User Guide*.
 *
 * There are limits to the number of import tasks you can create (and delete) in an Amazon Web Services account. For more information, see [Amazon Web Services Application Discovery Service Limits](https://docs.aws.amazon.com/application-discovery/latest/userguide/ads_service_limits.html) in the *Amazon Web Services Application Discovery Service User Guide*.
 */
public suspend inline fun ApplicationDiscoveryClient.startImportTask(crossinline block: StartImportTaskRequest.Builder.() -> Unit): StartImportTaskResponse = startImportTask(StartImportTaskRequest.Builder().apply(block).build())

/**
 * Stop the continuous flow of agent's discovered data into Amazon Athena.
 */
public suspend inline fun ApplicationDiscoveryClient.stopContinuousExport(crossinline block: StopContinuousExportRequest.Builder.() -> Unit): StopContinuousExportResponse = stopContinuousExport(StopContinuousExportRequest.Builder().apply(block).build())

/**
 * Instructs the specified agents to stop collecting data.
 */
public suspend inline fun ApplicationDiscoveryClient.stopDataCollectionByAgentIds(crossinline block: StopDataCollectionByAgentIdsRequest.Builder.() -> Unit): StopDataCollectionByAgentIdsResponse = stopDataCollectionByAgentIds(StopDataCollectionByAgentIdsRequest.Builder().apply(block).build())

/**
 * Updates metadata about an application.
 */
public suspend inline fun ApplicationDiscoveryClient.updateApplication(crossinline block: UpdateApplicationRequest.Builder.() -> Unit): UpdateApplicationResponse = updateApplication(UpdateApplicationRequest.Builder().apply(block).build())
