// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationdiscoveryservice.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A metadata object that represents the deletion task being executed.
 */
public class BatchDeleteConfigurationTask private constructor(builder: Builder) {
    /**
     * The type of configuration item to delete. Supported types are: SERVER.
     */
    public val configurationType: aws.sdk.kotlin.services.applicationdiscoveryservice.model.DeletionConfigurationItemType? = builder.configurationType
    /**
     * The list of configuration IDs that were successfully deleted by the deletion task.
     */
    public val deletedConfigurations: List<String>? = builder.deletedConfigurations
    /**
     * A list of configuration IDs that produced warnings regarding their deletion, paired with a warning message.
     */
    public val deletionWarnings: List<DeletionWarning>? = builder.deletionWarnings
    /**
     * An epoch seconds timestamp (UTC) of when the deletion task was completed or failed.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * A list of configuration IDs that failed to delete during the deletion task, each paired with an error message.
     */
    public val failedConfigurations: List<FailedConfiguration>? = builder.failedConfigurations
    /**
     * The list of configuration IDs that were originally requested to be deleted by the deletion task.
     */
    public val requestedConfigurations: List<String>? = builder.requestedConfigurations
    /**
     * An epoch seconds timestamp (UTC) of when the deletion task was started.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The current execution status of the deletion task. Valid status are: INITIALIZING | VALIDATING | DELETING | COMPLETED | FAILED.
     */
    public val status: aws.sdk.kotlin.services.applicationdiscoveryservice.model.BatchDeleteConfigurationTaskStatus? = builder.status
    /**
     * The deletion task's unique identifier.
     */
    public val taskId: kotlin.String? = builder.taskId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.applicationdiscoveryservice.model.BatchDeleteConfigurationTask = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BatchDeleteConfigurationTask(")
        append("configurationType=$configurationType,")
        append("deletedConfigurations=$deletedConfigurations,")
        append("deletionWarnings=$deletionWarnings,")
        append("endTime=$endTime,")
        append("failedConfigurations=$failedConfigurations,")
        append("requestedConfigurations=$requestedConfigurations,")
        append("startTime=$startTime,")
        append("status=$status,")
        append("taskId=$taskId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = configurationType?.hashCode() ?: 0
        result = 31 * result + (deletedConfigurations?.hashCode() ?: 0)
        result = 31 * result + (deletionWarnings?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (failedConfigurations?.hashCode() ?: 0)
        result = 31 * result + (requestedConfigurations?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (taskId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BatchDeleteConfigurationTask

        if (configurationType != other.configurationType) return false
        if (deletedConfigurations != other.deletedConfigurations) return false
        if (deletionWarnings != other.deletionWarnings) return false
        if (endTime != other.endTime) return false
        if (failedConfigurations != other.failedConfigurations) return false
        if (requestedConfigurations != other.requestedConfigurations) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false
        if (taskId != other.taskId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.applicationdiscoveryservice.model.BatchDeleteConfigurationTask = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The type of configuration item to delete. Supported types are: SERVER.
         */
        public var configurationType: aws.sdk.kotlin.services.applicationdiscoveryservice.model.DeletionConfigurationItemType? = null
        /**
         * The list of configuration IDs that were successfully deleted by the deletion task.
         */
        public var deletedConfigurations: List<String>? = null
        /**
         * A list of configuration IDs that produced warnings regarding their deletion, paired with a warning message.
         */
        public var deletionWarnings: List<DeletionWarning>? = null
        /**
         * An epoch seconds timestamp (UTC) of when the deletion task was completed or failed.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A list of configuration IDs that failed to delete during the deletion task, each paired with an error message.
         */
        public var failedConfigurations: List<FailedConfiguration>? = null
        /**
         * The list of configuration IDs that were originally requested to be deleted by the deletion task.
         */
        public var requestedConfigurations: List<String>? = null
        /**
         * An epoch seconds timestamp (UTC) of when the deletion task was started.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The current execution status of the deletion task. Valid status are: INITIALIZING | VALIDATING | DELETING | COMPLETED | FAILED.
         */
        public var status: aws.sdk.kotlin.services.applicationdiscoveryservice.model.BatchDeleteConfigurationTaskStatus? = null
        /**
         * The deletion task's unique identifier.
         */
        public var taskId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.applicationdiscoveryservice.model.BatchDeleteConfigurationTask) : this() {
            this.configurationType = x.configurationType
            this.deletedConfigurations = x.deletedConfigurations
            this.deletionWarnings = x.deletionWarnings
            this.endTime = x.endTime
            this.failedConfigurations = x.failedConfigurations
            this.requestedConfigurations = x.requestedConfigurations
            this.startTime = x.startTime
            this.status = x.status
            this.taskId = x.taskId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.applicationdiscoveryservice.model.BatchDeleteConfigurationTask = BatchDeleteConfigurationTask(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
