// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationdiscoveryservice.paginators

import aws.sdk.kotlin.services.applicationdiscoveryservice.ApplicationDiscoveryClient
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.AgentInfo
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.ConfigurationTag
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.ContinuousExportDescription
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeAgentsRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeAgentsResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeContinuousExportsRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeContinuousExportsResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeExportConfigurationsRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeExportConfigurationsResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeExportTasksRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeExportTasksResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeImportTasksRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeImportTasksResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeTagsRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeTagsResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.ExportInfo
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.ImportTask
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.ListConfigurationsRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.ListConfigurationsResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeAgentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeAgentsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAgentsResponse]
 */
public fun ApplicationDiscoveryClient.describeAgentsPaginated(initialRequest: DescribeAgentsRequest = DescribeAgentsRequest { }): Flow<DescribeAgentsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeAgentsPaginated.describeAgents(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeAgentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAgentsResponse]
 */
public fun ApplicationDiscoveryClient.describeAgentsPaginated(block: DescribeAgentsRequest.Builder.() -> Unit): Flow<DescribeAgentsResponse> =
    describeAgentsPaginated(DescribeAgentsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeAgentsPaginated]
 * to access the nested member [AgentInfo]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AgentInfo]
 */
@JvmName("describeAgentsResponseAgentInfo")
public fun Flow<DescribeAgentsResponse>.agentsInfo(): Flow<AgentInfo> =
    transform() { response ->
        response.agentsInfo?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeContinuousExportsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeContinuousExportsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeContinuousExportsResponse]
 */
public fun ApplicationDiscoveryClient.describeContinuousExportsPaginated(initialRequest: DescribeContinuousExportsRequest = DescribeContinuousExportsRequest { }): Flow<DescribeContinuousExportsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeContinuousExportsPaginated.describeContinuousExports(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeContinuousExportsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeContinuousExportsResponse]
 */
public fun ApplicationDiscoveryClient.describeContinuousExportsPaginated(block: DescribeContinuousExportsRequest.Builder.() -> Unit): Flow<DescribeContinuousExportsResponse> =
    describeContinuousExportsPaginated(DescribeContinuousExportsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeContinuousExportsPaginated]
 * to access the nested member [ContinuousExportDescription]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ContinuousExportDescription]
 */
@JvmName("describeContinuousExportsResponseContinuousExportDescription")
public fun Flow<DescribeContinuousExportsResponse>.descriptions(): Flow<ContinuousExportDescription> =
    transform() { response ->
        response.descriptions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeExportConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeExportConfigurationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeExportConfigurationsResponse]
 */
public fun ApplicationDiscoveryClient.describeExportConfigurationsPaginated(initialRequest: DescribeExportConfigurationsRequest = DescribeExportConfigurationsRequest { }): Flow<DescribeExportConfigurationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeExportConfigurationsPaginated.describeExportConfigurations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeExportConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeExportConfigurationsResponse]
 */
public fun ApplicationDiscoveryClient.describeExportConfigurationsPaginated(block: DescribeExportConfigurationsRequest.Builder.() -> Unit): Flow<DescribeExportConfigurationsResponse> =
    describeExportConfigurationsPaginated(DescribeExportConfigurationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeExportConfigurationsPaginated]
 * to access the nested member [ExportInfo]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ExportInfo]
 */
@JvmName("describeExportConfigurationsResponseExportInfo")
public fun Flow<DescribeExportConfigurationsResponse>.exportsInfo(): Flow<ExportInfo> =
    transform() { response ->
        response.exportsInfo?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeExportTasksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeExportTasksRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeExportTasksResponse]
 */
public fun ApplicationDiscoveryClient.describeExportTasksPaginated(initialRequest: DescribeExportTasksRequest = DescribeExportTasksRequest { }): Flow<DescribeExportTasksResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeExportTasksPaginated.describeExportTasks(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeExportTasksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeExportTasksResponse]
 */
public fun ApplicationDiscoveryClient.describeExportTasksPaginated(block: DescribeExportTasksRequest.Builder.() -> Unit): Flow<DescribeExportTasksResponse> =
    describeExportTasksPaginated(DescribeExportTasksRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeExportTasksPaginated]
 * to access the nested member [ExportInfo]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ExportInfo]
 */
@JvmName("describeExportTasksResponseExportInfo")
public fun Flow<DescribeExportTasksResponse>.exportsInfo(): Flow<ExportInfo> =
    transform() { response ->
        response.exportsInfo?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeImportTasksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeImportTasksRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeImportTasksResponse]
 */
public fun ApplicationDiscoveryClient.describeImportTasksPaginated(initialRequest: DescribeImportTasksRequest = DescribeImportTasksRequest { }): Flow<DescribeImportTasksResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeImportTasksPaginated.describeImportTasks(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeImportTasksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeImportTasksResponse]
 */
public fun ApplicationDiscoveryClient.describeImportTasksPaginated(block: DescribeImportTasksRequest.Builder.() -> Unit): Flow<DescribeImportTasksResponse> =
    describeImportTasksPaginated(DescribeImportTasksRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeImportTasksPaginated]
 * to access the nested member [ImportTask]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ImportTask]
 */
@JvmName("describeImportTasksResponseImportTask")
public fun Flow<DescribeImportTasksResponse>.tasks(): Flow<ImportTask> =
    transform() { response ->
        response.tasks?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeTagsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeTagsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeTagsResponse]
 */
public fun ApplicationDiscoveryClient.describeTagsPaginated(initialRequest: DescribeTagsRequest = DescribeTagsRequest { }): Flow<DescribeTagsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeTagsPaginated.describeTags(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeTagsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeTagsResponse]
 */
public fun ApplicationDiscoveryClient.describeTagsPaginated(block: DescribeTagsRequest.Builder.() -> Unit): Flow<DescribeTagsResponse> =
    describeTagsPaginated(DescribeTagsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeTagsPaginated]
 * to access the nested member [ConfigurationTag]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ConfigurationTag]
 */
@JvmName("describeTagsResponseConfigurationTag")
public fun Flow<DescribeTagsResponse>.tags(): Flow<ConfigurationTag> =
    transform() { response ->
        response.tags?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListConfigurationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListConfigurationsResponse]
 */
public fun ApplicationDiscoveryClient.listConfigurationsPaginated(initialRequest: ListConfigurationsRequest): Flow<ListConfigurationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listConfigurationsPaginated.listConfigurations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListConfigurationsResponse]
 */
public fun ApplicationDiscoveryClient.listConfigurationsPaginated(block: ListConfigurationsRequest.Builder.() -> Unit): Flow<ListConfigurationsResponse> =
    listConfigurationsPaginated(ListConfigurationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listConfigurationsPaginated]
 * to access the nested member [Configuration]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Configuration]
 */
@JvmName("listConfigurationsResponseConfiguration")
public fun Flow<ListConfigurationsResponse>.configurations(): Flow<Map<String, String>> =
    transform() { response ->
        response.configurations?.forEach {
            emit(it)
        }
    }
