// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationdiscoveryservice.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A filter that can use conditional operators.
 *
 * For more information about filters, see [Querying Discovered Configuration Items](https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html) in the *Amazon Web Services Application Discovery Service User Guide*.
 */
public class Filter private constructor(builder: Builder) {
    /**
     * A conditional operator. The following operators are valid: EQUALS, NOT_EQUALS, CONTAINS, NOT_CONTAINS. If you specify multiple filters, the system utilizes all filters as though concatenated by *AND*. If you specify multiple values for a particular filter, the system differentiates the values using *OR*. Calling either *DescribeConfigurations* or *ListConfigurations* returns attributes of matching configuration items.
     */
    public val condition: kotlin.String = requireNotNull(builder.condition) { "A non-null value must be provided for condition" }
    /**
     * The name of the filter.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * A string value on which to filter. For example, if you choose the `destinationServer.osVersion` filter name, you could specify `Ubuntu` for the value.
     */
    public val values: List<String> = requireNotNull(builder.values) { "A non-null value must be provided for values" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.applicationdiscoveryservice.model.Filter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Filter(")
        append("condition=$condition,")
        append("name=$name,")
        append("values=$values")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = condition.hashCode()
        result = 31 * result + (name.hashCode())
        result = 31 * result + (values.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Filter

        if (condition != other.condition) return false
        if (name != other.name) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.applicationdiscoveryservice.model.Filter = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A conditional operator. The following operators are valid: EQUALS, NOT_EQUALS, CONTAINS, NOT_CONTAINS. If you specify multiple filters, the system utilizes all filters as though concatenated by *AND*. If you specify multiple values for a particular filter, the system differentiates the values using *OR*. Calling either *DescribeConfigurations* or *ListConfigurations* returns attributes of matching configuration items.
         */
        public var condition: kotlin.String? = null
        /**
         * The name of the filter.
         */
        public var name: kotlin.String? = null
        /**
         * A string value on which to filter. For example, if you choose the `destinationServer.osVersion` filter name, you could specify `Ubuntu` for the value.
         */
        public var values: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.applicationdiscoveryservice.model.Filter) : this() {
            this.condition = x.condition
            this.name = x.name
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.applicationdiscoveryservice.model.Filter = Filter(this)

        internal fun correctErrors(): Builder {
            if (condition == null) condition = ""
            if (name == null) name = ""
            if (values == null) values = emptyList()
            return this
        }
    }
}
