// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationdiscoveryservice.serde

import aws.sdk.kotlin.services.applicationdiscoveryservice.model.ApplicationDiscoveryException
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.UpdateApplicationResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class UpdateApplicationOperationDeserializer: HttpDeserializer.NonStreaming<UpdateApplicationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdateApplicationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateApplicationError(context, call, payload)
        }
        val builder = UpdateApplicationResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdateApplicationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ApplicationDiscoveryException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AuthorizationErrorException" -> AuthorizationErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServerInternalErrorException" -> ServerInternalErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "HomeRegionNotSetException" -> HomeRegionNotSetExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ApplicationDiscoveryException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
