// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationdiscoveryservice.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information regarding the export status of discovered data. The value is an array of objects.
 */
public class ExportInfo private constructor(builder: Builder) {
    /**
     * A URL for an Amazon S3 bucket where you can review the exported data. The URL is displayed only if the export succeeded.
     */
    public val configurationsDownloadUrl: kotlin.String? = builder.configurationsDownloadUrl
    /**
     * A unique identifier used to query an export.
     */
    public val exportId: kotlin.String = requireNotNull(builder.exportId) { "A non-null value must be provided for exportId" }
    /**
     * The time that the data export was initiated.
     */
    public val exportRequestTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.exportRequestTime) { "A non-null value must be provided for exportRequestTime" }
    /**
     * The status of the data export job.
     */
    public val exportStatus: aws.sdk.kotlin.services.applicationdiscoveryservice.model.ExportStatus = requireNotNull(builder.exportStatus) { "A non-null value must be provided for exportStatus" }
    /**
     * If true, the export of agent information exceeded the size limit for a single export and the exported data is incomplete for the requested time range. To address this, select a smaller time range for the export by using `startDate` and `endDate`.
     */
    public val isTruncated: kotlin.Boolean = builder.isTruncated
    /**
     * The `endTime` used in the `StartExportTask` request. If no `endTime` was requested, this result does not appear in `ExportInfo`.
     */
    public val requestedEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.requestedEndTime
    /**
     * The value of `startTime` parameter in the `StartExportTask` request. If no `startTime` was requested, this result does not appear in `ExportInfo`.
     */
    public val requestedStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.requestedStartTime
    /**
     * A status message provided for API callers.
     */
    public val statusMessage: kotlin.String = requireNotNull(builder.statusMessage) { "A non-null value must be provided for statusMessage" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.applicationdiscoveryservice.model.ExportInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExportInfo(")
        append("configurationsDownloadUrl=$configurationsDownloadUrl,")
        append("exportId=$exportId,")
        append("exportRequestTime=$exportRequestTime,")
        append("exportStatus=$exportStatus,")
        append("isTruncated=$isTruncated,")
        append("requestedEndTime=$requestedEndTime,")
        append("requestedStartTime=$requestedStartTime,")
        append("statusMessage=$statusMessage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = configurationsDownloadUrl?.hashCode() ?: 0
        result = 31 * result + (exportId.hashCode())
        result = 31 * result + (exportRequestTime.hashCode())
        result = 31 * result + (exportStatus.hashCode())
        result = 31 * result + (isTruncated.hashCode())
        result = 31 * result + (requestedEndTime?.hashCode() ?: 0)
        result = 31 * result + (requestedStartTime?.hashCode() ?: 0)
        result = 31 * result + (statusMessage.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExportInfo

        if (configurationsDownloadUrl != other.configurationsDownloadUrl) return false
        if (exportId != other.exportId) return false
        if (exportRequestTime != other.exportRequestTime) return false
        if (exportStatus != other.exportStatus) return false
        if (isTruncated != other.isTruncated) return false
        if (requestedEndTime != other.requestedEndTime) return false
        if (requestedStartTime != other.requestedStartTime) return false
        if (statusMessage != other.statusMessage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.applicationdiscoveryservice.model.ExportInfo = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A URL for an Amazon S3 bucket where you can review the exported data. The URL is displayed only if the export succeeded.
         */
        public var configurationsDownloadUrl: kotlin.String? = null
        /**
         * A unique identifier used to query an export.
         */
        public var exportId: kotlin.String? = null
        /**
         * The time that the data export was initiated.
         */
        public var exportRequestTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the data export job.
         */
        public var exportStatus: aws.sdk.kotlin.services.applicationdiscoveryservice.model.ExportStatus? = null
        /**
         * If true, the export of agent information exceeded the size limit for a single export and the exported data is incomplete for the requested time range. To address this, select a smaller time range for the export by using `startDate` and `endDate`.
         */
        public var isTruncated: kotlin.Boolean = false
        /**
         * The `endTime` used in the `StartExportTask` request. If no `endTime` was requested, this result does not appear in `ExportInfo`.
         */
        public var requestedEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The value of `startTime` parameter in the `StartExportTask` request. If no `startTime` was requested, this result does not appear in `ExportInfo`.
         */
        public var requestedStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A status message provided for API callers.
         */
        public var statusMessage: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.applicationdiscoveryservice.model.ExportInfo) : this() {
            this.configurationsDownloadUrl = x.configurationsDownloadUrl
            this.exportId = x.exportId
            this.exportRequestTime = x.exportRequestTime
            this.exportStatus = x.exportStatus
            this.isTruncated = x.isTruncated
            this.requestedEndTime = x.requestedEndTime
            this.requestedStartTime = x.requestedStartTime
            this.statusMessage = x.statusMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.applicationdiscoveryservice.model.ExportInfo = ExportInfo(this)

        internal fun correctErrors(): Builder {
            if (exportId == null) exportId = ""
            if (exportRequestTime == null) exportRequestTime = Instant.fromEpochSeconds(0)
            if (exportStatus == null) exportStatus = ExportStatus.SdkUnknown("no value provided")
            if (statusMessage == null) statusMessage = ""
            return this
        }
    }
}
