// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationdiscoveryservice.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.ApplicationDiscoveryException
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DataSource
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.StartContinuousExportResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class StartContinuousExportOperationDeserializer: HttpDeserialize<StartContinuousExportResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): StartContinuousExportResponse {
        if (!response.status.isSuccess()) {
            throwStartContinuousExportError(context, response)
        }
        val builder = StartContinuousExportResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeStartContinuousExportOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeStartContinuousExportOperationBody(builder: StartContinuousExportResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DATASOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("dataSource"))
    val EXPORTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("exportId"))
    val S3BUCKET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("s3Bucket"))
    val SCHEMASTORAGECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("schemaStorageConfig"))
    val STARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("startTime"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DATASOURCE_DESCRIPTOR)
        field(EXPORTID_DESCRIPTOR)
        field(S3BUCKET_DESCRIPTOR)
        field(SCHEMASTORAGECONFIG_DESCRIPTOR)
        field(STARTTIME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DATASOURCE_DESCRIPTOR.index -> builder.dataSource = deserializeString().let { DataSource.fromValue(it) }
                EXPORTID_DESCRIPTOR.index -> builder.exportId = deserializeString()
                S3BUCKET_DESCRIPTOR.index -> builder.s3Bucket = deserializeString()
                SCHEMASTORAGECONFIG_DESCRIPTOR.index -> builder.schemaStorageConfig =
                    deserializer.deserializeMap(SCHEMASTORAGECONFIG_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                STARTTIME_DESCRIPTOR.index -> builder.startTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwStartContinuousExportError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ApplicationDiscoveryException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "AuthorizationErrorException" -> AuthorizationErrorExceptionDeserializer()
        "ConflictErrorException" -> ConflictErrorExceptionDeserializer()
        "HomeRegionNotSetException" -> HomeRegionNotSetExceptionDeserializer()
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer()
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer()
        "OperationNotPermittedException" -> OperationNotPermittedExceptionDeserializer()
        "ResourceInUseException" -> ResourceInUseExceptionDeserializer()
        "ServerInternalErrorException" -> ServerInternalErrorExceptionDeserializer()
        else -> throw ApplicationDiscoveryException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
