// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationdiscoveryservice

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.applicationdiscoveryservice.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.*
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.AssociateConfigurationItemsToApplicationRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.AssociateConfigurationItemsToApplicationResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.BatchDeleteImportDataRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.BatchDeleteImportDataResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.CreateApplicationRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.CreateApplicationResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.CreateTagsRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.CreateTagsResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DeleteApplicationsRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DeleteApplicationsResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DeleteTagsRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DeleteTagsResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeAgentsRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeAgentsResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeConfigurationsRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeConfigurationsResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeContinuousExportsRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeContinuousExportsResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeExportConfigurationsRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeExportConfigurationsResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeExportTasksRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeExportTasksResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeImportTasksRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeImportTasksResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeTagsRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeTagsResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DisassociateConfigurationItemsFromApplicationRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DisassociateConfigurationItemsFromApplicationResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.ExportConfigurationsRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.ExportConfigurationsResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.GetDiscoverySummaryRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.GetDiscoverySummaryResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.ListConfigurationsRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.ListConfigurationsResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.ListServerNeighborsRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.ListServerNeighborsResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.StartContinuousExportRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.StartContinuousExportResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.StartDataCollectionByAgentIdsRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.StartDataCollectionByAgentIdsResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.StartExportTaskRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.StartExportTaskResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.StartImportTaskRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.StartImportTaskResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.StopContinuousExportRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.StopContinuousExportResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.StopDataCollectionByAgentIdsRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.StopDataCollectionByAgentIdsResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.UpdateApplicationRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.UpdateApplicationResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * # Amazon Web Services Application Discovery Service
 * Amazon Web Services Application Discovery Service helps you plan application migration projects. It automatically identifies servers, virtual machines (VMs), and network dependencies in your on-premises data centers. For more information, see the [Amazon Web Services Application Discovery Service FAQ](http://aws.amazon.com/application-discovery/faqs/). Application Discovery Service offers three ways of performing discovery and collecting data about your on-premises servers:
 * + **Agentless discovery** is recommended for environments that use VMware vCenter Server. This mode doesn't require you to install an agent on each host. It does not work in non-VMware environments.
 *    + Agentless discovery gathers server information regardless of the operating systems, which minimizes the time required for initial on-premises infrastructure assessment.
 *    + Agentless discovery doesn't collect information about network dependencies, only agent-based discovery collects that information.
 *
 * + **Agent-based discovery** collects a richer set of data than agentless discovery by using the Amazon Web Services Application Discovery Agent, which you install on one or more hosts in your data center.
 *    +  The agent captures infrastructure and application information, including an inventory of running processes, system performance information, resource utilization, and network dependencies.
 *    + The information collected by agents is secured at rest and in transit to the Application Discovery Service database in the cloud.
 *
 * + **Amazon Web Services Partner Network (APN) solutions** integrate with Application Discovery Service, enabling you to import details of your on-premises environment directly into Migration Hub without using the discovery connector or discovery agent.
 *    + Third-party application discovery tools can query Amazon Web Services Application Discovery Service, and they can write to the Application Discovery Service database using the public API.
 *    + In this way, you can import data into Migration Hub and view it, so that you can associate applications with servers and track migrations.
 *
 * **Recommendations**
 *
 * We recommend that you use agent-based discovery for non-VMware environments, and whenever you want to collect information about network dependencies. You can run agent-based and agentless discovery simultaneously. Use agentless discovery to complete the initial infrastructure assessment quickly, and then install agents on select hosts to collect additional information.
 *
 * **Working With This Guide**
 *
 * This API reference provides descriptions, syntax, and usage examples for each of the actions and data types for Application Discovery Service. The topic for each action shows the API request parameters and the response. Alternatively, you can use one of the Amazon Web Services SDKs to access an API that is tailored to the programming language or platform that you're using. For more information, see [Amazon Web Services SDKs](http://aws.amazon.com/tools/#SDKs).
 *
 * + Remember that you must set your Migration Hub home region before you call any of these APIs.
 * + You must make API calls for write actions (create, notify, associate, disassociate, import, or put) while in your home region, or a `HomeRegionNotSetException` error is returned.
 * + API calls for read actions (list, describe, stop, and delete) are permitted outside of your home region.
 * + Although it is unlikely, the Migration Hub home region could change. If you call APIs outside the home region, an `InvalidInputException` is returned.
 * + You must call `GetHomeRegion` to obtain the latest Migration Hub home region.
 * This guide is intended for use with the [Amazon Web Services Application Discovery Service User Guide](http://docs.aws.amazon.com/application-discovery/latest/userguide/).
 *
 * All data is handled according to the [Amazon Web Services Privacy Policy](http://aws.amazon.com/privacy/). You can operate Application Discovery Service offline to inspect collected data before it is shared with the service.
 */
public interface ApplicationDiscoveryClient : SdkClient {

    override val serviceName: String
        get() = "Application Discovery Service"
    /**
     * ApplicationDiscoveryClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): ApplicationDiscoveryClient {
            val config = Config.Builder().apply(block).build()
            return DefaultApplicationDiscoveryClient(config)
        }

        public operator fun invoke(config: Config): ApplicationDiscoveryClient = DefaultApplicationDiscoveryClient(config)

        /**
         * Construct a [ApplicationDiscoveryClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): ApplicationDiscoveryClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultApplicationDiscoveryClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            public var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Associates one or more configuration items with an application.
     */
    public suspend fun associateConfigurationItemsToApplication(input: AssociateConfigurationItemsToApplicationRequest): AssociateConfigurationItemsToApplicationResponse

    /**
     * Deletes one or more import tasks, each identified by their import ID. Each import task has a number of records that can identify servers or applications.
     *
     * Amazon Web Services Application Discovery Service has built-in matching logic that will identify when discovered servers match existing entries that you've previously discovered, the information for the already-existing discovered server is updated. When you delete an import task that contains records that were used to match, the information in those matched records that comes from the deleted records will also be deleted.
     */
    public suspend fun batchDeleteImportData(input: BatchDeleteImportDataRequest): BatchDeleteImportDataResponse

    /**
     * Creates an application with the given name and description.
     */
    public suspend fun createApplication(input: CreateApplicationRequest): CreateApplicationResponse

    /**
     * Creates one or more tags for configuration items. Tags are metadata that help you categorize IT assets. This API accepts a list of multiple configuration items.
     *
     * Do not store sensitive information (like personal data) in tags.
     */
    public suspend fun createTags(input: CreateTagsRequest): CreateTagsResponse

    /**
     * Deletes a list of applications and their associations with configuration items.
     */
    public suspend fun deleteApplications(input: DeleteApplicationsRequest): DeleteApplicationsResponse

    /**
     * Deletes the association between configuration items and one or more tags. This API accepts a list of multiple configuration items.
     */
    public suspend fun deleteTags(input: DeleteTagsRequest): DeleteTagsResponse

    /**
     * Lists agents or connectors as specified by ID or other filters. All agents/connectors associated with your user account can be listed if you call `DescribeAgents` as is without passing any parameters.
     */
    public suspend fun describeAgents(input: DescribeAgentsRequest = DescribeAgentsRequest {}): DescribeAgentsResponse

    /**
     * Retrieves attributes for a list of configuration item IDs.
     *
     * All of the supplied IDs must be for the same asset type from one of the following:
     * + server
     * + application
     * + process
     * + connection
     * Output fields are specific to the asset type specified. For example, the output for a *server* configuration item includes a list of attributes about the server, such as host name, operating system, number of network cards, etc.
     *
     * For a complete list of outputs for each asset type, see [Using the DescribeConfigurations Action](https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#DescribeConfigurations) in the *Amazon Web Services Application Discovery Service User Guide*.
     */
    public suspend fun describeConfigurations(input: DescribeConfigurationsRequest): DescribeConfigurationsResponse

    /**
     * Lists exports as specified by ID. All continuous exports associated with your user account can be listed if you call `DescribeContinuousExports` as is without passing any parameters.
     */
    public suspend fun describeContinuousExports(input: DescribeContinuousExportsRequest = DescribeContinuousExportsRequest {}): DescribeContinuousExportsResponse

    /**
     * `DescribeExportConfigurations` is deprecated. Use [DescribeExportTasks](https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeExportTasks.html), instead.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun describeExportConfigurations(input: DescribeExportConfigurationsRequest = DescribeExportConfigurationsRequest {}): DescribeExportConfigurationsResponse

    /**
     * Retrieve status of one or more export tasks. You can retrieve the status of up to 100 export tasks.
     */
    public suspend fun describeExportTasks(input: DescribeExportTasksRequest = DescribeExportTasksRequest {}): DescribeExportTasksResponse

    /**
     * Returns an array of import tasks for your account, including status information, times, IDs, the Amazon S3 Object URL for the import file, and more.
     */
    public suspend fun describeImportTasks(input: DescribeImportTasksRequest = DescribeImportTasksRequest {}): DescribeImportTasksResponse

    /**
     * Retrieves a list of configuration items that have tags as specified by the key-value pairs, name and value, passed to the optional parameter `filters`.
     *
     * There are three valid tag filter names:
     * + tagKey
     * + tagValue
     * + configurationId
     *
     * Also, all configuration items associated with your user account that have tags can be listed if you call `DescribeTags` as is without passing any parameters.
     */
    public suspend fun describeTags(input: DescribeTagsRequest = DescribeTagsRequest {}): DescribeTagsResponse

    /**
     * Disassociates one or more configuration items from an application.
     */
    public suspend fun disassociateConfigurationItemsFromApplication(input: DisassociateConfigurationItemsFromApplicationRequest): DisassociateConfigurationItemsFromApplicationResponse

    /**
     * Deprecated. Use `StartExportTask` instead.
     *
     * Exports all discovered configuration data to an Amazon S3 bucket or an application that enables you to view and evaluate the data. Data includes tags and tag associations, processes, connections, servers, and system performance. This API returns an export ID that you can query using the *DescribeExportConfigurations* API. The system imposes a limit of two configuration exports in six hours.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun exportConfigurations(input: ExportConfigurationsRequest = ExportConfigurationsRequest {}): ExportConfigurationsResponse

    /**
     * Retrieves a short summary of discovered assets.
     *
     * This API operation takes no request parameters and is called as is at the command prompt as shown in the example.
     */
    public suspend fun getDiscoverySummary(input: GetDiscoverySummaryRequest = GetDiscoverySummaryRequest {}): GetDiscoverySummaryResponse

    /**
     * Retrieves a list of configuration items as specified by the value passed to the required parameter `configurationType`. Optional filtering may be applied to refine search results.
     */
    public suspend fun listConfigurations(input: ListConfigurationsRequest): ListConfigurationsResponse

    /**
     * Retrieves a list of servers that are one network hop away from a specified server.
     */
    public suspend fun listServerNeighbors(input: ListServerNeighborsRequest): ListServerNeighborsResponse

    /**
     * Start the continuous flow of agent's discovered data into Amazon Athena.
     */
    public suspend fun startContinuousExport(input: StartContinuousExportRequest = StartContinuousExportRequest {}): StartContinuousExportResponse

    /**
     * Instructs the specified agents or connectors to start collecting data.
     */
    public suspend fun startDataCollectionByAgentIds(input: StartDataCollectionByAgentIdsRequest): StartDataCollectionByAgentIdsResponse

    /**
     * Begins the export of discovered data to an S3 bucket.
     *
     *  If you specify `agentIds` in a filter, the task exports up to 72 hours of detailed data collected by the identified Application Discovery Agent, including network, process, and performance details. A time range for exported agent data may be set by using `startTime` and `endTime`. Export of detailed agent data is limited to five concurrently running exports.
     *
     *  If you do not include an `agentIds` filter, summary data is exported that includes both Amazon Web Services Agentless Discovery Connector data and summary data from Amazon Web Services Discovery Agents. Export of summary data is limited to two exports per day.
     */
    public suspend fun startExportTask(input: StartExportTaskRequest = StartExportTaskRequest {}): StartExportTaskResponse

    /**
     * Starts an import task, which allows you to import details of your on-premises environment directly into Amazon Web Services Migration Hub without having to use the Application Discovery Service (ADS) tools such as the Discovery Connector or Discovery Agent. This gives you the option to perform migration assessment and planning directly from your imported data, including the ability to group your devices as applications and track their migration status.
     *
     * To start an import request, do this:
     * + Download the specially formatted comma separated value (CSV) import template, which you can find here: [https://s3.us-west-2.amazonaws.com/templates-7cffcf56-bd96-4b1c-b45b-a5b42f282e46/import_template.csv](https://s3.us-west-2.amazonaws.com/templates-7cffcf56-bd96-4b1c-b45b-a5b42f282e46/import_template.csv).
     * + Fill out the template with your server and application data.
     * + Upload your import file to an Amazon S3 bucket, and make a note of it's Object URL. Your import file must be in the CSV format.
     * + Use the console or the `StartImportTask` command with the Amazon Web Services CLI or one of the Amazon Web Services SDKs to import the records from your file.
     *
     * For more information, including step-by-step procedures, see [Migration Hub Import](https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-import.html) in the *Amazon Web Services Application Discovery Service User Guide*.
     *
     * There are limits to the number of import tasks you can create (and delete) in an Amazon Web Services account. For more information, see [Amazon Web Services Application Discovery Service Limits](https://docs.aws.amazon.com/application-discovery/latest/userguide/ads_service_limits.html) in the *Amazon Web Services Application Discovery Service User Guide*.
     */
    public suspend fun startImportTask(input: StartImportTaskRequest): StartImportTaskResponse

    /**
     * Stop the continuous flow of agent's discovered data into Amazon Athena.
     */
    public suspend fun stopContinuousExport(input: StopContinuousExportRequest): StopContinuousExportResponse

    /**
     * Instructs the specified agents or connectors to stop collecting data.
     */
    public suspend fun stopDataCollectionByAgentIds(input: StopDataCollectionByAgentIdsRequest): StopDataCollectionByAgentIdsResponse

    /**
     * Updates metadata about an application.
     */
    public suspend fun updateApplication(input: UpdateApplicationRequest): UpdateApplicationResponse
}

/**
 * Associates one or more configuration items with an application.
 */
public suspend inline fun ApplicationDiscoveryClient.associateConfigurationItemsToApplication(crossinline block: AssociateConfigurationItemsToApplicationRequest.Builder.() -> Unit): AssociateConfigurationItemsToApplicationResponse = associateConfigurationItemsToApplication(AssociateConfigurationItemsToApplicationRequest.Builder().apply(block).build())

/**
 * Deletes one or more import tasks, each identified by their import ID. Each import task has a number of records that can identify servers or applications.
 *
 * Amazon Web Services Application Discovery Service has built-in matching logic that will identify when discovered servers match existing entries that you've previously discovered, the information for the already-existing discovered server is updated. When you delete an import task that contains records that were used to match, the information in those matched records that comes from the deleted records will also be deleted.
 */
public suspend inline fun ApplicationDiscoveryClient.batchDeleteImportData(crossinline block: BatchDeleteImportDataRequest.Builder.() -> Unit): BatchDeleteImportDataResponse = batchDeleteImportData(BatchDeleteImportDataRequest.Builder().apply(block).build())

/**
 * Creates an application with the given name and description.
 */
public suspend inline fun ApplicationDiscoveryClient.createApplication(crossinline block: CreateApplicationRequest.Builder.() -> Unit): CreateApplicationResponse = createApplication(CreateApplicationRequest.Builder().apply(block).build())

/**
 * Creates one or more tags for configuration items. Tags are metadata that help you categorize IT assets. This API accepts a list of multiple configuration items.
 *
 * Do not store sensitive information (like personal data) in tags.
 */
public suspend inline fun ApplicationDiscoveryClient.createTags(crossinline block: CreateTagsRequest.Builder.() -> Unit): CreateTagsResponse = createTags(CreateTagsRequest.Builder().apply(block).build())

/**
 * Deletes a list of applications and their associations with configuration items.
 */
public suspend inline fun ApplicationDiscoveryClient.deleteApplications(crossinline block: DeleteApplicationsRequest.Builder.() -> Unit): DeleteApplicationsResponse = deleteApplications(DeleteApplicationsRequest.Builder().apply(block).build())

/**
 * Deletes the association between configuration items and one or more tags. This API accepts a list of multiple configuration items.
 */
public suspend inline fun ApplicationDiscoveryClient.deleteTags(crossinline block: DeleteTagsRequest.Builder.() -> Unit): DeleteTagsResponse = deleteTags(DeleteTagsRequest.Builder().apply(block).build())

/**
 * Lists agents or connectors as specified by ID or other filters. All agents/connectors associated with your user account can be listed if you call `DescribeAgents` as is without passing any parameters.
 */
public suspend inline fun ApplicationDiscoveryClient.describeAgents(crossinline block: DescribeAgentsRequest.Builder.() -> Unit): DescribeAgentsResponse = describeAgents(DescribeAgentsRequest.Builder().apply(block).build())

/**
 * Retrieves attributes for a list of configuration item IDs.
 *
 * All of the supplied IDs must be for the same asset type from one of the following:
 * + server
 * + application
 * + process
 * + connection
 * Output fields are specific to the asset type specified. For example, the output for a *server* configuration item includes a list of attributes about the server, such as host name, operating system, number of network cards, etc.
 *
 * For a complete list of outputs for each asset type, see [Using the DescribeConfigurations Action](https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#DescribeConfigurations) in the *Amazon Web Services Application Discovery Service User Guide*.
 */
public suspend inline fun ApplicationDiscoveryClient.describeConfigurations(crossinline block: DescribeConfigurationsRequest.Builder.() -> Unit): DescribeConfigurationsResponse = describeConfigurations(DescribeConfigurationsRequest.Builder().apply(block).build())

/**
 * Lists exports as specified by ID. All continuous exports associated with your user account can be listed if you call `DescribeContinuousExports` as is without passing any parameters.
 */
public suspend inline fun ApplicationDiscoveryClient.describeContinuousExports(crossinline block: DescribeContinuousExportsRequest.Builder.() -> Unit): DescribeContinuousExportsResponse = describeContinuousExports(DescribeContinuousExportsRequest.Builder().apply(block).build())

/**
 * `DescribeExportConfigurations` is deprecated. Use [DescribeExportTasks](https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeExportTasks.html), instead.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun ApplicationDiscoveryClient.describeExportConfigurations(crossinline block: DescribeExportConfigurationsRequest.Builder.() -> Unit): DescribeExportConfigurationsResponse = describeExportConfigurations(DescribeExportConfigurationsRequest.Builder().apply(block).build())

/**
 * Retrieve status of one or more export tasks. You can retrieve the status of up to 100 export tasks.
 */
public suspend inline fun ApplicationDiscoveryClient.describeExportTasks(crossinline block: DescribeExportTasksRequest.Builder.() -> Unit): DescribeExportTasksResponse = describeExportTasks(DescribeExportTasksRequest.Builder().apply(block).build())

/**
 * Returns an array of import tasks for your account, including status information, times, IDs, the Amazon S3 Object URL for the import file, and more.
 */
public suspend inline fun ApplicationDiscoveryClient.describeImportTasks(crossinline block: DescribeImportTasksRequest.Builder.() -> Unit): DescribeImportTasksResponse = describeImportTasks(DescribeImportTasksRequest.Builder().apply(block).build())

/**
 * Retrieves a list of configuration items that have tags as specified by the key-value pairs, name and value, passed to the optional parameter `filters`.
 *
 * There are three valid tag filter names:
 * + tagKey
 * + tagValue
 * + configurationId
 *
 * Also, all configuration items associated with your user account that have tags can be listed if you call `DescribeTags` as is without passing any parameters.
 */
public suspend inline fun ApplicationDiscoveryClient.describeTags(crossinline block: DescribeTagsRequest.Builder.() -> Unit): DescribeTagsResponse = describeTags(DescribeTagsRequest.Builder().apply(block).build())

/**
 * Disassociates one or more configuration items from an application.
 */
public suspend inline fun ApplicationDiscoveryClient.disassociateConfigurationItemsFromApplication(crossinline block: DisassociateConfigurationItemsFromApplicationRequest.Builder.() -> Unit): DisassociateConfigurationItemsFromApplicationResponse = disassociateConfigurationItemsFromApplication(DisassociateConfigurationItemsFromApplicationRequest.Builder().apply(block).build())

/**
 * Deprecated. Use `StartExportTask` instead.
 *
 * Exports all discovered configuration data to an Amazon S3 bucket or an application that enables you to view and evaluate the data. Data includes tags and tag associations, processes, connections, servers, and system performance. This API returns an export ID that you can query using the *DescribeExportConfigurations* API. The system imposes a limit of two configuration exports in six hours.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun ApplicationDiscoveryClient.exportConfigurations(crossinline block: ExportConfigurationsRequest.Builder.() -> Unit): ExportConfigurationsResponse = exportConfigurations(ExportConfigurationsRequest.Builder().apply(block).build())

/**
 * Retrieves a short summary of discovered assets.
 *
 * This API operation takes no request parameters and is called as is at the command prompt as shown in the example.
 */
public suspend inline fun ApplicationDiscoveryClient.getDiscoverySummary(crossinline block: GetDiscoverySummaryRequest.Builder.() -> Unit): GetDiscoverySummaryResponse = getDiscoverySummary(GetDiscoverySummaryRequest.Builder().apply(block).build())

/**
 * Retrieves a list of configuration items as specified by the value passed to the required parameter `configurationType`. Optional filtering may be applied to refine search results.
 */
public suspend inline fun ApplicationDiscoveryClient.listConfigurations(crossinline block: ListConfigurationsRequest.Builder.() -> Unit): ListConfigurationsResponse = listConfigurations(ListConfigurationsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of servers that are one network hop away from a specified server.
 */
public suspend inline fun ApplicationDiscoveryClient.listServerNeighbors(crossinline block: ListServerNeighborsRequest.Builder.() -> Unit): ListServerNeighborsResponse = listServerNeighbors(ListServerNeighborsRequest.Builder().apply(block).build())

/**
 * Start the continuous flow of agent's discovered data into Amazon Athena.
 */
public suspend inline fun ApplicationDiscoveryClient.startContinuousExport(crossinline block: StartContinuousExportRequest.Builder.() -> Unit): StartContinuousExportResponse = startContinuousExport(StartContinuousExportRequest.Builder().apply(block).build())

/**
 * Instructs the specified agents or connectors to start collecting data.
 */
public suspend inline fun ApplicationDiscoveryClient.startDataCollectionByAgentIds(crossinline block: StartDataCollectionByAgentIdsRequest.Builder.() -> Unit): StartDataCollectionByAgentIdsResponse = startDataCollectionByAgentIds(StartDataCollectionByAgentIdsRequest.Builder().apply(block).build())

/**
 * Begins the export of discovered data to an S3 bucket.
 *
 *  If you specify `agentIds` in a filter, the task exports up to 72 hours of detailed data collected by the identified Application Discovery Agent, including network, process, and performance details. A time range for exported agent data may be set by using `startTime` and `endTime`. Export of detailed agent data is limited to five concurrently running exports.
 *
 *  If you do not include an `agentIds` filter, summary data is exported that includes both Amazon Web Services Agentless Discovery Connector data and summary data from Amazon Web Services Discovery Agents. Export of summary data is limited to two exports per day.
 */
public suspend inline fun ApplicationDiscoveryClient.startExportTask(crossinline block: StartExportTaskRequest.Builder.() -> Unit): StartExportTaskResponse = startExportTask(StartExportTaskRequest.Builder().apply(block).build())

/**
 * Starts an import task, which allows you to import details of your on-premises environment directly into Amazon Web Services Migration Hub without having to use the Application Discovery Service (ADS) tools such as the Discovery Connector or Discovery Agent. This gives you the option to perform migration assessment and planning directly from your imported data, including the ability to group your devices as applications and track their migration status.
 *
 * To start an import request, do this:
 * + Download the specially formatted comma separated value (CSV) import template, which you can find here: [https://s3.us-west-2.amazonaws.com/templates-7cffcf56-bd96-4b1c-b45b-a5b42f282e46/import_template.csv](https://s3.us-west-2.amazonaws.com/templates-7cffcf56-bd96-4b1c-b45b-a5b42f282e46/import_template.csv).
 * + Fill out the template with your server and application data.
 * + Upload your import file to an Amazon S3 bucket, and make a note of it's Object URL. Your import file must be in the CSV format.
 * + Use the console or the `StartImportTask` command with the Amazon Web Services CLI or one of the Amazon Web Services SDKs to import the records from your file.
 *
 * For more information, including step-by-step procedures, see [Migration Hub Import](https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-import.html) in the *Amazon Web Services Application Discovery Service User Guide*.
 *
 * There are limits to the number of import tasks you can create (and delete) in an Amazon Web Services account. For more information, see [Amazon Web Services Application Discovery Service Limits](https://docs.aws.amazon.com/application-discovery/latest/userguide/ads_service_limits.html) in the *Amazon Web Services Application Discovery Service User Guide*.
 */
public suspend inline fun ApplicationDiscoveryClient.startImportTask(crossinline block: StartImportTaskRequest.Builder.() -> Unit): StartImportTaskResponse = startImportTask(StartImportTaskRequest.Builder().apply(block).build())

/**
 * Stop the continuous flow of agent's discovered data into Amazon Athena.
 */
public suspend inline fun ApplicationDiscoveryClient.stopContinuousExport(crossinline block: StopContinuousExportRequest.Builder.() -> Unit): StopContinuousExportResponse = stopContinuousExport(StopContinuousExportRequest.Builder().apply(block).build())

/**
 * Instructs the specified agents or connectors to stop collecting data.
 */
public suspend inline fun ApplicationDiscoveryClient.stopDataCollectionByAgentIds(crossinline block: StopDataCollectionByAgentIdsRequest.Builder.() -> Unit): StopDataCollectionByAgentIdsResponse = stopDataCollectionByAgentIds(StopDataCollectionByAgentIdsRequest.Builder().apply(block).build())

/**
 * Updates metadata about an application.
 */
public suspend inline fun ApplicationDiscoveryClient.updateApplication(crossinline block: UpdateApplicationRequest.Builder.() -> Unit): UpdateApplicationResponse = updateApplication(UpdateApplicationRequest.Builder().apply(block).build())
