// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationdiscoveryservice.paginators

import aws.sdk.kotlin.services.applicationdiscoveryservice.ApplicationDiscoveryClient
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeContinuousExportsRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeContinuousExportsResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeImportTasksRequest
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeImportTasksResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [DescribeContinuousExportsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeContinuousExportsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeContinuousExportsResponse]
 */
public fun ApplicationDiscoveryClient.describeContinuousExportsPaginated(initialRequest: DescribeContinuousExportsRequest): Flow<DescribeContinuousExportsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeContinuousExportsPaginated.describeContinuousExports(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeContinuousExportsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeContinuousExportsResponse]
 */
public fun ApplicationDiscoveryClient.describeContinuousExportsPaginated(block: DescribeContinuousExportsRequest.Builder.() -> Unit): Flow<DescribeContinuousExportsResponse> =
    describeContinuousExportsPaginated(DescribeContinuousExportsRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeImportTasksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeImportTasksRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeImportTasksResponse]
 */
public fun ApplicationDiscoveryClient.describeImportTasksPaginated(initialRequest: DescribeImportTasksRequest): Flow<DescribeImportTasksResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeImportTasksPaginated.describeImportTasks(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeImportTasksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeImportTasksResponse]
 */
public fun ApplicationDiscoveryClient.describeImportTasksPaginated(block: DescribeImportTasksRequest.Builder.() -> Unit): Flow<DescribeImportTasksResponse> =
    describeImportTasksPaginated(DescribeImportTasksRequest.Builder().apply(block).build())
