// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationdiscoveryservice.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An array of information related to the import task request that includes status information, times, IDs, the Amazon S3 Object URL for the import file, and more.
 */
public class ImportTask private constructor(builder: Builder) {
    /**
     * The total number of application records in the import file that failed to be imported.
     */
    public val applicationImportFailure: kotlin.Int = builder.applicationImportFailure
    /**
     * The total number of application records in the import file that were successfully imported.
     */
    public val applicationImportSuccess: kotlin.Int = builder.applicationImportSuccess
    /**
     * A unique token used to prevent the same import request from occurring more than once. If you didn't provide a token, a token was automatically generated when the import task request was sent.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * A link to a compressed archive folder (in the ZIP format) that contains an error log and a file of failed records. You can use these two files to quickly identify records that failed, why they failed, and correct those records. Afterward, you can upload the corrected file to your Amazon S3 bucket and create another import task request.
     *
     * This field also includes authorization information so you can confirm the authenticity of the compressed archive before you download it.
     *
     * If some records failed to be imported we recommend that you correct the records in the failed entries file and then imports that failed entries file. This prevents you from having to correct and update the larger original file and attempt importing it again.
     */
    public val errorsAndFailedEntriesZip: kotlin.String? = builder.errorsAndFailedEntriesZip
    /**
     * The time that the import task request finished, presented in the Unix time stamp format.
     */
    public val importCompletionTime: aws.smithy.kotlin.runtime.time.Instant? = builder.importCompletionTime
    /**
     * The time that the import task request was deleted, presented in the Unix time stamp format.
     */
    public val importDeletedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.importDeletedTime
    /**
     * The time that the import task request was made, presented in the Unix time stamp format.
     */
    public val importRequestTime: aws.smithy.kotlin.runtime.time.Instant? = builder.importRequestTime
    /**
     * The unique ID for a specific import task. These IDs aren't globally unique, but they are unique within an Amazon Web Services account.
     */
    public val importTaskId: kotlin.String? = builder.importTaskId
    /**
     * The URL for your import file that you've uploaded to Amazon S3.
     */
    public val importUrl: kotlin.String? = builder.importUrl
    /**
     * A descriptive name for an import task. You can use this name to filter future requests related to this import task, such as identifying applications and servers that were included in this import task. We recommend that you use a meaningful name for each import task.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The total number of server records in the import file that failed to be imported.
     */
    public val serverImportFailure: kotlin.Int = builder.serverImportFailure
    /**
     * The total number of server records in the import file that were successfully imported.
     */
    public val serverImportSuccess: kotlin.Int = builder.serverImportSuccess
    /**
     * The status of the import task. An import can have the status of `IMPORT_COMPLETE` and still have some records fail to import from the overall request. More information can be found in the downloadable archive defined in the `errorsAndFailedEntriesZip` field, or in the Migration Hub management console.
     */
    public val status: aws.sdk.kotlin.services.applicationdiscoveryservice.model.ImportStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.applicationdiscoveryservice.model.ImportTask = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImportTask(")
        append("applicationImportFailure=$applicationImportFailure,")
        append("applicationImportSuccess=$applicationImportSuccess,")
        append("clientRequestToken=$clientRequestToken,")
        append("errorsAndFailedEntriesZip=$errorsAndFailedEntriesZip,")
        append("importCompletionTime=$importCompletionTime,")
        append("importDeletedTime=$importDeletedTime,")
        append("importRequestTime=$importRequestTime,")
        append("importTaskId=$importTaskId,")
        append("importUrl=$importUrl,")
        append("name=$name,")
        append("serverImportFailure=$serverImportFailure,")
        append("serverImportSuccess=$serverImportSuccess,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationImportFailure
        result = 31 * result + (applicationImportSuccess)
        result = 31 * result + (clientRequestToken?.hashCode() ?: 0)
        result = 31 * result + (errorsAndFailedEntriesZip?.hashCode() ?: 0)
        result = 31 * result + (importCompletionTime?.hashCode() ?: 0)
        result = 31 * result + (importDeletedTime?.hashCode() ?: 0)
        result = 31 * result + (importRequestTime?.hashCode() ?: 0)
        result = 31 * result + (importTaskId?.hashCode() ?: 0)
        result = 31 * result + (importUrl?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (serverImportFailure)
        result = 31 * result + (serverImportSuccess)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImportTask

        if (applicationImportFailure != other.applicationImportFailure) return false
        if (applicationImportSuccess != other.applicationImportSuccess) return false
        if (clientRequestToken != other.clientRequestToken) return false
        if (errorsAndFailedEntriesZip != other.errorsAndFailedEntriesZip) return false
        if (importCompletionTime != other.importCompletionTime) return false
        if (importDeletedTime != other.importDeletedTime) return false
        if (importRequestTime != other.importRequestTime) return false
        if (importTaskId != other.importTaskId) return false
        if (importUrl != other.importUrl) return false
        if (name != other.name) return false
        if (serverImportFailure != other.serverImportFailure) return false
        if (serverImportSuccess != other.serverImportSuccess) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.applicationdiscoveryservice.model.ImportTask = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The total number of application records in the import file that failed to be imported.
         */
        public var applicationImportFailure: kotlin.Int = 0
        /**
         * The total number of application records in the import file that were successfully imported.
         */
        public var applicationImportSuccess: kotlin.Int = 0
        /**
         * A unique token used to prevent the same import request from occurring more than once. If you didn't provide a token, a token was automatically generated when the import task request was sent.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * A link to a compressed archive folder (in the ZIP format) that contains an error log and a file of failed records. You can use these two files to quickly identify records that failed, why they failed, and correct those records. Afterward, you can upload the corrected file to your Amazon S3 bucket and create another import task request.
         *
         * This field also includes authorization information so you can confirm the authenticity of the compressed archive before you download it.
         *
         * If some records failed to be imported we recommend that you correct the records in the failed entries file and then imports that failed entries file. This prevents you from having to correct and update the larger original file and attempt importing it again.
         */
        public var errorsAndFailedEntriesZip: kotlin.String? = null
        /**
         * The time that the import task request finished, presented in the Unix time stamp format.
         */
        public var importCompletionTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time that the import task request was deleted, presented in the Unix time stamp format.
         */
        public var importDeletedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time that the import task request was made, presented in the Unix time stamp format.
         */
        public var importRequestTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The unique ID for a specific import task. These IDs aren't globally unique, but they are unique within an Amazon Web Services account.
         */
        public var importTaskId: kotlin.String? = null
        /**
         * The URL for your import file that you've uploaded to Amazon S3.
         */
        public var importUrl: kotlin.String? = null
        /**
         * A descriptive name for an import task. You can use this name to filter future requests related to this import task, such as identifying applications and servers that were included in this import task. We recommend that you use a meaningful name for each import task.
         */
        public var name: kotlin.String? = null
        /**
         * The total number of server records in the import file that failed to be imported.
         */
        public var serverImportFailure: kotlin.Int = 0
        /**
         * The total number of server records in the import file that were successfully imported.
         */
        public var serverImportSuccess: kotlin.Int = 0
        /**
         * The status of the import task. An import can have the status of `IMPORT_COMPLETE` and still have some records fail to import from the overall request. More information can be found in the downloadable archive defined in the `errorsAndFailedEntriesZip` field, or in the Migration Hub management console.
         */
        public var status: aws.sdk.kotlin.services.applicationdiscoveryservice.model.ImportStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.applicationdiscoveryservice.model.ImportTask) : this() {
            this.applicationImportFailure = x.applicationImportFailure
            this.applicationImportSuccess = x.applicationImportSuccess
            this.clientRequestToken = x.clientRequestToken
            this.errorsAndFailedEntriesZip = x.errorsAndFailedEntriesZip
            this.importCompletionTime = x.importCompletionTime
            this.importDeletedTime = x.importDeletedTime
            this.importRequestTime = x.importRequestTime
            this.importTaskId = x.importTaskId
            this.importUrl = x.importUrl
            this.name = x.name
            this.serverImportFailure = x.serverImportFailure
            this.serverImportSuccess = x.serverImportSuccess
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.applicationdiscoveryservice.model.ImportTask = ImportTask(this)
    }
}
