// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationdiscoveryservice.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.AgentConfigurationStatus
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.ApplicationDiscoveryException
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.StartDataCollectionByAgentIdsResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class StartDataCollectionByAgentIdsOperationDeserializer: HttpDeserialize<StartDataCollectionByAgentIdsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): StartDataCollectionByAgentIdsResponse {
        if (!response.status.isSuccess()) {
            throwStartDataCollectionByAgentIdsError(context, response)
        }
        val builder = StartDataCollectionByAgentIdsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeStartDataCollectionByAgentIdsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwStartDataCollectionByAgentIdsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ApplicationDiscoveryException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AuthorizationErrorException" -> AuthorizationErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "HomeRegionNotSetException" -> HomeRegionNotSetExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServerInternalErrorException" -> ServerInternalErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ApplicationDiscoveryException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeStartDataCollectionByAgentIdsOperationBody(builder: StartDataCollectionByAgentIdsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AGENTSCONFIGURATIONSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("agentsConfigurationStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AGENTSCONFIGURATIONSTATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AGENTSCONFIGURATIONSTATUS_DESCRIPTOR.index -> builder.agentsConfigurationStatus =
                    deserializer.deserializeList(AGENTSCONFIGURATIONSTATUS_DESCRIPTOR) {
                        val col0 = mutableListOf<AgentConfigurationStatus>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAgentConfigurationStatusDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
