// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationdiscoveryservice.endpoints

import aws.smithy.kotlin.runtime.client.endpoints.Endpoint
import aws.smithy.kotlin.runtime.client.endpoints.EndpointProviderException
import aws.smithy.kotlin.runtime.net.Url
import kotlin.test.*
import kotlinx.coroutines.test.runTest

public class DefaultEndpointProviderTest {
    // For region ap-northeast-1 with FIPS disabled and DualStack disabled
    @Test
    fun test0() = runTest {
        val params = EndpointParameters {
            region = "ap-northeast-1"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://discovery.ap-northeast-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-2 with FIPS disabled and DualStack disabled
    @Test
    fun test1() = runTest {
        val params = EndpointParameters {
            region = "ap-southeast-2"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://discovery.ap-southeast-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-central-1 with FIPS disabled and DualStack disabled
    @Test
    fun test2() = runTest {
        val params = EndpointParameters {
            region = "eu-central-1"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://discovery.eu-central-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-1 with FIPS disabled and DualStack disabled
    @Test
    fun test3() = runTest {
        val params = EndpointParameters {
            region = "eu-west-1"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://discovery.eu-west-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-2 with FIPS disabled and DualStack disabled
    @Test
    fun test4() = runTest {
        val params = EndpointParameters {
            region = "eu-west-2"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://discovery.eu-west-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-1 with FIPS disabled and DualStack disabled
    @Test
    fun test5() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://discovery.us-east-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-west-2 with FIPS disabled and DualStack disabled
    @Test
    fun test6() = runTest {
        val params = EndpointParameters {
            region = "us-west-2"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://discovery.us-west-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-1 with FIPS enabled and DualStack enabled
    @Test
    fun test7() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://discovery-fips.us-east-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-1 with FIPS enabled and DualStack disabled
    @Test
    fun test8() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://discovery-fips.us-east-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-1 with FIPS disabled and DualStack enabled
    @Test
    fun test9() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://discovery.us-east-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region cn-north-1 with FIPS enabled and DualStack enabled
    @Test
    fun test10() = runTest {
        val params = EndpointParameters {
            region = "cn-north-1"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://discovery-fips.cn-north-1.api.amazonwebservices.com.cn"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region cn-north-1 with FIPS enabled and DualStack disabled
    @Test
    fun test11() = runTest {
        val params = EndpointParameters {
            region = "cn-north-1"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://discovery-fips.cn-north-1.amazonaws.com.cn"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region cn-north-1 with FIPS disabled and DualStack enabled
    @Test
    fun test12() = runTest {
        val params = EndpointParameters {
            region = "cn-north-1"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://discovery.cn-north-1.api.amazonwebservices.com.cn"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region cn-north-1 with FIPS disabled and DualStack disabled
    @Test
    fun test13() = runTest {
        val params = EndpointParameters {
            region = "cn-north-1"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://discovery.cn-north-1.amazonaws.com.cn"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-gov-east-1 with FIPS enabled and DualStack enabled
    @Test
    fun test14() = runTest {
        val params = EndpointParameters {
            region = "us-gov-east-1"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://discovery-fips.us-gov-east-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-gov-east-1 with FIPS enabled and DualStack disabled
    @Test
    fun test15() = runTest {
        val params = EndpointParameters {
            region = "us-gov-east-1"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://discovery-fips.us-gov-east-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-gov-east-1 with FIPS disabled and DualStack enabled
    @Test
    fun test16() = runTest {
        val params = EndpointParameters {
            region = "us-gov-east-1"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://discovery.us-gov-east-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-gov-east-1 with FIPS disabled and DualStack disabled
    @Test
    fun test17() = runTest {
        val params = EndpointParameters {
            region = "us-gov-east-1"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://discovery.us-gov-east-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-iso-east-1 with FIPS enabled and DualStack disabled
    @Test
    fun test18() = runTest {
        val params = EndpointParameters {
            region = "us-iso-east-1"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://discovery-fips.us-iso-east-1.c2s.ic.gov"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-iso-east-1 with FIPS disabled and DualStack disabled
    @Test
    fun test19() = runTest {
        val params = EndpointParameters {
            region = "us-iso-east-1"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://discovery.us-iso-east-1.c2s.ic.gov"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-isob-east-1 with FIPS enabled and DualStack disabled
    @Test
    fun test20() = runTest {
        val params = EndpointParameters {
            region = "us-isob-east-1"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://discovery-fips.us-isob-east-1.sc2s.sgov.gov"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-isob-east-1 with FIPS disabled and DualStack disabled
    @Test
    fun test21() = runTest {
        val params = EndpointParameters {
            region = "us-isob-east-1"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://discovery.us-isob-east-1.sc2s.sgov.gov"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For custom endpoint with region set and fips disabled and dualstack disabled
    @Test
    fun test22() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useDualStack = false
            useFips = false
            endpoint = "https://example.com"
        }
        val expected = Endpoint(
            uri = Url.parse("https://example.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For custom endpoint with region not set and fips disabled and dualstack disabled
    @Test
    fun test23() = runTest {
        val params = EndpointParameters {
            useDualStack = false
            useFips = false
            endpoint = "https://example.com"
        }
        val expected = Endpoint(
            uri = Url.parse("https://example.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For custom endpoint with fips enabled and dualstack disabled
    @Test
    fun test24() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useDualStack = false
            useFips = true
            endpoint = "https://example.com"
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid Configuration: FIPS and custom endpoint are not supported", ex.message)
    }

    // For custom endpoint with fips disabled and dualstack enabled
    @Test
    fun test25() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useDualStack = true
            useFips = false
            endpoint = "https://example.com"
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid Configuration: Dualstack and custom endpoint are not supported", ex.message)
    }

}
