// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationdiscoveryservice

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.applicationdiscoveryservice.auth.AuthSchemeProviderAdapter
import aws.sdk.kotlin.services.applicationdiscoveryservice.auth.IdentityProviderConfigAdapter
import aws.sdk.kotlin.services.applicationdiscoveryservice.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.*
import aws.sdk.kotlin.services.applicationdiscoveryservice.transform.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.awsprotocol.json.AwsJsonProtocol
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.sdkRequestId
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.tracing.withRootTraceSpan
import aws.smithy.kotlin.runtime.util.putIfAbsent
import kotlin.coroutines.coroutineContext


public const val ServiceId: String = "Application Discovery Service"
public const val ServiceApiVersion: String = "2015-11-01"
public const val SdkVersion: String = "0.27.1-beta"

internal class DefaultApplicationDiscoveryClient(override val config: ApplicationDiscoveryClient.Config) : ApplicationDiscoveryClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = IdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(HttpAuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "discovery")
        }
        toMap()
    }

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Associates one or more configuration items with an application.
     */
    override suspend fun associateConfigurationItemsToApplication(input: AssociateConfigurationItemsToApplicationRequest): AssociateConfigurationItemsToApplicationResponse {
        val op = SdkHttpOperation.build<AssociateConfigurationItemsToApplicationRequest, AssociateConfigurationItemsToApplicationResponse> {
            serializer = AssociateConfigurationItemsToApplicationOperationSerializer()
            deserializer = AssociateConfigurationItemsToApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "AssociateConfigurationItemsToApplication"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AWSPoseidonService_V2015_11_01", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("AssociateConfigurationItemsToApplication-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes one or more import tasks, each identified by their import ID. Each import task has a number of records that can identify servers or applications.
     *
     * Amazon Web Services Application Discovery Service has built-in matching logic that will identify when discovered servers match existing entries that you've previously discovered, the information for the already-existing discovered server is updated. When you delete an import task that contains records that were used to match, the information in those matched records that comes from the deleted records will also be deleted.
     */
    override suspend fun batchDeleteImportData(input: BatchDeleteImportDataRequest): BatchDeleteImportDataResponse {
        val op = SdkHttpOperation.build<BatchDeleteImportDataRequest, BatchDeleteImportDataResponse> {
            serializer = BatchDeleteImportDataOperationSerializer()
            deserializer = BatchDeleteImportDataOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "BatchDeleteImportData"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AWSPoseidonService_V2015_11_01", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("BatchDeleteImportData-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates an application with the given name and description.
     */
    override suspend fun createApplication(input: CreateApplicationRequest): CreateApplicationResponse {
        val op = SdkHttpOperation.build<CreateApplicationRequest, CreateApplicationResponse> {
            serializer = CreateApplicationOperationSerializer()
            deserializer = CreateApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateApplication"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AWSPoseidonService_V2015_11_01", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateApplication-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates one or more tags for configuration items. Tags are metadata that help you categorize IT assets. This API accepts a list of multiple configuration items.
     *
     * Do not store sensitive information (like personal data) in tags.
     */
    override suspend fun createTags(input: CreateTagsRequest): CreateTagsResponse {
        val op = SdkHttpOperation.build<CreateTagsRequest, CreateTagsResponse> {
            serializer = CreateTagsOperationSerializer()
            deserializer = CreateTagsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateTags"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AWSPoseidonService_V2015_11_01", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateTags-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a list of applications and their associations with configuration items.
     */
    override suspend fun deleteApplications(input: DeleteApplicationsRequest): DeleteApplicationsResponse {
        val op = SdkHttpOperation.build<DeleteApplicationsRequest, DeleteApplicationsResponse> {
            serializer = DeleteApplicationsOperationSerializer()
            deserializer = DeleteApplicationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteApplications"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AWSPoseidonService_V2015_11_01", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteApplications-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes the association between configuration items and one or more tags. This API accepts a list of multiple configuration items.
     */
    override suspend fun deleteTags(input: DeleteTagsRequest): DeleteTagsResponse {
        val op = SdkHttpOperation.build<DeleteTagsRequest, DeleteTagsResponse> {
            serializer = DeleteTagsOperationSerializer()
            deserializer = DeleteTagsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteTags"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AWSPoseidonService_V2015_11_01", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteTags-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists agents or collectors as specified by ID or other filters. All agents/collectors associated with your user can be listed if you call `DescribeAgents` as is without passing any parameters.
     */
    override suspend fun describeAgents(input: DescribeAgentsRequest): DescribeAgentsResponse {
        val op = SdkHttpOperation.build<DescribeAgentsRequest, DescribeAgentsResponse> {
            serializer = DescribeAgentsOperationSerializer()
            deserializer = DescribeAgentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeAgents"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AWSPoseidonService_V2015_11_01", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeAgents-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves attributes for a list of configuration item IDs.
     *
     * All of the supplied IDs must be for the same asset type from one of the following:
     * + server
     * + application
     * + process
     * + connection
     * Output fields are specific to the asset type specified. For example, the output for a *server* configuration item includes a list of attributes about the server, such as host name, operating system, number of network cards, etc.
     *
     * For a complete list of outputs for each asset type, see [Using the DescribeConfigurations Action](https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#DescribeConfigurations) in the *Amazon Web Services Application Discovery Service User Guide*.
     */
    override suspend fun describeConfigurations(input: DescribeConfigurationsRequest): DescribeConfigurationsResponse {
        val op = SdkHttpOperation.build<DescribeConfigurationsRequest, DescribeConfigurationsResponse> {
            serializer = DescribeConfigurationsOperationSerializer()
            deserializer = DescribeConfigurationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeConfigurations"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AWSPoseidonService_V2015_11_01", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeConfigurations-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists exports as specified by ID. All continuous exports associated with your user can be listed if you call `DescribeContinuousExports` as is without passing any parameters.
     */
    override suspend fun describeContinuousExports(input: DescribeContinuousExportsRequest): DescribeContinuousExportsResponse {
        val op = SdkHttpOperation.build<DescribeContinuousExportsRequest, DescribeContinuousExportsResponse> {
            serializer = DescribeContinuousExportsOperationSerializer()
            deserializer = DescribeContinuousExportsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeContinuousExports"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AWSPoseidonService_V2015_11_01", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeContinuousExports-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * `DescribeExportConfigurations` is deprecated. Use [DescribeExportTasks](https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeExportTasks.html), instead.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun describeExportConfigurations(input: DescribeExportConfigurationsRequest): DescribeExportConfigurationsResponse {
        val op = SdkHttpOperation.build<DescribeExportConfigurationsRequest, DescribeExportConfigurationsResponse> {
            serializer = DescribeExportConfigurationsOperationSerializer()
            deserializer = DescribeExportConfigurationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeExportConfigurations"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AWSPoseidonService_V2015_11_01", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeExportConfigurations-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieve status of one or more export tasks. You can retrieve the status of up to 100 export tasks.
     */
    override suspend fun describeExportTasks(input: DescribeExportTasksRequest): DescribeExportTasksResponse {
        val op = SdkHttpOperation.build<DescribeExportTasksRequest, DescribeExportTasksResponse> {
            serializer = DescribeExportTasksOperationSerializer()
            deserializer = DescribeExportTasksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeExportTasks"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AWSPoseidonService_V2015_11_01", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeExportTasks-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns an array of import tasks for your account, including status information, times, IDs, the Amazon S3 Object URL for the import file, and more.
     */
    override suspend fun describeImportTasks(input: DescribeImportTasksRequest): DescribeImportTasksResponse {
        val op = SdkHttpOperation.build<DescribeImportTasksRequest, DescribeImportTasksResponse> {
            serializer = DescribeImportTasksOperationSerializer()
            deserializer = DescribeImportTasksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeImportTasks"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AWSPoseidonService_V2015_11_01", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeImportTasks-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves a list of configuration items that have tags as specified by the key-value pairs, name and value, passed to the optional parameter `filters`.
     *
     * There are three valid tag filter names:
     * + tagKey
     * + tagValue
     * + configurationId
     *
     * Also, all configuration items associated with your user that have tags can be listed if you call `DescribeTags` as is without passing any parameters.
     */
    override suspend fun describeTags(input: DescribeTagsRequest): DescribeTagsResponse {
        val op = SdkHttpOperation.build<DescribeTagsRequest, DescribeTagsResponse> {
            serializer = DescribeTagsOperationSerializer()
            deserializer = DescribeTagsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeTags"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AWSPoseidonService_V2015_11_01", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeTags-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Disassociates one or more configuration items from an application.
     */
    override suspend fun disassociateConfigurationItemsFromApplication(input: DisassociateConfigurationItemsFromApplicationRequest): DisassociateConfigurationItemsFromApplicationResponse {
        val op = SdkHttpOperation.build<DisassociateConfigurationItemsFromApplicationRequest, DisassociateConfigurationItemsFromApplicationResponse> {
            serializer = DisassociateConfigurationItemsFromApplicationOperationSerializer()
            deserializer = DisassociateConfigurationItemsFromApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DisassociateConfigurationItemsFromApplication"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AWSPoseidonService_V2015_11_01", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DisassociateConfigurationItemsFromApplication-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deprecated. Use `StartExportTask` instead.
     *
     * Exports all discovered configuration data to an Amazon S3 bucket or an application that enables you to view and evaluate the data. Data includes tags and tag associations, processes, connections, servers, and system performance. This API returns an export ID that you can query using the *DescribeExportConfigurations* API. The system imposes a limit of two configuration exports in six hours.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun exportConfigurations(input: ExportConfigurationsRequest): ExportConfigurationsResponse {
        val op = SdkHttpOperation.build<ExportConfigurationsRequest, ExportConfigurationsResponse> {
            serializer = ExportConfigurationsOperationSerializer()
            deserializer = ExportConfigurationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ExportConfigurations"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AWSPoseidonService_V2015_11_01", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ExportConfigurations-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves a short summary of discovered assets.
     *
     * This API operation takes no request parameters and is called as is at the command prompt as shown in the example.
     */
    override suspend fun getDiscoverySummary(input: GetDiscoverySummaryRequest): GetDiscoverySummaryResponse {
        val op = SdkHttpOperation.build<GetDiscoverySummaryRequest, GetDiscoverySummaryResponse> {
            serializer = GetDiscoverySummaryOperationSerializer()
            deserializer = GetDiscoverySummaryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetDiscoverySummary"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AWSPoseidonService_V2015_11_01", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetDiscoverySummary-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves a list of configuration items as specified by the value passed to the required parameter `configurationType`. Optional filtering may be applied to refine search results.
     */
    override suspend fun listConfigurations(input: ListConfigurationsRequest): ListConfigurationsResponse {
        val op = SdkHttpOperation.build<ListConfigurationsRequest, ListConfigurationsResponse> {
            serializer = ListConfigurationsOperationSerializer()
            deserializer = ListConfigurationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListConfigurations"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AWSPoseidonService_V2015_11_01", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListConfigurations-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves a list of servers that are one network hop away from a specified server.
     */
    override suspend fun listServerNeighbors(input: ListServerNeighborsRequest): ListServerNeighborsResponse {
        val op = SdkHttpOperation.build<ListServerNeighborsRequest, ListServerNeighborsResponse> {
            serializer = ListServerNeighborsOperationSerializer()
            deserializer = ListServerNeighborsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListServerNeighbors"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AWSPoseidonService_V2015_11_01", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListServerNeighbors-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Start the continuous flow of agent's discovered data into Amazon Athena.
     */
    override suspend fun startContinuousExport(input: StartContinuousExportRequest): StartContinuousExportResponse {
        val op = SdkHttpOperation.build<StartContinuousExportRequest, StartContinuousExportResponse> {
            serializer = StartContinuousExportOperationSerializer()
            deserializer = StartContinuousExportOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "StartContinuousExport"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AWSPoseidonService_V2015_11_01", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StartContinuousExport-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Instructs the specified agents to start collecting data.
     */
    override suspend fun startDataCollectionByAgentIds(input: StartDataCollectionByAgentIdsRequest): StartDataCollectionByAgentIdsResponse {
        val op = SdkHttpOperation.build<StartDataCollectionByAgentIdsRequest, StartDataCollectionByAgentIdsResponse> {
            serializer = StartDataCollectionByAgentIdsOperationSerializer()
            deserializer = StartDataCollectionByAgentIdsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "StartDataCollectionByAgentIds"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AWSPoseidonService_V2015_11_01", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StartDataCollectionByAgentIds-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Begins the export of a discovered data report to an Amazon S3 bucket managed by Amazon Web Services.
     *
     * Exports might provide an estimate of fees and savings based on certain information that you provide. Fee estimates do not include any taxes that might apply. Your actual fees and savings depend on a variety of factors, including your actual usage of Amazon Web Services services, which might vary from the estimates provided in this report.
     *
     * If you do not specify `preferences` or `agentIds` in the filter, a summary of all servers, applications, tags, and performance is generated. This data is an aggregation of all server data collected through on-premises tooling, file import, application grouping and applying tags.
     *
     * If you specify `agentIds` in a filter, the task exports up to 72 hours of detailed data collected by the identified Application Discovery Agent, including network, process, and performance details. A time range for exported agent data may be set by using `startTime` and `endTime`. Export of detailed agent data is limited to five concurrently running exports. Export of detailed agent data is limited to two exports per day.
     *
     * If you enable `ec2RecommendationsPreferences` in `preferences` , an Amazon EC2 instance matching the characteristics of each server in Application Discovery Service is generated. Changing the attributes of the `ec2RecommendationsPreferences` changes the criteria of the recommendation.
     */
    override suspend fun startExportTask(input: StartExportTaskRequest): StartExportTaskResponse {
        val op = SdkHttpOperation.build<StartExportTaskRequest, StartExportTaskResponse> {
            serializer = StartExportTaskOperationSerializer()
            deserializer = StartExportTaskOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "StartExportTask"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AWSPoseidonService_V2015_11_01", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StartExportTask-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Starts an import task, which allows you to import details of your on-premises environment directly into Amazon Web Services Migration Hub without having to use the Amazon Web Services Application Discovery Service (Application Discovery Service) tools such as the Amazon Web Services Application Discovery Service Agentless Collector or Application Discovery Agent. This gives you the option to perform migration assessment and planning directly from your imported data, including the ability to group your devices as applications and track their migration status.
     *
     * To start an import request, do this:
     * + Download the specially formatted comma separated value (CSV) import template, which you can find here: [https://s3.us-west-2.amazonaws.com/templates-7cffcf56-bd96-4b1c-b45b-a5b42f282e46/import_template.csv](https://s3.us-west-2.amazonaws.com/templates-7cffcf56-bd96-4b1c-b45b-a5b42f282e46/import_template.csv).
     * + Fill out the template with your server and application data.
     * + Upload your import file to an Amazon S3 bucket, and make a note of it's Object URL. Your import file must be in the CSV format.
     * + Use the console or the `StartImportTask` command with the Amazon Web Services CLI or one of the Amazon Web Services SDKs to import the records from your file.
     *
     * For more information, including step-by-step procedures, see [Migration Hub Import](https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-import.html) in the *Amazon Web Services Application Discovery Service User Guide*.
     *
     * There are limits to the number of import tasks you can create (and delete) in an Amazon Web Services account. For more information, see [Amazon Web Services Application Discovery Service Limits](https://docs.aws.amazon.com/application-discovery/latest/userguide/ads_service_limits.html) in the *Amazon Web Services Application Discovery Service User Guide*.
     */
    override suspend fun startImportTask(input: StartImportTaskRequest): StartImportTaskResponse {
        val op = SdkHttpOperation.build<StartImportTaskRequest, StartImportTaskResponse> {
            serializer = StartImportTaskOperationSerializer()
            deserializer = StartImportTaskOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "StartImportTask"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AWSPoseidonService_V2015_11_01", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StartImportTask-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Stop the continuous flow of agent's discovered data into Amazon Athena.
     */
    override suspend fun stopContinuousExport(input: StopContinuousExportRequest): StopContinuousExportResponse {
        val op = SdkHttpOperation.build<StopContinuousExportRequest, StopContinuousExportResponse> {
            serializer = StopContinuousExportOperationSerializer()
            deserializer = StopContinuousExportOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "StopContinuousExport"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AWSPoseidonService_V2015_11_01", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StopContinuousExport-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Instructs the specified agents to stop collecting data.
     */
    override suspend fun stopDataCollectionByAgentIds(input: StopDataCollectionByAgentIdsRequest): StopDataCollectionByAgentIdsResponse {
        val op = SdkHttpOperation.build<StopDataCollectionByAgentIdsRequest, StopDataCollectionByAgentIdsResponse> {
            serializer = StopDataCollectionByAgentIdsOperationSerializer()
            deserializer = StopDataCollectionByAgentIdsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "StopDataCollectionByAgentIds"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AWSPoseidonService_V2015_11_01", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StopDataCollectionByAgentIds-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates metadata about an application.
     */
    override suspend fun updateApplication(input: UpdateApplicationRequest): UpdateApplicationResponse {
        val op = SdkHttpOperation.build<UpdateApplicationRequest, UpdateApplicationResponse> {
            serializer = UpdateApplicationOperationSerializer()
            deserializer = UpdateApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateApplication"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AWSPoseidonService_V2015_11_01", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateApplication-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "discovery")
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
